/*
 * Decompiled with CFR 0.152.
 */
package co.secretonline.accessiblestep;

import co.secretonline.accessiblestep.State;
import co.secretonline.accessiblestep.config.AccessibleStepConfigReader;
import co.secretonline.accessiblestep.event.KeyboardHandler;
import co.secretonline.accessiblestep.event.NetworkHandler;
import co.secretonline.accessiblestep.event.StepHeightHandler;
import com.mojang.blaze3d.platform.InputConstants;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessibleStepCommon {
    public static final String MOD_ID = "accessible-step";
    public static final String FORGE_MOD_ID = "accessible_step";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"accessible-step");
    public static final KeyMapping.Category ACCESSIBLE_STEP_KEYBINDING_CATEGORY = KeyMapping.Category.register((ResourceLocation)AccessibleStepCommon.id("title"));
    public static KeyMapping STEP_MODE_KEY_BINDING = new KeyMapping("key.accessiblestep.mode", InputConstants.Type.KEYSYM, -1, ACCESSIBLE_STEP_KEYBINDING_CATEGORY);
    private static AccessibleStepCommon SINGLETON_INSTANCE = null;
    private KeyboardHandler keyboardHandler;
    private StepHeightHandler stepHeightHandler;
    private NetworkHandler networkHandler;

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static AccessibleStepCommon init(Path configDir, BiConsumer<Player, Double> setStepHeight) {
        if (SINGLETON_INSTANCE == null) {
            SINGLETON_INSTANCE = new AccessibleStepCommon(configDir, setStepHeight);
        }
        return SINGLETON_INSTANCE;
    }

    private AccessibleStepCommon(Path configDir, BiConsumer<Player, Double> setStepHeight) {
        State.configReader = new AccessibleStepConfigReader(configDir);
        State.config = State.configReader.readConfig();
        this.keyboardHandler = new KeyboardHandler();
        this.stepHeightHandler = new StepHeightHandler(setStepHeight);
        this.networkHandler = new NetworkHandler();
    }

    public void onEndTick(Minecraft client) {
        this.keyboardHandler.onEndTick(client);
        this.stepHeightHandler.onEndTick(client);
    }

    public void onJoin(ServerData serverInfo, Minecraft client) {
        this.networkHandler.onJoin(serverInfo, client);
    }

    public void onLeave(Minecraft client) {
        this.networkHandler.onLeave(client);
    }

    public static void setStepHeightAttribute(Player player, double height) {
        AttributeInstance stepHeightAttribute = player.getAttribute(Attributes.STEP_HEIGHT);
        stepHeightAttribute.setBaseValue(height);
    }
}

