/*
 * Decompiled with CFR 0.152.
 */
package co.secretonline.accessiblestep.screen;

import co.secretonline.accessiblestep.Constants;
import co.secretonline.accessiblestep.State;
import co.secretonline.accessiblestep.StepMode;
import co.secretonline.accessiblestep.screen.AccessibleStepOptionsScreen;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class AccessibleStepOptions {
    public static final double MIN_STEP_HEIGHT = 0.0;
    public static final double MAX_STEP_HEIGHT_NORMAL = 2.5;
    public static final double MAX_STEP_HEIGHT_FULL = 10.0;
    private static final double STEP_HEIGHT_INCREMENTS_PER_BLOCK = 20.0;
    private static final Component STEP_MODE_OFF_TOOLTIP = Component.translatable((String)"options.accessiblestep.off.tooltip");
    private static final Component STEP_MODE_STEP_TOOLTIP = Component.translatable((String)"options.accessiblestep.step.tooltip");
    private static final Component STEP_MODE_AUTO_JUMP_TOOLTIP = Component.translatable((String)"options.accessiblestep.autojump.tooltip");
    private static final Component PER_WORLD_TOOLTIP = Component.translatable((String)"options.accessiblestep.perworld.tooltip");
    private static final Component FULL_RANGE_TOOLTIP = Component.translatable((String)"options.accessiblestep.fullrange.tooltip");
    private static final Component STEP_HEIGHT_TOOLTIP = Component.translatable((String)"options.accessiblestep.height.tooltip");
    private static final Component SNEAK_HEIGHT_TOOLTIP = Component.translatable((String)"options.accessiblestep.sneakheight.tooltip");
    private static final Component SPRINT_HEIGHT_TOOLTIP = Component.translatable((String)"options.accessiblestep.sprintheight.tooltip");
    private static final OptionInstance<StepMode> stepModeOption = new OptionInstance("options.accessiblestep.mode", AccessibleStepOptions::getStepModeTooltip, OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(StepMode.values()), StepMode.CODEC), (Object)StepMode.OFF, AccessibleStepOptions::onStepModeChange);
    private static final OptionInstance<Boolean> perWorldOption = OptionInstance.createBoolean((String)"options.accessiblestep.perworld", value -> Tooltip.create((Component)PER_WORLD_TOOLTIP), (boolean)false, AccessibleStepOptions::onPerWorldChange);
    private static final OptionInstance<Boolean> fullRangeOption = OptionInstance.createBoolean((String)"options.accessiblestep.fullrange", value -> Tooltip.create((Component)FULL_RANGE_TOOLTIP), (boolean)false, AccessibleStepOptions::onFullRangeChange);
    private static final OptionInstance<Double> stepHeightOption = new OptionInstance("options.accessiblestep.height", value -> Tooltip.create((Component)STEP_HEIGHT_TOOLTIP), AccessibleStepOptions::getStepHeightText, (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE.xmap(AccessibleStepOptions::toStepHeight, AccessibleStepOptions::fromStepHeight), Codec.doubleRange((double)0.0, (double)10.0), (Object)1.25, value -> State.config.setStepHeight((double)value));
    private static final OptionInstance<Double> sneakHeightOption = new OptionInstance("options.accessiblestep.sneakheight", value -> Tooltip.create((Component)SNEAK_HEIGHT_TOOLTIP), AccessibleStepOptions::getStepHeightText, (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE.xmap(AccessibleStepOptions::toStepHeight, AccessibleStepOptions::fromStepHeight), Codec.doubleRange((double)0.0, (double)10.0), (Object)Constants.MOD_DEFAULT_SNEAK_HEIGHT, value -> State.config.setSneakHeight((double)value));
    private static final OptionInstance<Double> sprintHeightOption = new OptionInstance("options.accessiblestep.sprintheight", value -> Tooltip.create((Component)SPRINT_HEIGHT_TOOLTIP), AccessibleStepOptions::getStepHeightText, (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE.xmap(AccessibleStepOptions::toStepHeight, AccessibleStepOptions::fromStepHeight), Codec.doubleRange((double)0.0, (double)10.0), (Object)1.25, value -> State.config.setSprintHeight((double)value));

    private static Tooltip getStepModeTooltip(StepMode value) {
        switch (value) {
            case OFF: {
                return Tooltip.create((Component)STEP_MODE_OFF_TOOLTIP);
            }
            case STEP: {
                return Tooltip.create((Component)STEP_MODE_STEP_TOOLTIP);
            }
            case AUTO_JUMP: {
                return Tooltip.create((Component)STEP_MODE_AUTO_JUMP_TOOLTIP);
            }
        }
        throw new IncompatibleClassChangeError();
    }

    private static void onStepModeChange(StepMode value) {
        State.config.setStepMode(value);
    }

    private static void onPerWorldChange(Boolean value) {
        State.config.setHasConfigForWorld(value);
        Minecraft client = Minecraft.getInstance();
        Screen screen = client.screen;
        if (screen instanceof AccessibleStepOptionsScreen) {
            AccessibleStepOptionsScreen optionsScreen = (AccessibleStepOptionsScreen)screen;
            optionsScreen.resetOptionsForWorld();
        }
    }

    private static void onFullRangeChange(Boolean value) {
        State.config.setFullRange(value);
        Minecraft client = Minecraft.getInstance();
        Screen screen = client.screen;
        if (screen instanceof AccessibleStepOptionsScreen) {
            AccessibleStepOptionsScreen optionsScreen = (AccessibleStepOptionsScreen)screen;
            optionsScreen.rescaleStepHeightSliders();
        }
    }

    private static double toStepHeight(double rangeValue) {
        double currentMaxHeight = (Boolean)fullRangeOption.get() != false ? 10.0 : 2.5;
        return AccessibleStepOptions.toStepHeight(rangeValue, currentMaxHeight);
    }

    private static double toStepHeight(double rangeValue, double maxValue) {
        double mappedValue = rangeValue * maxValue;
        return Math.floor(mappedValue * 20.0) / 20.0;
    }

    private static double fromStepHeight(double stepHeight) {
        double currentMaxHeight = (Boolean)fullRangeOption.get() != false ? 10.0 : 2.5;
        return AccessibleStepOptions.fromStepHeight(stepHeight, currentMaxHeight);
    }

    private static double fromStepHeight(double stepHeight, double maxValue) {
        return stepHeight / maxValue;
    }

    private static Component getStepHeightText(Component optionText, Double value) {
        return Component.translatable((String)"options.generic_value", (Object[])new Object[]{optionText, value});
    }

    public static OptionInstance<StepMode> getStepModeOption() {
        stepModeOption.set((Object)State.config.getStepMode());
        return stepModeOption;
    }

    public static OptionInstance<Boolean> getPerWorldOption() {
        perWorldOption.set((Object)State.config.hasConfigForWorld());
        return perWorldOption;
    }

    public static OptionInstance<Boolean> getFullRangeOption() {
        fullRangeOption.set((Object)State.config.getFullRange());
        return fullRangeOption;
    }

    public static OptionInstance<Double> getStepHeightOption() {
        stepHeightOption.set((Object)State.config.getStepHeight());
        return stepHeightOption;
    }

    public static OptionInstance<Double> getSneakHeightOption() {
        sneakHeightOption.set((Object)State.config.getSneakHeight());
        return sneakHeightOption;
    }

    public static OptionInstance<Double> getSprintHeightOption() {
        sprintHeightOption.set((Object)State.config.getSprintHeight());
        return sprintHeightOption;
    }
}

