/*
 * Decompiled with CFR 0.152.
 */
package co.secretonline.accessiblestep.screen;

import co.secretonline.accessiblestep.State;
import co.secretonline.accessiblestep.config.AccessibleStepConfig;
import co.secretonline.accessiblestep.mixin.SliderWidgetAccessor;
import co.secretonline.accessiblestep.screen.AccessibleStepOptions;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.network.chat.Component;

public class AccessibleStepOptionsScreen
extends OptionsSubScreen {
    private static OptionInstance<?>[] getOptions() {
        return new OptionInstance[]{AccessibleStepOptions.getPerWorldOption(), AccessibleStepOptions.getFullRangeOption(), AccessibleStepOptions.getStepModeOption(), AccessibleStepOptions.getStepHeightOption(), AccessibleStepOptions.getSneakHeightOption(), AccessibleStepOptions.getSprintHeightOption()};
    }

    public AccessibleStepOptionsScreen(Screen parent, Options gameOptions) {
        super(parent, gameOptions, (Component)Component.translatable((String)"options.accessiblestep.title"));
    }

    protected void addOptions() {
        this.list.addSmall(AccessibleStepOptionsScreen.getOptions());
        this.resetOptionsForWorld();
    }

    public void resetOptionsForWorld() {
        AccessibleStepOptions.getPerWorldOption().set((Object)State.config.hasConfigForWorld());
        AbstractWidget widget = this.list.findOption(AccessibleStepOptions.getPerWorldOption());
        if (widget != null && widget instanceof AbstractButton) {
            AbstractButton pressableWidget = (AbstractButton)widget;
            pressableWidget.active = State.worldName != null;
        }
        AccessibleStepOptions.getFullRangeOption().set((Object)State.config.getFullRange());
        AccessibleStepConfig.WorldConfig worldConfig = State.config.getCurrentWorldConfig();
        AccessibleStepOptions.getStepModeOption().set((Object)worldConfig.stepMode);
        AccessibleStepOptions.getStepHeightOption().set((Object)worldConfig.stepHeight);
        AccessibleStepOptions.getSneakHeightOption().set((Object)worldConfig.sneakHeight);
        AccessibleStepOptions.getSprintHeightOption().set((Object)worldConfig.sprintHeight);
        this.resetWidgets();
    }

    public void rescaleStepHeightSliders() {
        this.resetWidgets();
    }

    private void resetWidgets() {
        this.resetCyclingButtonWidget(AccessibleStepOptions.getPerWorldOption());
        this.resetCyclingButtonWidget(AccessibleStepOptions.getStepModeOption());
        this.resetCyclingButtonWidget(AccessibleStepOptions.getFullRangeOption());
        boolean isFullRange = (Boolean)AccessibleStepOptions.getFullRangeOption().get();
        double maxHeight = isFullRange ? 10.0 : 2.5;
        this.resetSliderWidget(AccessibleStepOptions.getStepHeightOption(), maxHeight);
        this.resetSliderWidget(AccessibleStepOptions.getSneakHeightOption(), maxHeight);
        this.resetSliderWidget(AccessibleStepOptions.getSprintHeightOption(), maxHeight);
    }

    private <T> void resetCyclingButtonWidget(OptionInstance<T> option) {
        AbstractWidget widget = this.list.findOption(option);
        if (widget != null && widget instanceof CycleButton) {
            CycleButton button = (CycleButton)widget;
            button.setValue(option.get());
        }
    }

    private void resetSliderWidget(OptionInstance<Double> option, double maxHeight) {
        AbstractWidget widget = this.list.findOption(option);
        if (widget != null && widget instanceof AbstractSliderButton) {
            ((SliderWidgetAccessor)widget).invokeSetValue((Double)option.get() / maxHeight);
        }
    }
}

