/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.api;

import draylar.tiered.Tiered;
import draylar.tiered.api.AttributeTemplate;
import draylar.tiered.api.TierComponent;
import draylar.tiered.api.TieredItemTags;
import draylar.tiered.config.ConfigInit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.levelz.access.LevelManagerAccess;
import net.levelz.level.LevelManager;
import net.levelz.level.Skill;
import net.libz.util.SortList;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ModifierUtils {
    @Nullable
    public static class_2960 getRandomAttributeIDFor(@Nullable class_1657 playerEntity, class_1792 item, boolean reforge) {
        int i;
        ArrayList potentialAttributes = new ArrayList();
        ArrayList<Integer> attributeWeights = new ArrayList<Integer>();
        Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().forEach((id, attribute) -> {
            if (attribute.isValid(class_7923.field_41178.method_10221((Object)item)) && (attribute.getWeight() > 0 || reforge)) {
                potentialAttributes.add(class_2960.method_60654((String)attribute.getID()));
                attributeWeights.add(reforge ? attribute.getWeight() + 1 : attribute.getWeight());
            }
        });
        if (potentialAttributes.size() <= 0) {
            return null;
        }
        if (reforge && attributeWeights.size() > 2) {
            SortList.concurrentSort(attributeWeights, (List[])new List[]{attributeWeights, potentialAttributes});
            int maxWeight = (Integer)attributeWeights.get(attributeWeights.size() - 1);
            for (i = 0; i < attributeWeights.size(); ++i) {
                if ((Integer)attributeWeights.get(i) <= maxWeight / 2) continue;
                attributeWeights.set(i, (int)((float)((Integer)attributeWeights.get(i)).intValue() * ConfigInit.CONFIG.reforgeModifier));
            }
        }
        if (Tiered.isLevelZLoaded && playerEntity != null) {
            LevelManager.SKILLS.values().stream().filter(skill -> skill.getKey().equals("smithing"));
            for (Skill skill2 : LevelManager.SKILLS.values()) {
                if (!skill2.getKey().equals("smithing")) continue;
                int newMaxWeight = (Integer)Collections.max(attributeWeights);
                for (int i2 = 0; i2 < attributeWeights.size(); ++i2) {
                    if ((Integer)attributeWeights.get(i2) <= newMaxWeight / 3) continue;
                    attributeWeights.set(i2, (int)((float)((Integer)attributeWeights.get(i2)).intValue() * (1.0f - ConfigInit.CONFIG.levelzReforgeModifier * (float)((LevelManagerAccess)playerEntity).getLevelManager().getSkillLevel(skill2.getId()))));
                }
            }
        }
        if (playerEntity != null) {
            int luckMaxWeight = (Integer)Collections.max(attributeWeights);
            for (i = 0; i < attributeWeights.size(); ++i) {
                if ((Integer)attributeWeights.get(i) <= luckMaxWeight / 3) continue;
                attributeWeights.set(i, (int)((float)((Integer)attributeWeights.get(i)).intValue() * (1.0f - ConfigInit.CONFIG.luckReforgeModifier * playerEntity.method_7292())));
            }
        }
        if (potentialAttributes.size() > 0) {
            int totalWeight = 0;
            for (Integer weight : attributeWeights) {
                totalWeight += weight.intValue();
            }
            int randomChoice = new Random().nextInt(totalWeight);
            SortList.concurrentSort(attributeWeights, (List[])new List[]{attributeWeights, potentialAttributes});
            for (int i3 = 0; i3 < attributeWeights.size(); ++i3) {
                if (randomChoice < (Integer)attributeWeights.get(i3)) {
                    return (class_2960)potentialAttributes.get(i3);
                }
                randomChoice -= ((Integer)attributeWeights.get(i3)).intValue();
            }
            return (class_2960)potentialAttributes.get(new Random().nextInt(potentialAttributes.size()));
        }
        return null;
    }

    public static void setItemStackAttribute(@Nullable class_1657 playerEntity, class_1799 stack, boolean reforge) {
        class_2960 potentialAttributeID;
        if (stack.method_57824(Tiered.TIER) == null && !stack.method_31573(TieredItemTags.MODIFIER_RESTRICTED) && (potentialAttributeID = ModifierUtils.getRandomAttributeIDFor(playerEntity, stack.method_7909(), reforge)) != null) {
            float durableFactor = -1.0f;
            int operation = 0;
            List<AttributeTemplate> attributeList = Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(class_2960.method_60654((String)potentialAttributeID.toString())).getAttributes();
            for (AttributeTemplate attributeTemplate : attributeList) {
                if (!attributeTemplate.getAttributeTypeID().equals("tiered:generic.durable")) continue;
                durableFactor = (float)Math.round(attributeTemplate.getEntityAttributeModifier().comp_2449() * 100.0) / 100.0f;
                operation = attributeTemplate.getEntityAttributeModifier().comp_2450().method_56082();
                break;
            }
            stack.method_57379(Tiered.TIER, (Object)new TierComponent(potentialAttributeID.toString(), durableFactor, operation));
        }
    }

    public static void removeItemStackAttribute(class_1799 itemStack) {
        if (itemStack.method_57824(Tiered.TIER) != null) {
            itemStack.method_57381(Tiered.TIER);
        }
    }

    @Nullable
    public static class_2960 getAttributeId(class_1799 itemStack) {
        if (itemStack.method_57824(Tiered.TIER) != null) {
            return class_2960.method_60654((String)((TierComponent)itemStack.method_57824(Tiered.TIER)).tier());
        }
        return null;
    }

    public static void updateItemStackComponent(class_1661 playerInventory) {
        for (int u = 0; u < playerInventory.method_5439(); ++u) {
            class_1799 itemStack = playerInventory.method_5438(u);
            if (itemStack.method_7960() || itemStack.method_57824(Tiered.TIER) == null) continue;
            ArrayList attributeIds = new ArrayList();
            Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().forEach((id, attribute) -> {
                if (attribute.isValid(class_7923.field_41178.method_10221((Object)itemStack.method_7909()))) {
                    attributeIds.add(attribute.getID());
                }
            });
            class_2960 attributeID = null;
            for (int i = 0; i < attributeIds.size(); ++i) {
                if (((TierComponent)itemStack.method_57824(Tiered.TIER)).tier().contains((CharSequence)attributeIds.get(i))) {
                    attributeID = class_2960.method_60654((String)((String)attributeIds.get(i)));
                    break;
                }
                if (i != attributeIds.size() - 1) continue;
                ModifierUtils.removeItemStackAttribute(itemStack);
                attributeID = ModifierUtils.getRandomAttributeIDFor(null, itemStack.method_7909(), false);
            }
            if (attributeID == null) continue;
            float durableFactor = -1.0f;
            int operation = 0;
            List<AttributeTemplate> attributeList = Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(class_2960.method_60654((String)attributeID.toString())).getAttributes();
            for (int i = 0; i < attributeList.size(); ++i) {
                if (!attributeList.get(i).getAttributeTypeID().equals("tiered:generic.durable")) continue;
                durableFactor = (float)Math.round(attributeList.get(i).getEntityAttributeModifier().comp_2449() * 100.0) / 100.0f;
                operation = attributeList.get(i).getEntityAttributeModifier().comp_2450().method_56082();
                break;
            }
            itemStack.method_57379(Tiered.TIER, (Object)new TierComponent(attributeID.toString(), durableFactor, operation));
            playerInventory.method_5447(u, itemStack);
        }
    }
}

