/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReforgeDataLoader
implements SimpleSynchronousResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger((String)"TieredZ");
    private List<class_2960> reforgeIdentifiers = new ArrayList<class_2960>();
    private Map<class_2960, List<class_1792>> reforgeBaseMap = new HashMap<class_2960, List<class_1792>>();

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"tiered", (String)"reforge_loader");
    }

    public void method_14491(class_3300 resourceManager) {
        resourceManager.method_14488("reforge_items", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
            try {
                InputStream stream = resourceRef.method_14482();
                JsonObject data = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                for (int u = 0; u < data.getAsJsonArray("items").size(); ++u) {
                    if (((class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)data.getAsJsonArray("items").get(u).getAsString()))).toString().equals("air")) {
                        LOGGER.info("Resource {} was not loaded cause {} is not a valid item identifier", (Object)id.toString(), (Object)data.getAsJsonArray("items").get(u).getAsString());
                        continue;
                    }
                    ArrayList<class_1792> baseItems = new ArrayList<class_1792>();
                    for (int i = 0; i < data.getAsJsonArray("base").size(); ++i) {
                        if (((class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)data.getAsJsonArray("base").get(i).getAsString()))).toString().equals("air")) {
                            LOGGER.info("Resource {} was not loaded cause {} is not a valid item identifier", (Object)id.toString(), (Object)data.getAsJsonArray("base").get(i).getAsString());
                            continue;
                        }
                        baseItems.add((class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)data.getAsJsonArray("base").get(i).getAsString())));
                    }
                    this.reforgeIdentifiers.add(class_2960.method_60654((String)data.getAsJsonArray("items").get(u).getAsString()));
                    this.reforgeBaseMap.put(class_2960.method_60654((String)data.getAsJsonArray("items").get(u).getAsString()), baseItems);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
            }
        });
    }

    public List<class_1792> getReforgeBaseItems(class_1792 item) {
        ArrayList<class_1792> list = new ArrayList<class_1792>();
        if (this.reforgeBaseMap.containsKey(class_7923.field_41178.method_10221((Object)item))) {
            return this.reforgeBaseMap.get(class_7923.field_41178.method_10221((Object)item));
        }
        return list;
    }

    public void putReforgeBaseItems(class_2960 id, List<class_1792> items) {
        this.reforgeBaseMap.put(id, items);
    }

    public void clearReforgeBaseItems() {
        this.reforgeBaseMap.clear();
    }

    public List<class_2960> getReforgeIdentifiers() {
        return this.reforgeIdentifiers;
    }
}

