/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.network;

import draylar.tiered.Tiered;
import draylar.tiered.access.AnvilScreenHandlerAccess;
import draylar.tiered.data.AttributeDataLoader;
import draylar.tiered.network.packet.AttributePacket;
import draylar.tiered.network.packet.HealthPacket;
import draylar.tiered.network.packet.ReforgeItemSyncPacket;
import draylar.tiered.network.packet.ReforgePacket;
import draylar.tiered.network.packet.ReforgeReadyPacket;
import draylar.tiered.network.packet.ReforgeScreenPacket;
import draylar.tiered.reforge.ReforgeScreenHandler;
import java.util.ArrayList;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.libz.network.LibzServerPacket;
import net.minecraft.class_1703;
import net.minecraft.class_1706;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3914;
import net.minecraft.class_747;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

public class TieredServerPacket {
    public static void init() {
        PayloadTypeRegistry.playS2C().register(AttributePacket.PACKET_ID, AttributePacket.PACKET_CODEC);
        PayloadTypeRegistry.playS2C().register(HealthPacket.PACKET_ID, HealthPacket.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(ReforgePacket.PACKET_ID, ReforgePacket.PACKET_CODEC);
        PayloadTypeRegistry.playS2C().register(ReforgeReadyPacket.PACKET_ID, ReforgeReadyPacket.PACKET_CODEC);
        PayloadTypeRegistry.playS2C().register(ReforgeItemSyncPacket.PACKET_ID, ReforgeItemSyncPacket.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(ReforgeScreenPacket.PACKET_ID, ReforgeScreenPacket.PACKET_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ReforgeScreenPacket.PACKET_ID, (payload, context) -> {
            class_2338 pos;
            int mouseX = payload.mouseX();
            int mouseY = payload.mouseY();
            Boolean reforgingScreen = payload.reforgingScreen();
            class_2338 class_23382 = reforgingScreen.booleanValue() ? (context.player().field_7512 instanceof class_1706 ? ((AnvilScreenHandlerAccess)context.player().field_7512).getPos() : null) : (pos = context.player().field_7512 instanceof ReforgeScreenHandler ? ((ReforgeScreenHandler)context.player().field_7512).getPos() : null);
            if (pos != null) {
                context.server().execute(() -> {
                    if (reforgingScreen.booleanValue()) {
                        context.player().method_17355((class_3908)new class_747((syncId, playerInventory, playerx) -> new ReforgeScreenHandler(syncId, playerInventory, class_3914.method_17392((class_1937)playerx.method_37908(), (class_2338)pos)), (class_2561)class_2561.method_43471((String)"container.reforge")));
                    } else {
                        context.player().method_17355((class_3908)new class_747((syncId, playerInventory, playerx) -> new class_1706(syncId, playerInventory, class_3914.method_17392((class_1937)playerx.method_37908(), (class_2338)pos)), (class_2561)class_2561.method_43471((String)"container.repair")));
                    }
                    LibzServerPacket.writeS2CMousePositionPacket((class_3222)context.player(), (int)mouseX, (int)mouseY);
                });
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(ReforgePacket.PACKET_ID, (payload, context) -> context.server().execute(() -> {
            class_1703 patt0$temp = context.player().field_7512;
            if (patt0$temp instanceof ReforgeScreenHandler) {
                ReforgeScreenHandler reforgeScreenHandler = (ReforgeScreenHandler)patt0$temp;
                reforgeScreenHandler.reforge();
            }
        }));
    }

    public static void writeS2CHealthPacket(class_3222 serverPlayerEntity) {
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new HealthPacket(serverPlayerEntity.method_6032()));
    }

    public static void writeS2CReforgeReadyPacket(class_3222 serverPlayerEntity, boolean disableButton) {
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new ReforgeReadyPacket(disableButton));
    }

    public static void writeS2CReforgeItemSyncPacket(class_3222 serverPlayerEntity) {
        ArrayList<class_2960> ids = new ArrayList<class_2960>();
        ArrayList<Integer> listSize = new ArrayList<Integer>();
        ArrayList<Integer> itemIds = new ArrayList<Integer>();
        Tiered.REFORGE_DATA_LOADER.getReforgeIdentifiers().forEach(id -> {
            ids.add((class_2960)id);
            ArrayList list = new ArrayList();
            Tiered.REFORGE_DATA_LOADER.getReforgeBaseItems((class_1792)class_7923.field_41178.method_10223(id)).forEach(item -> list.add(class_7923.field_41178.method_10206(item)));
            listSize.add(list.size());
            list.forEach(rawId -> itemIds.add((Integer)rawId));
        });
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new ReforgeItemSyncPacket(ids, listSize, itemIds));
    }

    public static void writeS2CAttributePacket(class_3222 serverPlayerEntity) {
        ArrayList<String> attributeIds = new ArrayList<String>();
        ArrayList<String> attributeJsons = new ArrayList<String>();
        Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().forEach((id, attribute) -> {
            attributeIds.add(id.toString());
            attributeJsons.add(AttributeDataLoader.GSON.toJson(attribute));
        });
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new AttributePacket(attributeIds, attributeJsons));
    }
}

