/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moyai;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moyai.MoyaiBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class Moyai {
    public static final String MOD_ID = "moyai";
    public static final Supplier<SoundEvent> MOYAI_BOOM_SOUND = RegHelper.registerSound((ResourceLocation)Moyai.res("record.moyai_boom"));
    public static final Supplier<SoundEvent> MOYAI_ROTATE = RegHelper.registerSound((ResourceLocation)Moyai.res("block.moyai_rotate"));
    public static final Supplier<SoundEvent> MOYAI_THINK = RegHelper.registerSound((ResourceLocation)Moyai.res("block.moyai_think"));
    public static final Supplier<Block> MOYAI_BLOCK = RegHelper.registerBlock((ResourceLocation)Moyai.res("moyai"), () -> new MoyaiBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BASALT).randomTicks().strength(5.0f, 4.0f)));
    public static final Supplier<BlockItem> MOYAI_ITEM = RegHelper.registerItem((ResourceLocation)Moyai.res("moyai"), () -> new BlockItem(MOYAI_BLOCK.get(), new Item.Properties().rarity(Rarity.RARE)));
    public static final Supplier<PoiType> MOYAI_POI = RegHelper.register((ResourceLocation)Moyai.res("moyai"), () -> new PoiType((Set)ImmutableSet.builder().addAll((Iterable)MOYAI_BLOCK.get().getStateDefinition().getPossibleStates()).build(), 1, 1), (ResourceKey)Registries.POINT_OF_INTEREST_TYPE);
    public static final TagKey<PoiType> MOYAI_POI_TAG = TagKey.create((ResourceKey)Registries.POINT_OF_INTEREST_TYPE, (ResourceLocation)Moyai.res("moyai"));
    public static final RegSupplier<GameEvent> MOYAI_BOOM_EVENT = RegHelper.register((ResourceLocation)Moyai.res("moyai_boom"), () -> new GameEvent(16), (ResourceKey)Registries.GAME_EVENT);
    public static final boolean SUPP_INSTALLED = PlatHelper.isModLoaded((String)"supplementaries");
    public static final Supplier<Item> SOAP = Suppliers.memoize(() -> BuiltInRegistries.ITEM.getOptional(ResourceLocation.tryParse((String)"supplementaries:soap")).orElse(null));
    public static final Supplier<Block> BUBBLE_BLOCK = Suppliers.memoize(() -> BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse((String)"supplementaries:bubble_block")).orElse(null));

    public static ResourceLocation res(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static void commonInit() {
        RegHelper.addItemsToTabsRegistration(Moyai::onAddItemToTabs);
        PlatHelper.addCommonSetup(Moyai::commonSetup);
    }

    private static void onAddItemToTabs(RegHelper.ItemToTabEvent event) {
        event.add(CreativeModeTabs.FUNCTIONAL_BLOCKS, new ItemLike[]{(ItemLike)MOYAI_BLOCK.get()});
        event.add(CreativeModeTabs.NATURAL_BLOCKS, new ItemLike[]{(ItemLike)MOYAI_BLOCK.get()});
    }

    public static void commonSetup() {
        Item soap = SOAP.get();
        if (soap != null) {
            DispenserBlock.registerBehavior((ItemLike)soap, (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

                protected ItemStack execute(BlockSource source, ItemStack stack) {
                    BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
                    BlockState state = source.level().getBlockState(pos);
                    if (state.is(MOYAI_BLOCK.get()) && MoyaiBlock.maybeEatSoap(stack, state, pos, (Level)source.level(), null)) {
                        return stack;
                    }
                    return super.execute(source, stack);
                }
            });
        }
    }

    public static boolean onNotePlayed(LevelAccessor level, BlockPos pos, BlockState blockState) {
        BlockState below;
        if (blockState.getValue((Property)NoteBlock.INSTRUMENT) == NoteBlockInstrument.BASEDRUM && (below = level.getBlockState(pos.below())).getBlock() instanceof MoyaiBlock && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level.gameEvent(null, MOYAI_BOOM_EVENT.getHolder(), pos);
            int i = (Integer)blockState.getValue((Property)NoteBlock.NOTE);
            float f = (float)Math.pow(2.0, (double)(i - 12) / 12.0);
            level.playSound(null, pos, MOYAI_BOOM_SOUND.get(), SoundSource.RECORDS, 0.5f, f);
            serverLevel.blockEvent(pos.below(), below.getBlock(), 0, i);
            return true;
        }
        return false;
    }
}

