/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moyai;

import com.mojang.serialization.MapCodec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Locale;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moyai.Moyai;
import net.mehvahdjukaar.moyai.neoforge.MoyaiBlockImpl;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoyaiBlock
extends FallingBlock {
    public static final MapCodec<MoyaiBlock> CODEC = MoyaiBlock.simpleCodec(MoyaiBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty BOTTOM = BlockStateProperties.BOTTOM;
    public static final EnumProperty<RotationMode> MODE = EnumProperty.create((String)"mode", RotationMode.class);
    private static long LAST_GREETED_TIME = -24000L;
    @Nullable
    private BlockPattern ironGolemBase;
    @Nullable
    private BlockPattern ironGolemFull;

    protected MoyaiBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).setValue(MODE, (Comparable)((Object)RotationMode.STATIC)));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        level.scheduleTick(currentPos, (Block)this, this.getDelayAfterPlace());
        if (direction == Direction.UP) {
            boolean shouldBeBottom;
            boolean bl = shouldBeBottom = this.isMoyaiSameFacing(state, neighborState) && !this.isMoyaiSameFacing(state, level.getBlockState(currentPos.below()));
            if ((Boolean)state.getValue((Property)BOTTOM) != shouldBeBottom) {
                return (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(shouldBeBottom));
            }
        } else if (direction == Direction.DOWN) {
            boolean shouldNotBeBottom = this.isMoyaiSameFacing(state, neighborState);
            if (shouldNotBeBottom) {
                if (((Boolean)state.getValue((Property)BOTTOM)).booleanValue()) {
                    return (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(false));
                }
            } else if (this.isMoyaiSameFacing(state, level.getBlockState(currentPos.above()))) {
                return (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true));
            }
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    private boolean isMoyaiSameFacing(BlockState state, BlockState neighborState) {
        return neighborState.is((Block)this) && neighborState.getValue((Property)FACING) == state.getValue((Property)FACING);
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos pos;
        Level level = pContext.getLevel();
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue(MODE, (Comparable)((Object)RotationMode.STATIC))).setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
        boolean bottom = this.isMoyaiSameFacing(state, level.getBlockState((pos = pContext.getClickedPos()).above())) && !this.isMoyaiSameFacing(state, level.getBlockState(pos.below()));
        return (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(bottom));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING, MODE, BOTTOM});
    }

    public static boolean maybeEatSoap(ItemStack stack, BlockState state, BlockPos pos, Level level, @Nullable Player player) {
        BlockPos facingPos;
        if (Moyai.SUPP_INSTALLED && stack.is(Moyai.SOAP.get()) && level.getBlockState(facingPos = pos.relative((Direction)state.getValue((Property)FACING))).isAir()) {
            if (player == null || player.isCreative()) {
                stack.shrink(1);
            }
            if (level.isClientSide && player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"message.moyai.soap"), true);
            } else {
                level.setBlockAndUpdate(facingPos, Moyai.BUBBLE_BLOCK.get().defaultBlockState());
            }
            return true;
        }
        return false;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        long time;
        if (Utils.getID((Item)stack.getItem()).toString().equals("yippee:moyai_statue")) {
            if (level.isClientSide) {
                player.displayClientMessage((Component)Component.translatable((String)"message.moyai.child"), true);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (MoyaiBlock.maybeEatSoap(stack, state, pos, level, player)) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (level.isClientSide && Math.abs((time = level.getDayTime()) - LAST_GREETED_TIME) >= 12000L) {
            LAST_GREETED_TIME = time;
            player.displayClientMessage((Component)Component.translatable((String)"message.moyai.angelo"), true);
            player.swing(hand);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (level instanceof WorldGenRegion) {
            if (!MoyaiBlock.isValidBiome((Holder<Biome>)level.getBiome(pos))) {
                return false;
            }
            Direction direction = (Direction)state.getValue((Property)FACING);
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockState s = level.getBlockState(pos.relative(dir));
                if (dir == direction && !s.isAir()) {
                    return false;
                }
                if (!s.is((Block)this) || s.getValue((Property)FACING) != dir.getOpposite()) continue;
                return false;
            }
        }
        return true;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static boolean isValidBiome(Holder<Biome> biome) {
        return MoyaiBlockImpl.isValidBiome(biome);
    }

    public int getDustColor(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return pState.getMapColor((BlockGetter)pReader, (BlockPos)pPos).col;
    }

    protected void falling(FallingBlockEntity pFallingEntity) {
        pFallingEntity.setHurtsEntities(2.0f, 40);
    }

    public void onLand(Level level, BlockPos pos, BlockState state, BlockState oldState, FallingBlockEntity blockEntity) {
        BlockState newState;
        if (!blockEntity.isSilent()) {
            level.levelEvent(1045, pos, 0);
            this.trySpawnGolem(level, pos, false);
        }
        if ((newState = this.updateShape(state, Direction.UP, level.getBlockState(pos.above()), (LevelAccessor)level, pos, pos.above())) != state) {
            level.setBlockAndUpdate(pos, newState);
        }
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        pLevel.scheduleTick(pPos, (Block)this, this.getDelayAfterPlace());
    }

    protected MapCodec<? extends MoyaiBlock> codec() {
        return CODEC;
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.is(pState.getBlock())) {
            this.trySpawnGolem(pLevel, pPos, true);
        }
    }

    public boolean canSpawnGolem(LevelReader pLevel, BlockPos pPos) {
        return this.getOrCreateIronGolemBase().find(pLevel, pPos) != null;
    }

    private boolean trySpawnGolem(Level pLevel, BlockPos pPos, boolean playerCreated) {
        BlockPattern pattern = this.getOrCreateIronGolemFull();
        BlockPattern.BlockPatternMatch patternMatch = pattern.find((LevelReader)pLevel, pPos);
        if (patternMatch != null) {
            for (int j = 0; j < pattern.getWidth(); ++j) {
                for (int k = 0; k < pattern.getHeight(); ++k) {
                    BlockInWorld matchBlock = patternMatch.getBlock(j, k, 0);
                    pLevel.setBlock(matchBlock.getPos(), Blocks.AIR.defaultBlockState(), 2);
                    pLevel.levelEvent(2001, matchBlock.getPos(), Block.getId((BlockState)matchBlock.getState()));
                }
            }
            BlockPos blockpos = patternMatch.getBlock(1, 2, 0).getPos();
            IronGolem irongolem = (IronGolem)EntityType.IRON_GOLEM.create(pLevel);
            irongolem.setPlayerCreated(playerCreated);
            irongolem.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)this));
            irongolem.moveTo((double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.05, (double)blockpos.getZ() + 0.5, 0.0f, 0.0f);
            pLevel.addFreshEntity((Entity)irongolem);
            for (ServerPlayer player : pLevel.getEntitiesOfClass(ServerPlayer.class, irongolem.getBoundingBox().inflate(5.0))) {
                CriteriaTriggers.SUMMONED_ENTITY.trigger(player, (Entity)irongolem);
            }
            for (int i1 = 0; i1 < pattern.getWidth(); ++i1) {
                for (int j1 = 0; j1 < pattern.getHeight(); ++j1) {
                    BlockInWorld matchBlock = patternMatch.getBlock(i1, j1, 0);
                    pLevel.blockUpdated(matchBlock.getPos(), Blocks.AIR);
                }
            }
            return true;
        }
        return false;
    }

    private BlockPattern getOrCreateIronGolemBase() {
        if (this.ironGolemBase == null) {
            this.ironGolemBase = BlockPatternBuilder.start().aisle(new String[]{"~ ~", "###", "~#~"}).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.IRON_BLOCK))).where('~', BlockInWorld.hasState(BlockBehaviour.BlockStateBase::isAir)).build();
        }
        return this.ironGolemBase;
    }

    private BlockPattern getOrCreateIronGolemFull() {
        if (this.ironGolemFull == null) {
            this.ironGolemFull = BlockPatternBuilder.start().aisle(new String[]{"~^~", "###", "~#~"}).where('^', BlockInWorld.hasState(b -> b.getBlock() == this)).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.IRON_BLOCK))).where('~', BlockInWorld.hasState(BlockBehaviour.BlockStateBase::isAir)).build();
        }
        return this.ironGolemFull;
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return (Boolean)pState.getValue((Property)BOTTOM) == false;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        long count;
        if (pState.getValue(MODE) == RotationMode.STATIC && pLevel.isNight()) {
            int i = pLevel.getMoonPhase();
            if (i == 0 || i == 4) {
                BlockState below = pLevel.getBlockState(pPos.below());
                Direction facing = (Direction)pState.getValue((Property)FACING);
                Direction dir = null;
                if (pLevel.random.nextBoolean() && MoyaiBlock.canSee(pLevel, pPos, facing.getCounterClockWise())) {
                    dir = facing.getCounterClockWise();
                    this.rotateWithBelow(pState, pLevel, pPos, below, dir, RotationMode.ROTATING_LEFT);
                } else if (MoyaiBlock.canSee(pLevel, pPos, facing.getClockWise())) {
                    dir = facing.getClockWise();
                    this.rotateWithBelow(pState, pLevel, pPos, below, dir, RotationMode.ROTATING_RIGHT);
                }
                if (dir != null) {
                    pLevel.playSound(null, pPos, Moyai.MOYAI_ROTATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    pLevel.scheduleTick(pPos, (Block)this, 40 + pLevel.getRandom().nextInt(40));
                    MoyaiBlock.scarePlayers(pLevel, pPos, dir);
                }
            }
            return;
        }
        if ((double)pLevel.random.nextFloat() < 0.3 && (count = pLevel.getPoiManager().getCountInRange(p -> p.is(Moyai.MOYAI_POI_TAG), pPos, 10, PoiManager.Occupancy.ANY)) >= 5L) {
            pLevel.playSound(null, pPos, Moyai.MOYAI_THINK.get(), SoundSource.BLOCKS, 0.5f, 1.0f + pLevel.random.nextFloat() * 0.1f - pLevel.random.nextFloat() * 0.07f);
        }
    }

    private static void scarePlayers(ServerLevel pLevel, BlockPos pPos, Direction dir) {
        for (Player p : pLevel.getEntitiesOfClass(Player.class, new AABB(pPos).inflate(5.0))) {
            Vec3 playerFacing;
            Vec3 facingMoyai;
            double dot;
            Vec3 eyePosition = p.getEyePosition();
            BlockHitResult c = pLevel.clip(new ClipContext(eyePosition, pPos.getCenter(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)p));
            if (!c.getBlockPos().equals((Object)pPos) || !((dot = (facingMoyai = new Vec3(dir.getOpposite().step())).dot(playerFacing = p.getViewVector(0.0f).normalize())) > 0.6)) continue;
            p.playNotifySound(Moyai.MOYAI_BOOM_SOUND.get(), SoundSource.BLOCKS, 0.05f, 1.0f);
        }
    }

    @NotNull
    private static boolean canSee(ServerLevel pLevel, BlockPos pos, Direction dir) {
        return !pLevel.getBlockState(pos.relative(dir)).isRedstoneConductor((BlockGetter)pLevel, pos);
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRand) {
        BlockState above;
        RotationMode mode = (RotationMode)((Object)pState.getValue(MODE));
        boolean bottom = (Boolean)pState.getValue((Property)BOTTOM);
        if (mode != RotationMode.STATIC && !bottom) {
            BlockState below = pLevel.getBlockState(pPos.below());
            Direction dir = mode == RotationMode.ROTATING_RIGHT ? ((Direction)pState.getValue((Property)FACING)).getCounterClockWise() : ((Direction)pState.getValue((Property)FACING)).getClockWise();
            this.rotateWithBelow(pState, pLevel, pPos, below, dir, RotationMode.STATIC);
            pLevel.playSound(null, pPos, Moyai.MOYAI_ROTATE.get(), SoundSource.BLOCKS, 1.0f, 0.8f);
            MoyaiBlock.scarePlayers(pLevel, pPos, dir);
        }
        super.tick(pState, pLevel, pPos, pRand);
        if (bottom && (above = pLevel.getBlockState(pPos.above())).is((Block)this)) {
            above.tick(pLevel, pPos.above(), pRand);
        }
    }

    private void rotateWithBelow(BlockState pState, ServerLevel pLevel, BlockPos pPos, BlockState below, Direction dir, RotationMode mode) {
        pLevel.setBlock(pPos, (BlockState)((BlockState)pState.setValue(MODE, (Comparable)((Object)mode))).setValue((Property)FACING, (Comparable)dir), 18);
        if (this.isMoyaiSameFacing(pState, below) && ((Boolean)below.getValue((Property)BOTTOM)).booleanValue()) {
            pLevel.setBlock(pPos.below(), (BlockState)below.setValue((Property)FACING, (Comparable)dir), 18);
        }
    }

    public boolean triggerEvent(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        if (pId == 0) {
            pLevel.addParticle((ParticleOptions)ParticleTypes.NOTE, (double)pPos.getX() + 0.5, (double)pPos.getY() + 1.2 + 1.0, (double)pPos.getZ() + 0.5, (double)pParam / 24.0, 0.0, 0.0);
            if (pLevel.isClientSide) {
                MoyaiBlock.setShaking(pPos, pParam);
            }
            return true;
        }
        return super.triggerEvent(pState, pLevel, pPos, pId, pParam);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void setShaking(BlockPos pPos, int pParam) {
        void var1_1;
        MoyaiBlockImpl.setShaking(pPos, (int)var1_1);
    }

    public static enum RotationMode implements StringRepresentable
    {
        STATIC,
        ROTATING_LEFT,
        ROTATING_RIGHT;


        public String toString() {
            return this.getSerializedName();
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

