/*
 * Decompiled with CFR 0.152.
 */
package me.Blizzard1238562.simplehomes;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Simplehomes
extends JavaPlugin
implements CommandExecutor,
TabCompleter,
Listener {
    private final Map<UUID, Map<String, Location>> homes = new HashMap<UUID, Map<String, Location>>();
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final Map<UUID, Location> pendingTeleports = new ConcurrentHashMap<UUID, Location>();
    private File homesFile;
    private FileConfiguration homesConfig;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadHomesFile();
        this.loadHomesToMemory();
        this.getCommand("sethome").setExecutor((CommandExecutor)this);
        this.getCommand("home").setExecutor((CommandExecutor)this);
        this.getCommand("delhome").setExecutor((CommandExecutor)this);
        this.getCommand("homes").setExecutor((CommandExecutor)this);
        this.getCommand("simplehomes").setExecutor((CommandExecutor)this);
        this.getCommand("home").setTabCompleter((TabCompleter)this);
        this.getCommand("delhome").setTabCompleter((TabCompleter)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("SimpleHomes aktiviert!");
    }

    public void onDisable() {
        this.saveHomesFromMemory();
        this.getLogger().info("SimpleHomes deaktiviert und Homes gespeichert!");
    }

    private void loadHomesFile() {
        this.homesFile = new File(this.getDataFolder(), "homes.yml");
        if (!this.homesFile.exists()) {
            try {
                this.homesFile.getParentFile().mkdirs();
                this.homesFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Konnte homes.yml nicht erstellen!");
                e.printStackTrace();
            }
        }
        this.homesConfig = YamlConfiguration.loadConfiguration((File)this.homesFile);
    }

    private void loadHomesToMemory() {
        if (!this.homesConfig.contains("homes")) {
            return;
        }
        ConfigurationSection section = this.homesConfig.getConfigurationSection("homes");
        if (section == null) {
            return;
        }
        for (String uuidStr : section.getKeys(false)) {
            UUID uuid = UUID.fromString(uuidStr);
            ConfigurationSection playerSection = section.getConfigurationSection(uuidStr);
            if (playerSection == null) continue;
            HashMap<String, Location> playerHomes = new HashMap<String, Location>();
            for (String homeName : playerSection.getKeys(false)) {
                String path = "homes." + uuidStr + "." + homeName;
                String worldName = this.homesConfig.getString(path + ".world");
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) continue;
                double x = this.homesConfig.getDouble(path + ".x");
                double y = this.homesConfig.getDouble(path + ".y");
                double z = this.homesConfig.getDouble(path + ".z");
                float yaw = (float)this.homesConfig.getDouble(path + ".yaw");
                float pitch = (float)this.homesConfig.getDouble(path + ".pitch");
                playerHomes.put(homeName.toLowerCase(), new Location(world, x, y, z, yaw, pitch));
            }
            this.homes.put(uuid, playerHomes);
        }
    }

    private void saveHomesFromMemory() {
        this.homesConfig.set("homes", null);
        for (UUID uuid : this.homes.keySet()) {
            for (Map.Entry<String, Location> entry : this.homes.get(uuid).entrySet()) {
                Location loc = entry.getValue();
                String path = "homes." + String.valueOf(uuid) + "." + entry.getKey();
                this.homesConfig.set(path + ".world", (Object)loc.getWorld().getName());
                this.homesConfig.set(path + ".x", (Object)loc.getX());
                this.homesConfig.set(path + ".y", (Object)loc.getY());
                this.homesConfig.set(path + ".z", (Object)loc.getZ());
                this.homesConfig.set(path + ".yaw", (Object)Float.valueOf(loc.getYaw()));
                this.homesConfig.set(path + ".pitch", (Object)Float.valueOf(loc.getPitch()));
            }
        }
        try {
            this.homesConfig.save(this.homesFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Konnte homes.yml nicht speichern!");
            e.printStackTrace();
        }
    }

    private void saveHomesFile() {
        try {
            this.homesConfig.save(this.homesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String name = cmd.getName().toLowerCase();
        if (name.equals("simplehomes")) {
            return this.handleAdminCommand(sender, args);
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command is only for players!");
            return true;
        }
        Player player = (Player)sender;
        switch (name) {
            case "sethome": {
                this.handleSetHome(player, args);
                break;
            }
            case "home": {
                this.handleHome(player, args);
                break;
            }
            case "delhome": {
                this.handleDelHome(player, args);
                break;
            }
            case "homes": {
                this.handleHomes(player);
            }
        }
        return true;
    }

    private boolean handleAdminCommand(CommandSender sender, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("\u00a7eSimpleHomes \u00a77- \u00a7fVerf\u00fcgbare Befehle:");
            sender.sendMessage("\u00a77/simplehomes reload \u00a78- \u00a7fL\u00e4dt die Config neu");
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("simplehomes.reload")) {
                sender.sendMessage("\u00a7cDu hast keine Berechtigung!");
                return true;
            }
            this.reloadConfig();
            this.loadHomesFile();
            this.loadHomesToMemory();
            sender.sendMessage("\u00a7aSimpleHomes Config und Homes neu geladen!");
            return true;
        }
        sender.sendMessage("\u00a7cUnbekannter Befehl. Nutze /simplehomes reload");
        return true;
    }

    private void handleSetHome(Player player, String[] args) {
        if (!player.hasPermission("homes.sethome")) {
            this.sendMessage(player, "no-permission", Map.of());
            this.playConfiguredSound(player, "no-permission");
            return;
        }
        if (args.length < 1) {
            this.sendMessage(player, "usage.sethome", Map.of());
            this.playConfiguredSound(player, "sethome-fail");
            return;
        }
        Map playerHomes = this.homes.computeIfAbsent(player.getUniqueId(), k -> new HashMap());
        int max = this.getMaxHomes(player);
        if (playerHomes.size() >= max && !playerHomes.containsKey(args[0].toLowerCase())) {
            this.sendMessage(player, "sethome.limit-reached", Map.of("max", String.valueOf(max)));
            this.playConfiguredSound(player, "sethome-fail");
            return;
        }
        playerHomes.put(args[0].toLowerCase(), player.getLocation());
        this.saveHomesFromMemory();
        this.sendMessage(player, "sethome.success", Map.of("home", args[0]));
        this.playConfiguredSound(player, "sethome-success");
    }

    private void handleHome(Player player, String[] args) {
        if (!player.hasPermission("homes.home")) {
            this.sendMessage(player, "no-permission", Map.of());
            this.playConfiguredSound(player, "no-permission");
            return;
        }
        if (args.length < 1) {
            this.sendMessage(player, "usage.home", Map.of());
            this.playConfiguredSound(player, "home-fail");
            return;
        }
        Map playerHomes = this.homes.getOrDefault(player.getUniqueId(), new HashMap());
        if (!playerHomes.containsKey(args[0].toLowerCase())) {
            this.sendMessage(player, "home.not-exist", Map.of("home", args[0]));
            this.playConfiguredSound(player, "home-fail");
            return;
        }
        long now = System.currentTimeMillis();
        if (this.cooldowns.containsKey(player.getUniqueId()) && now < this.cooldowns.get(player.getUniqueId())) {
            long left = (this.cooldowns.get(player.getUniqueId()) - now) / 1000L;
            this.sendMessage(player, "home.cooldown", Map.of("time", String.valueOf(left)));
            this.playConfiguredSound(player, "cooldown-fail");
            return;
        }
        int warmup = this.getConfig().getInt("teleport-warmup", 0);
        if (warmup > 0) {
            this.sendMessage(player, "home.warmup", Map.of("home", args[0], "time", String.valueOf(warmup)));
            this.playConfiguredSound(player, "home-warmup");
            this.pendingTeleports.put(player.getUniqueId(), player.getLocation());
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                if (this.pendingTeleports.containsKey(player.getUniqueId())) {
                    player.teleport((Location)playerHomes.get(args[0].toLowerCase()));
                    this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis() + (long)this.getConfig().getInt("teleport-cooldown", 0) * 1000L);
                    this.sendMessage(player, "home.success", Map.of("home", args[0]));
                    this.playConfiguredSound(player, "home-success");
                    this.pendingTeleports.remove(player.getUniqueId());
                }
            }, (long)warmup * 20L);
        } else {
            player.teleport((Location)playerHomes.get(args[0].toLowerCase()));
            this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis() + (long)this.getConfig().getInt("teleport-cooldown", 0) * 1000L);
            this.sendMessage(player, "home.success", Map.of("home", args[0]));
            this.playConfiguredSound(player, "home-success");
        }
    }

    private void handleDelHome(Player player, String[] args) {
        if (!player.hasPermission("homes.delhome")) {
            this.sendMessage(player, "no-permission", Map.of());
            this.playConfiguredSound(player, "no-permission");
            return;
        }
        if (args.length < 1) {
            this.sendMessage(player, "usage.delhome", Map.of());
            this.playConfiguredSound(player, "delhome-fail");
            return;
        }
        Map playerHomes = this.homes.getOrDefault(player.getUniqueId(), new HashMap());
        if (!playerHomes.containsKey(args[0].toLowerCase())) {
            this.sendMessage(player, "delhome.not-exist", Map.of("home", args[0]));
            this.playConfiguredSound(player, "delhome-fail");
            return;
        }
        playerHomes.remove(args[0].toLowerCase());
        this.saveHomesFromMemory();
        this.sendMessage(player, "delhome.success", Map.of("home", args[0]));
        this.playConfiguredSound(player, "delhome-success");
    }

    private void handleHomes(Player player) {
        if (!player.hasPermission("homes.homes")) {
            this.sendMessage(player, "no-permission", Map.of());
            this.playConfiguredSound(player, "no-permission");
            return;
        }
        Map playerHomes = this.homes.getOrDefault(player.getUniqueId(), new HashMap());
        if (playerHomes.isEmpty()) {
            this.sendMessage(player, "homes.none", Map.of());
            return;
        }
        String homeList = String.join((CharSequence)", ", playerHomes.keySet());
        this.sendMessage(player, "homes.list", Map.of("homes", homeList));
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        if (cmd.getName().equalsIgnoreCase("simplehomes")) {
            if (args.length == 1) {
                return List.of("reload");
            }
            return Collections.emptyList();
        }
        if (args.length == 1) {
            Map playerHomes = this.homes.getOrDefault(player.getUniqueId(), new HashMap());
            return new ArrayList<String>(playerHomes.keySet());
        }
        return Collections.emptyList();
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!this.pendingTeleports.containsKey(player.getUniqueId())) {
            return;
        }
        if (!this.getConfig().getBoolean("cancel-on-move", true)) {
            return;
        }
        Location start = this.pendingTeleports.get(player.getUniqueId());
        if (event.getTo() != null && (event.getTo().getBlockX() != start.getBlockX() || event.getTo().getBlockY() != start.getBlockY() || event.getTo().getBlockZ() != start.getBlockZ())) {
            this.pendingTeleports.remove(player.getUniqueId());
            this.sendMessage(player, "home.cancelled-move", Map.of());
            this.playConfiguredSound(player, "home-cancel-move");
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.pendingTeleports.containsKey(player.getUniqueId())) {
            return;
        }
        if (!this.getConfig().getBoolean("cancel-on-damage", true)) {
            return;
        }
        this.pendingTeleports.remove(player.getUniqueId());
        this.sendMessage(player, "home.cancelled-damage", Map.of());
        this.playConfiguredSound(player, "home-cancel-damage");
    }

    private int getMaxHomes(Player player) {
        if (player.hasPermission("homes.unlimited")) {
            return Integer.MAX_VALUE;
        }
        return this.getConfig().getInt("max-homes", 1);
    }

    private void sendMessage(Player player, String path, Map<String, String> placeholders) {
        String msg = this.getConfig().getString("messages." + path, "");
        if (msg == null || msg.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            msg = msg.replace("%" + entry.getKey() + "%", entry.getValue());
        }
        player.sendMessage(msg.replace("&", "\u00a7"));
    }

    private void playConfiguredSound(Player player, String path) {
        String value = this.getConfig().getString("sounds." + path, "");
        if (value == null || value.isEmpty()) {
            return;
        }
        try {
            String[] parts = value.split(":");
            String soundName = parts[0].toLowerCase(Locale.ROOT);
            float volume = parts.length > 1 ? Float.parseFloat(parts[1]) : 1.0f;
            float pitch = parts.length > 2 ? Float.parseFloat(parts[2]) : 1.0f;
            Sound sound = Sound.sound((Key)Key.key((String)soundName), (Sound.Source)Sound.Source.MASTER, (float)volume, (float)pitch);
            player.playSound(sound);
        }
        catch (Exception e) {
            this.getLogger().warning("Invalid sound config at '" + path + "': " + value);
        }
    }
}

