/*
 * Decompiled with CFR 0.152.
 */
package net.nebula.clientgames.games;

import java.time.Duration;
import java.time.Instant;
import java.util.Random;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class MinesweeperScreen
extends class_437 {
    private int boardWidth = 8;
    private int boardHeight = 8;
    private int mines = 10;
    private Tile[][] board;
    private boolean gameOver = false;
    private boolean win = false;
    private class_342 widthInput;
    private class_342 heightInput;
    private class_342 minesInput;
    private final int cellSize = 16;
    private static final class_2960[] NUMBERS = new class_2960[8];
    private static final class_2960 EMPTY = MinesweeperScreen.id("frostc/empty");
    private static final class_2960 BOMB = MinesweeperScreen.id("frostc/bomb");
    private static final class_2960 FLAG = MinesweeperScreen.id("frostc/flag");
    private static final class_2960 UNKNOWN = MinesweeperScreen.id("frostc/unknown");
    private static Instant timeClosed = null;
    private static Instant startTime = null;
    private static Instant endTime = null;
    private static boolean startTimeSet = false;
    private static Tile[][] savedBoard = null;
    private static int savedWidth = 8;
    private static int savedHeight = 8;
    private static int savedMines = 10;
    private static boolean savedGameOver = false;
    private static boolean savedWin = false;

    private static class_2960 id(String name) {
        return class_2960.method_60655((String)"clientgames", (String)("textures/minesweeper/" + name + ".png"));
    }

    public MinesweeperScreen() {
        super(class_2561.method_30163((String)"Minesweeper"));
    }

    protected void method_25426() {
        super.method_25426();
        int x = this.field_22789 / 8;
        int y = this.field_22790 / 2 - 80;
        this.widthInput = new class_342(this.field_22793, x, y, 45, 20, class_2561.method_30163((String)""));
        this.widthInput.method_1852(String.valueOf(this.boardWidth));
        this.method_37063((class_364)this.widthInput);
        this.heightInput = new class_342(this.field_22793, x, y + 40, 45, 20, class_2561.method_30163((String)""));
        this.heightInput.method_1852(String.valueOf(this.boardHeight));
        this.method_37063((class_364)this.heightInput);
        this.minesInput = new class_342(this.field_22793, x, y + 80, 45, 20, class_2561.method_30163((String)""));
        this.minesInput.method_1852(String.valueOf(this.mines));
        this.method_37063((class_364)this.minesInput);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"Reset"), btn -> {
            startTimeSet = false;
            startTime = null;
            endTime = null;
            this.applyInputs();
            this.initBoard();
        }).method_46434(x, y + 120, 45, 20).method_46431());
        if (savedBoard != null) {
            if (!savedWin && !savedGameOver && startTimeSet) {
                long closedTime = Duration.between(timeClosed, Instant.now()).toMillis();
                startTime = startTime.plusMillis(closedTime);
            }
            this.boardWidth = savedWidth;
            this.boardHeight = savedHeight;
            this.mines = savedMines;
            this.board = savedBoard;
            this.gameOver = savedGameOver;
            this.win = savedWin;
        } else {
            this.initBoard();
            startTime = null;
            endTime = null;
            startTimeSet = false;
        }
    }

    private void applyInputs() {
        try {
            this.boardWidth = Math.max(2, Math.min(40, Integer.parseInt(this.widthInput.method_1882())));
            this.boardHeight = Math.max(2, Math.min(40, Integer.parseInt(this.heightInput.method_1882())));
            int maxMines = this.boardWidth * this.boardHeight - 1;
            this.mines = Math.max(1, Math.min(maxMines, Integer.parseInt(this.minesInput.method_1882())));
        }
        catch (NumberFormatException e) {
            this.boardWidth = 8;
            this.boardHeight = 8;
            this.mines = 10;
        }
    }

    private void initBoard() {
        this.board = new Tile[this.boardWidth][this.boardHeight];
        Random random = new Random();
        for (int i = 0; i < this.boardWidth; ++i) {
            for (int j = 0; j < this.boardHeight; ++j) {
                this.board[i][j] = new Tile();
            }
        }
        int placed = 0;
        while (placed < this.mines) {
            int x = random.nextInt(this.boardWidth);
            int y = random.nextInt(this.boardHeight);
            if (this.board[x][y].isMine) continue;
            this.board[x][y].isMine = true;
            ++placed;
        }
        for (int i = 0; i < this.boardWidth; ++i) {
            for (int j = 0; j < this.boardHeight; ++j) {
                if (this.board[i][j].isMine) continue;
                this.board[i][j].neighbors = this.countNeighbors(i, j);
            }
        }
        this.gameOver = false;
        this.win = false;
    }

    private int countNeighbors(int i, int j) {
        int count = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                if (dx == 0 && dy == 0) continue;
                int nx = i + dx;
                int ny = j + dy;
                if (nx < 0 || ny < 0 || nx >= this.boardWidth || ny >= this.boardHeight || !this.board[nx][ny].isMine) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.gameOver) {
            return true;
        }
        int startX = (this.field_22789 - this.boardWidth * 16) / 2;
        int startY = this.field_22790 / 2 - this.boardHeight * 16 / 2;
        for (int i = 0; i < this.boardWidth; ++i) {
            for (int j = 0; j < this.boardHeight; ++j) {
                int x = startX + i * 16;
                int y = startY + j * 16;
                if (!(mouseX >= (double)x) || !(mouseX < (double)(x + 16)) || !(mouseY >= (double)y) || !(mouseY < (double)(y + 16))) continue;
                if (this.board[i][j].isMine && !startTimeSet) {
                    this.initBoard();
                    this.method_25402(mouseX, mouseY, button);
                }
                if (button == 0) {
                    this.reveal(i, j);
                } else if (button == 1) {
                    this.toggleFlag(i, j);
                }
                if (!startTimeSet) {
                    startTimeSet = true;
                    startTime = Instant.now();
                }
                return true;
            }
        }
        return false;
    }

    private void toggleFlag(int i, int j) {
        Tile tile = this.board[i][j];
        if (!tile.revealed) {
            tile.flagged = !tile.flagged;
        }
    }

    private void reveal(int i, int j) {
        if (i < 0 || j < 0 || i >= this.boardWidth || j >= this.boardHeight) {
            return;
        }
        Tile tile = this.board[i][j];
        if (tile.revealed || tile.flagged) {
            return;
        }
        tile.revealed = true;
        if (tile.isMine) {
            this.gameOver = true;
            endTime = Instant.now();
            return;
        }
        if (tile.neighbors == 0) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    if (dx == 0 && dy == 0) continue;
                    this.reveal(i + dx, j + dy);
                }
            }
        }
        this.checkWin();
    }

    private void checkWin() {
        Tile[][] tileArray = this.board;
        int n = tileArray.length;
        for (int i = 0; i < n; ++i) {
            Tile[] row;
            for (Tile t : row = tileArray[i]) {
                if (t.revealed || t.isMine) continue;
                return;
            }
        }
        this.win = true;
        endTime = Instant.now();
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        super.method_25394(ctx, mouseX, mouseY, delta);
        int boardPixelWidth = this.boardWidth * 16;
        int boardPixelHeight = this.boardHeight * 16;
        int startX = (this.field_22789 - boardPixelWidth) / 2;
        int startY = this.field_22790 / 2 - boardPixelHeight / 2;
        for (int i = 0; i < this.boardWidth; ++i) {
            for (int j = 0; j < this.boardHeight; ++j) {
                Tile tile = this.board[i][j];
                int x = startX + i * 16;
                int y = startY + j * 16;
                if (tile.flagged && !tile.revealed) {
                    ctx.method_25290(class_10799.field_56883, FLAG, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
                    continue;
                }
                if (tile.revealed && !tile.isMine && tile.neighbors > 0) {
                    ctx.method_25290(class_10799.field_56883, NUMBERS[tile.neighbors - 1], x, y, 0.0f, 0.0f, 16, 16, 16, 16);
                    continue;
                }
                if (tile.revealed && tile.isMine) {
                    ctx.method_25290(class_10799.field_56883, BOMB, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
                    continue;
                }
                if (tile.revealed) {
                    ctx.method_25290(class_10799.field_56883, EMPTY, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
                    continue;
                }
                ctx.method_25290(class_10799.field_56883, UNKNOWN, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
        if (this.gameOver) {
            ctx.method_25300(this.field_22793, "\ud83d\udca5 Game Over \ud83d\udca5", this.field_22789 / 5 * 4, this.field_22790 / 2 - 15, -48060);
            Tile[][] tileArray = this.board;
            int n = tileArray.length;
            for (int i = 0; i < n; ++i) {
                Tile[] row;
                for (Tile t : row = tileArray[i]) {
                    t.revealed = true;
                }
            }
        } else if (this.win) {
            ctx.method_25300(this.field_22793, "\ud83c\udf89 You Win! \ud83c\udf89", this.field_22789 / 5 * 4, this.field_22790 / 2 - 15, -10027162);
        }
        if (endTime == null && startTimeSet && !this.gameOver) {
            ctx.method_25300(this.field_22793, String.format("%.2fs", (double)Duration.between(startTime, Instant.now()).toMillis() / 1000.0), this.field_22789 / 5 * 4, this.field_22790 / 2, -10027162);
        } else if (endTime != null && startTimeSet) {
            ctx.method_25300(this.field_22793, String.format("%.2fs", (double)Duration.between(startTime, endTime).toMillis() / 1000.0), this.field_22789 / 5 * 4, this.field_22790 / 2, -10027162);
        } else if (!startTimeSet && endTime == null && !this.gameOver) {
            ctx.method_25300(this.field_22793, "0.00s", this.field_22789 / 5 * 4, this.field_22790 / 2, -10027162);
        }
        ctx.method_25303(this.field_22793, "Width", this.field_22789 / 8, this.field_22790 / 2 - 89, -1);
        ctx.method_25303(this.field_22793, "Height", this.field_22789 / 8, this.field_22790 / 2 - 49, -1);
        ctx.method_25303(this.field_22793, "Mines", this.field_22789 / 8, this.field_22790 / 2 - 9, -1);
    }

    public void method_25419() {
        savedBoard = this.board;
        savedWidth = this.boardWidth;
        savedHeight = this.boardHeight;
        savedMines = this.mines;
        savedGameOver = this.gameOver;
        savedWin = this.win;
        timeClosed = Instant.now();
        super.method_25419();
    }

    public boolean method_25421() {
        return false;
    }

    static {
        for (int i = 0; i < 8; ++i) {
            MinesweeperScreen.NUMBERS[i] = MinesweeperScreen.id("frostc/" + (i + 1));
        }
    }

    private static class Tile {
        boolean isMine;
        boolean revealed;
        boolean flagged;
        int neighbors;

        private Tile() {
        }
    }
}

