/*
 * Decompiled with CFR 0.152.
 */
package net.nebula.clientgames.games;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;

public class SnakeScreen
extends class_437 {
    private static final int TILE_SIZE = 16;
    private static final class_2960 BOARD_TEXTURE = SnakeScreen.id("bg");
    private static final class_2960 APPLE_TEXTURE = SnakeScreen.id("apple");
    private static final class_2960 HEAD_UP = SnakeScreen.id("head_up");
    private static final class_2960 HEAD_DOWN = SnakeScreen.id("head_down");
    private static final class_2960 HEAD_LEFT = SnakeScreen.id("head_left");
    private static final class_2960 HEAD_RIGHT = SnakeScreen.id("head_right");
    private static final class_2960 BODY_HORIZONTAL = SnakeScreen.id("body_horizontal");
    private static final class_2960 BODY_VERTICAL = SnakeScreen.id("body_vertical");
    private static final class_2960 BODY_TURN_TOPLEFT = SnakeScreen.id("body_topleft");
    private static final class_2960 BODY_TURN_TOPRIGHT = SnakeScreen.id("body_topright");
    private static final class_2960 BODY_TURN_BOTTOMLEFT = SnakeScreen.id("body_bottomleft");
    private static final class_2960 BODY_TURN_BOTTOMRIGHT = SnakeScreen.id("body_bottomright");
    private static final class_2960 TAIL_UP = SnakeScreen.id("tail_up");
    private static final class_2960 TAIL_DOWN = SnakeScreen.id("tail_down");
    private static final class_2960 TAIL_LEFT = SnakeScreen.id("tail_left");
    private static final class_2960 TAIL_RIGHT = SnakeScreen.id("tail_right");
    private final int boardWidth;
    private final int boardHeight;
    private final int appleCount;
    private final List<Point> apples = new ArrayList<Point>();
    private final List<Point> snake = new ArrayList<Point>();
    private class_2350 currentDirection = class_2350.field_11034;
    private class_2350 nextDirection = class_2350.field_11034;
    private int tickCounter = 0;
    private boolean gameOver = false;
    private int score = 0;

    private static class_2960 id(String name) {
        return class_2960.method_60655((String)"clientgames", (String)("textures/snake/" + name + ".png"));
    }

    public SnakeScreen(class_2561 title, int boardWidth, int boardHeight, int appleCount) {
        super(title);
        this.boardWidth = boardWidth;
        this.boardHeight = boardHeight;
        this.appleCount = appleCount;
    }

    protected void method_25426() {
        super.method_25426();
        this.resetGame();
    }

    private void resetGame() {
        int i;
        this.snake.clear();
        int startX = this.boardWidth / 2;
        int startY = this.boardHeight / 2;
        for (i = 0; i < 3; ++i) {
            this.snake.add(new Point(startX - i, startY));
        }
        this.apples.clear();
        for (i = 0; i < this.appleCount; ++i) {
            this.apples.add(this.randomApplePosition());
        }
        this.currentDirection = class_2350.field_11034;
        this.nextDirection = class_2350.field_11034;
        this.tickCounter = 0;
        this.gameOver = false;
        this.score = 0;
    }

    private Point randomApplePosition() {
        Point p;
        boolean collision;
        block0: do {
            int x = (int)(Math.random() * (double)this.boardWidth);
            int y = (int)(Math.random() * (double)this.boardHeight);
            p = new Point(x, y);
            collision = false;
            for (Point s : this.snake) {
                if (!p.equals(s)) continue;
                collision = true;
                break;
            }
            for (Point apple : this.apples) {
                if (!p.equals(apple)) continue;
                collision = true;
                continue block0;
            }
        } while (collision);
        return p;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int py;
        int px;
        int boardPixelWidth = this.boardWidth * 16;
        int boardPixelHeight = this.boardHeight * 16;
        int offsetX = this.field_22789 / 2 - boardPixelWidth / 2;
        int offsetY = this.field_22790 / 2 - boardPixelHeight / 2;
        SnakeScreen.drawTiledTexture(context, BOARD_TEXTURE, offsetX, offsetY, boardPixelWidth, boardPixelHeight, 32, 32);
        for (Point apple : this.apples) {
            px = offsetX + apple.x * 16;
            py = offsetY + apple.y * 16;
            context.method_25290(class_10799.field_56883, APPLE_TEXTURE, px, py, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        for (int i = 0; i < this.snake.size(); ++i) {
            class_2960 tex;
            Point seg = this.snake.get(i);
            px = offsetX + seg.x * 16;
            py = offsetY + seg.y * 16;
            if (this.snake.size() == 1) {
                tex = this.currentDirection == class_2350.field_11034 ? HEAD_RIGHT : (this.currentDirection == class_2350.field_11039 ? HEAD_LEFT : (this.currentDirection == class_2350.field_11035 ? HEAD_DOWN : (this.currentDirection == class_2350.field_11043 ? HEAD_UP : HEAD_RIGHT)));
            } else if (i == 0) {
                Point next = this.snake.get(1);
                tex = this.getHeadTexture(seg, next);
            } else if (i == this.snake.size() - 1) {
                prev = this.snake.get(i - 1);
                tex = this.getTailTexture(seg, prev);
            } else {
                prev = this.snake.get(i - 1);
                Point next = this.snake.get(i + 1);
                tex = this.getBodyTexture(prev, seg, next);
            }
            context.method_25290(class_10799.field_56883, tex, px, py, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        context.method_25300(this.field_22793, "Score: " + this.score, offsetX / 2, this.field_22790 / 2, -1);
        if (this.gameOver) {
            String msg = "Game Over - Press R to Restart";
            int msgWidth = this.field_22793.method_1727(msg);
            context.method_25300(this.field_22793, msg, this.field_22789 / 2, offsetY + 16 * this.boardHeight + 10, -43691);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787 == null) {
            return false;
        }
        long handle = this.field_22787.method_22683().method_4490();
        if (this.gameOver && class_3675.method_15987((long)handle, (int)82)) {
            this.resetGame();
            return true;
        }
        class_2350 oldDir = this.nextDirection;
        if (class_3675.method_15987((long)handle, (int)263) && this.currentDirection != class_2350.field_11034) {
            this.nextDirection = class_2350.field_11039;
        }
        if (class_3675.method_15987((long)handle, (int)262) && this.currentDirection != class_2350.field_11039) {
            this.nextDirection = class_2350.field_11034;
        }
        if (class_3675.method_15987((long)handle, (int)265) && this.currentDirection != class_2350.field_11035) {
            this.nextDirection = class_2350.field_11043;
        }
        if (class_3675.method_15987((long)handle, (int)264) && this.currentDirection != class_2350.field_11043) {
            this.nextDirection = class_2350.field_11035;
        }
        return this.nextDirection != oldDir || super.method_25404(keyCode, scanCode, modifiers);
    }

    public void clientTick(class_310 client) {
        Point newHead;
        if (this.gameOver) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter % 5 != 0) {
            return;
        }
        this.currentDirection = this.nextDirection;
        Point head = this.snake.getFirst();
        switch (this.currentDirection) {
            case field_11043: {
                Point point = new Point(head.x, head.y - 1);
                break;
            }
            case field_11035: {
                Point point = new Point(head.x, head.y + 1);
                break;
            }
            case field_11039: {
                Point point = new Point(head.x - 1, head.y);
                break;
            }
            case field_11034: {
                Point point = new Point(head.x + 1, head.y);
                break;
            }
            default: {
                Point point = newHead = head;
            }
        }
        if (newHead.x < 0 || newHead.x >= this.boardWidth || newHead.y < 0 || newHead.y >= this.boardHeight) {
            this.gameOver = true;
            return;
        }
        for (Point seg : this.snake) {
            if (!seg.equals(newHead)) continue;
            this.gameOver = true;
            return;
        }
        this.snake.addFirst(newHead);
        boolean grew = false;
        Iterator<Point> it = this.apples.iterator();
        while (it.hasNext()) {
            Point apple = it.next();
            if (!apple.equals(newHead)) continue;
            it.remove();
            this.apples.add(this.randomApplePosition());
            grew = true;
            ++this.score;
            break;
        }
        if (!grew) {
            this.snake.removeLast();
        }
    }

    private class_2960 getHeadTexture(Point head, Point next) {
        if (head.x < next.x) {
            return HEAD_LEFT;
        }
        if (head.x > next.x) {
            return HEAD_RIGHT;
        }
        if (head.y < next.y) {
            return HEAD_UP;
        }
        if (head.y > next.y) {
            return HEAD_DOWN;
        }
        return HEAD_RIGHT;
    }

    private class_2960 getTailTexture(Point tail, Point prev) {
        if (tail.x < prev.x) {
            return TAIL_LEFT;
        }
        if (tail.x > prev.x) {
            return TAIL_RIGHT;
        }
        if (tail.y < prev.y) {
            return TAIL_UP;
        }
        if (tail.y > prev.y) {
            return TAIL_DOWN;
        }
        return TAIL_RIGHT;
    }

    private class_2960 getBodyTexture(Point prev, Point cur, Point next) {
        int dx1 = prev.x - cur.x;
        int dy1 = prev.y - cur.y;
        int dx2 = next.x - cur.x;
        int dy2 = next.y - cur.y;
        if (dy1 == 0 && dy2 == 0) {
            return BODY_HORIZONTAL;
        }
        if (dx1 == 0 && dx2 == 0) {
            return BODY_VERTICAL;
        }
        if (this.isUp(dy1) && this.isLeft(dx2) || this.isUp(dy2) && this.isLeft(dx1)) {
            return BODY_TURN_TOPLEFT;
        }
        if (this.isUp(dy1) && this.isRight(dx2) || this.isUp(dy2) && this.isRight(dx1)) {
            return BODY_TURN_TOPRIGHT;
        }
        if (this.isDown(dy1) && this.isLeft(dx2) || this.isDown(dy2) && this.isLeft(dx1)) {
            return BODY_TURN_BOTTOMLEFT;
        }
        if (this.isDown(dy1) && this.isRight(dx2) || this.isDown(dy2) && this.isRight(dx1)) {
            return BODY_TURN_BOTTOMRIGHT;
        }
        return BODY_HORIZONTAL;
    }

    public static void drawTiledTexture(class_332 context, class_2960 texture, int x, int y, int width, int height, int tileWidth, int tileHeight) {
        context.method_51448().pushMatrix();
        context.method_44379(x, y, x + width, y + height);
        for (int ty = 0; ty < height; ty += tileHeight) {
            for (int tx = 0; tx < width; tx += tileWidth) {
                context.method_25290(class_10799.field_56883, texture, x + tx, y + ty, 0.0f, 0.0f, tileWidth, tileHeight, tileWidth, tileHeight);
            }
        }
        context.method_44380();
        context.method_51448().popMatrix();
    }

    private boolean isUp(int dy) {
        return dy == -1;
    }

    private boolean isDown(int dy) {
        return dy == 1;
    }

    private boolean isLeft(int dx) {
        return dx == -1;
    }

    private boolean isRight(int dx) {
        return dx == 1;
    }
}

