/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.effect;

import com.mojang.blaze3d.systems.RenderSystem;
import com.quickskin.mod.QuickSkin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlurHandler {
    private static PostChain blurShader = null;
    private static final ResourceLocation BLUR_SHADER = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"shaders/post/blur.json");

    public static void renderBlur() {
        Minecraft mc = Minecraft.getInstance();
        if (blurShader == null) {
            try {
                blurShader = new PostChain(mc.getTextureManager(), (ResourceProvider)mc.getResourceManager(), mc.getMainRenderTarget(), BLUR_SHADER);
                blurShader.resize(mc.getWindow().getWidth(), mc.getWindow().getHeight());
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Failed to load blur shader", (Throwable)e);
                return;
            }
        }
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        blurShader.process(0.0f);
        mc.getMainRenderTarget().bindWrite(true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public static void cleanup() {
        if (blurShader != null) {
            blurShader.close();
            blurShader = null;
        }
    }
}

