/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.panel;

import com.quickskin.mod.client.gui.screen.PlayerSkinMenuScreen;
import com.quickskin.mod.client.gui.util.ButtonFactory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class ActionButtonsPanel
extends AbstractWidget {
    private static final int SPACING = 4;
    private static final int COMPONENT_HEIGHT = 20;
    private Button doneButton;

    public ActionButtonsPanel(int x, int y, int width, int height, ActionCallbacks callbacks) {
        super(x, y, width, height, (Component)Component.empty());
    }

    public void init(PlayerSkinMenuScreen screen, ActionCallbacks callbacks) {
        int fullWidthX = this.getX();
        int fullComponentWidth = this.width;
        int bottomY = this.getY() + this.height;
        this.doneButton = ButtonFactory.createPrimary(fullWidthX, bottomY -= 20, fullComponentWidth, 20, (Component)Component.literal((String)"Done"), button -> callbacks.onDone.run());
        screen.registerWidget(this.doneButton);
        int fourButtonWidth = (fullComponentWidth - 12) / 4;
        Button importButton = ButtonFactory.createStyled(fullWidthX, bottomY -= 24, fourButtonWidth, 20, (Component)Component.literal((String)"Import Skin"), button -> callbacks.onImport.run());
        screen.registerWidget(importButton);
        Button hdSkinWebsiteButton = ButtonFactory.createStyled(fullWidthX + fourButtonWidth + 4, bottomY, fourButtonWidth, 20, (Component)Component.literal((String)"HD Skin Website"), button -> callbacks.onHdSkinWebsite.run());
        screen.registerWidget(hdSkinWebsiteButton);
        Button skinWebsiteButton = ButtonFactory.createStyled(fullWidthX + (fourButtonWidth + 4) * 2, bottomY, fourButtonWidth, 20, (Component)Component.literal((String)"Skin Website"), button -> callbacks.onSkinWebsite.run());
        screen.registerWidget(skinWebsiteButton);
        Button capeButton = ButtonFactory.createStyled(fullWidthX + (fourButtonWidth + 4) * 3, bottomY, fourButtonWidth, 20, (Component)Component.literal((String)"Cape"), button -> callbacks.onCape.run());
        screen.registerWidget(capeButton);
    }

    public Button getDoneButton() {
        return this.doneButton;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public record ActionCallbacks(Runnable onImport, Runnable onHdSkinWebsite, Runnable onSkinWebsite, Runnable onCape, Runnable onDone) {
    }
}

