/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.panel;

import com.quickskin.mod.client.gui.screen.PlayerSkinMenuScreen;
import com.quickskin.mod.client.gui.screen.SettingsScreen;
import com.quickskin.mod.client.gui.widget.LinkButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class LinkButtonsPanel
extends AbstractWidget {
    private static final int SPACING = 4;
    private static final int BUTTON_SIZE = 20;
    private static final ResourceLocation DISCORD_ICON = ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"textures/gui/discord_icon.png");
    private static final ResourceLocation CURSEFORGE_ICON = ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"textures/gui/curseforge_icon.png");
    private static final ResourceLocation MODRINTH_ICON = ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"textures/gui/modrinth_icon.png");
    private static final ResourceLocation SETTINGS_ICON = ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"textures/gui/settings_icon.png");
    private static final String DISCORD_URL = "https://discord.gg/yGxdvA7qej";
    private static final String CURSEFORGE_URL = "https://www.curseforge.com/minecraft/mc-mods/quick-skin";
    private static final String MODRINTH_URL = "https://modrinth.com/mod/quick-skin";

    public LinkButtonsPanel(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.empty());
    }

    public void init(final PlayerSkinMenuScreen screen) {
        int linkButtonY = this.getY();
        int currentX = this.getX() + this.width - 20;
        screen.registerWidget(new LinkButton(this, currentX, linkButtonY, 20, 20, SETTINGS_ICON, null, (Component)Component.literal((String)"Settings")){

            public void onPress() {
                Minecraft.getInstance().setScreen((Screen)new SettingsScreen(screen));
            }
        });
        screen.registerWidget(new LinkButton(currentX -= 24, linkButtonY, 20, 20, DISCORD_ICON, DISCORD_URL, (Component)Component.literal((String)"Join our Discord!")));
        screen.registerWidget(new LinkButton(currentX -= 24, linkButtonY, 20, 20, CURSEFORGE_ICON, CURSEFORGE_URL, (Component)Component.literal((String)"Visit our CurseForge page")));
        screen.registerWidget(new LinkButton(currentX -= 24, linkButtonY, 20, 20, MODRINTH_ICON, MODRINTH_URL, (Component)Component.literal((String)"Visit our Modrinth page")));
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

