/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.screen;

import com.quickskin.mod.client.gui.effect.BlurHandler;
import com.quickskin.mod.client.gui.util.ButtonFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DeletionConfirmScreen
extends Screen {
    private final Screen parent;
    private final Component message;
    private final Consumer<Boolean> callback;
    private static final int PANEL_BG = -1342177280;
    private static final int PANEL_OUTLINE = 0x60FFFFFF;
    private static final int TITLE_COLOR = 0xFFFFFF;
    private static final int MESSAGE_COLOR = 0xFFFFFF;
    private static final int WARNING_COLOR = 0xFFCC00;
    private final int panelWidth = 340;
    private final int panelHeight = 160;
    private int panelX;
    private int panelY;

    public DeletionConfirmScreen(Screen parent, Component title, Component message, Consumer<Boolean> callback, boolean isPermanentDelete) {
        super(title);
        this.parent = parent;
        this.message = message;
        this.callback = callback;
    }

    protected void init() {
        this.panelX = (this.width - this.panelWidth) / 2;
        this.panelY = (this.height - this.panelHeight) / 2;
        int buttonWidth = 120;
        int buttonHeight = 20;
        int buttonSpacing = 10;
        int buttonY = this.panelY + this.panelHeight - buttonHeight - 20;
        int totalButtonWidth = buttonWidth * 2 + buttonSpacing;
        int buttonStartX = this.panelX + (this.panelWidth - totalButtonWidth) / 2;
        Button cancelButton = ButtonFactory.createStyled(buttonStartX, buttonY, buttonWidth, buttonHeight, (Component)Component.literal((String)"Cancel"), button -> this.callback.accept(false));
        Button confirmButton = ButtonFactory.createDanger(buttonStartX + buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, (Component)Component.literal((String)"Delete"), button -> this.callback.accept(true));
        this.addRenderableWidget((GuiEventListener)cancelButton);
        this.addRenderableWidget((GuiEventListener)confirmButton);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.parent != null) {
            this.parent.render(graphics, -1, -1, partialTicks);
        }
        graphics.flush();
        BlurHandler.renderBlur();
        graphics.fill(0, 0, this.width, this.height, 0x60000000);
        graphics.fill(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, -1342177280);
        graphics.fill(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + 1, 0x60FFFFFF);
        graphics.fill(this.panelX, this.panelY + this.panelHeight - 1, this.panelX + this.panelWidth, this.panelY + this.panelHeight, 0x60FFFFFF);
        graphics.fill(this.panelX, this.panelY, this.panelX + 1, this.panelY + this.panelHeight, 0x60FFFFFF);
        graphics.fill(this.panelX + this.panelWidth - 1, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, 0x60FFFFFF);
        int titleY = this.panelY + 20;
        graphics.drawCenteredString(this.font, this.title, this.width / 2, titleY, 0xFFFFFF);
        int iconY = this.panelY + 45;
        String warningIcon = "!";
        graphics.drawCenteredString(this.font, warningIcon, this.width / 2, iconY, 0xFFCC00);
        int messageY = this.panelY + 65;
        int messageMaxWidth = this.panelWidth - 40;
        String messageText = this.message.getString();
        List<String> wrappedLines = this.wrapText(messageText, messageMaxWidth);
        int lineHeight = 10;
        int currentY = messageY;
        for (String line : wrappedLines) {
            graphics.drawCenteredString(this.font, line, this.width / 2, currentY, 0xFFFFFF);
            currentY += lineHeight;
        }
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            Object testLine = currentLine.isEmpty() ? word : String.valueOf(currentLine) + " " + word;
            int lineWidth = this.font.width((String)testLine);
            if (lineWidth > maxWidth && !currentLine.isEmpty()) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            if (!currentLine.isEmpty()) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public void removed() {
        super.removed();
        BlurHandler.cleanup();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.panelX || mouseX > (double)(this.panelX + this.panelWidth) || mouseY < (double)this.panelY || mouseY > (double)(this.panelY + this.panelHeight)) {
            this.onClose();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void onClose() {
        this.callback.accept(false);
    }

    public void renderBlurredBackground(float partialTick) {
    }
}

