/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.gui.StarPatternCache;
import com.quickskin.mod.client.gui.panel.ActionButtonsPanel;
import com.quickskin.mod.client.gui.panel.LinkButtonsPanel;
import com.quickskin.mod.client.gui.panel.PlayerPreviewPanel;
import com.quickskin.mod.client.gui.panel.SkinListPanel;
import com.quickskin.mod.client.gui.screen.DeletionConfirmScreen;
import com.quickskin.mod.client.gui.screen.PlayerCapeMenuScreen;
import com.quickskin.mod.client.gui.screen.RenameScreen;
import com.quickskin.mod.client.gui.util.ButtonFactory;
import com.quickskin.mod.client.gui.util.FileDialogHelper;
import com.quickskin.mod.client.gui.util.GuiScaleManager;
import com.quickskin.mod.client.gui.util.SkinImporter;
import com.quickskin.mod.client.gui.widget.ErrorToast;
import com.quickskin.mod.client.gui.widget.PlayerWidget;
import com.quickskin.mod.client.gui.widget.SkinEntry;
import com.quickskin.mod.client.rendering.PlayerModelRenderer;
import com.quickskin.mod.client.services.AnimatedTextureManager;
import com.quickskin.mod.client.services.CooldownService;
import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.client.services.MojangApiService;
import com.quickskin.mod.client.services.PlayerAppearanceService;
import com.quickskin.mod.common.data.AnimationMetadata;
import com.quickskin.mod.common.data.AssetMetadata;
import com.quickskin.mod.common.data.KnownCapes;
import com.quickskin.mod.common.data.TextureQuality;
import com.quickskin.mod.common.util.HashUtil;
import com.quickskin.mod.config.ClientConfig;
import com.quickskin.mod.platform.PlatformHelper;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PlayerSkinMenuScreen
extends Screen {
    @Nullable
    private final Screen parent;
    private SkinListPanel skinListPanel;
    private PlayerPreviewPanel playerPreviewPanel;
    private ActionButtonsPanel actionButtonsPanel;
    private int panelX;
    private int panelY;
    private int panelWidth;
    private int panelHeight;
    private boolean guiScaleForced = false;
    private boolean isClosing = false;
    private float savedBodyYaw = 20.0f;
    private float savedTargetRotation = 20.0f;
    private String savedModelType = null;
    private static final int MIN_PANEL_WIDTH = 340;
    private static final int MAX_PANEL_WIDTH = 600;
    private static final int MIN_PANEL_HEIGHT = 280;
    private static final ResourceLocation STAR_PATTERN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"textures/gui/background/star_pattern.png");
    private static final ResourceLocation VIGNETTE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/misc/vignette.png");
    private final List<ErrorToast> errorToasts = new ArrayList<ErrorToast>();
    private EditBox usernameSearchField;
    private Button searchButton;
    private boolean isSearching = false;

    public PlayerSkinMenuScreen(@Nullable Screen parent) {
        super((Component)Component.literal((String)"Quick Skin"));
        this.parent = parent;
    }

    public void tick() {
        super.tick();
        this.updateDoneButtonState();
    }

    private void updateDoneButtonState() {
        if (this.actionButtonsPanel == null) {
            return;
        }
        Button doneButton = this.actionButtonsPanel.getDoneButton();
        if (doneButton == null) {
            return;
        }
        if (this.minecraft != null && this.minecraft.isSingleplayer()) {
            if (!doneButton.active) {
                doneButton.active = true;
                doneButton.setMessage((Component)Component.literal((String)"Done"));
                doneButton.setTooltip(null);
            }
            return;
        }
        long remainingSeconds = CooldownService.getInstance().getRemainingCooldownSeconds();
        if (remainingSeconds > 0L) {
            doneButton.active = false;
            doneButton.setMessage((Component)Component.literal((String)("On Cooldown (" + remainingSeconds + "s)")));
            doneButton.setTooltip(Tooltip.create((Component)Component.literal((String)"You must wait before changing your skin again.")));
        } else if (!doneButton.active) {
            doneButton.active = true;
            doneButton.setMessage((Component)Component.literal((String)"Done"));
            doneButton.setTooltip(null);
        }
    }

    protected void init() {
        if (!this.guiScaleForced && !this.isClosing) {
            this.guiScaleForced = true;
            int optimalScale = GuiScaleManager.getOptimalMenuScale();
            if (GuiScaleManager.setMenuGuiScale(optimalScale)) {
                return;
            }
        }
        super.init();
        this.clearWidgets();
        if (this.playerPreviewPanel != null) {
            PlayerWidget widget = this.playerPreviewPanel.getPlayerWidget();
            if (widget != null) {
                this.savedBodyYaw = widget.getBodyYaw();
                this.savedTargetRotation = widget.getTargetYRotation();
            }
            this.savedModelType = this.playerPreviewPanel.getCurrentModelType();
        }
        this.calculatePanelDimensions();
        int scaledPadding = 6;
        int scaledSpacing = 4;
        int scaledComponentHeight = 20;
        int leftPanelWidth = (int)((float)this.panelWidth * 0.6f);
        int rightPanelWidth = (int)((float)this.panelWidth * 0.35f);
        int componentX = this.panelX + scaledPadding;
        int yPos = this.panelY + scaledPadding + scaledComponentHeight + scaledPadding;
        int searchButtonWidth = 60;
        int searchFieldX = componentX + 4;
        int searchFieldWidth = leftPanelWidth - 4;
        this.usernameSearchField = new EditBox(this.font, searchFieldX, yPos, searchFieldWidth - searchButtonWidth - scaledSpacing, scaledComponentHeight, (Component)Component.literal((String)"Search by username"));
        this.usernameSearchField.setSuggestion("Enter a player's username...");
        this.usernameSearchField.setMaxLength(16);
        this.usernameSearchField.setResponder(text -> {
            this.onUsernameFieldChanged((String)text);
            if (text.isEmpty()) {
                this.usernameSearchField.setSuggestion("Enter a player's username...");
            } else {
                this.usernameSearchField.setSuggestion("");
            }
        });
        this.addRenderableWidget((GuiEventListener)this.usernameSearchField);
        this.searchButton = ButtonFactory.createStyled(searchFieldX + searchFieldWidth - searchButtonWidth, yPos, searchButtonWidth, scaledComponentHeight, (Component)Component.literal((String)"Search"), button -> this.searchMojangSkin());
        this.addRenderableWidget((GuiEventListener)this.searchButton);
        this.searchButton.active = false;
        int topSectionHeight = scaledPadding + scaledComponentHeight + scaledPadding + scaledComponentHeight + scaledSpacing + scaledSpacing;
        int bottomSectionHeight = scaledComponentHeight * 3 + scaledSpacing * 2 + scaledPadding;
        int listHeight = this.panelHeight - topSectionHeight - bottomSectionHeight;
        this.skinListPanel = new SkinListPanel(componentX, yPos += scaledComponentHeight + scaledSpacing, leftPanelWidth, listHeight, this.minecraft, this::onSkinSelected);
        this.skinListPanel.init(this);
        int fullWidthX = this.panelX + scaledPadding;
        int fullComponentWidth = this.panelWidth - scaledPadding * 2;
        int fourButtonWidth = (fullComponentWidth - scaledSpacing * 3) / 4;
        int actionButtonsBottomY = this.panelY + this.panelHeight - scaledPadding;
        int actionPanelHeight = scaledComponentHeight * 2 + scaledSpacing;
        int modelButtonsY = actionButtonsBottomY - actionPanelHeight - scaledComponentHeight - scaledSpacing;
        int modelButtonsX = fullWidthX + (fourButtonWidth + scaledSpacing) * 3;
        int playerWidgetX = this.panelX + this.panelWidth - rightPanelWidth - scaledPadding;
        int playerWidgetY = yPos;
        int availableHeightForWidget = this.panelHeight - topSectionHeight - bottomSectionHeight;
        this.playerPreviewPanel = new PlayerPreviewPanel(playerWidgetX, playerWidgetY, rightPanelWidth, availableHeightForWidget);
        this.playerPreviewPanel.initPlayerWidget(this);
        this.playerPreviewPanel.setModelTypeChangeCallback(this::onModelTypeChanged);
        this.playerPreviewPanel.initModelButtons(this, modelButtonsX, modelButtonsY, fourButtonWidth, scaledComponentHeight, scaledSpacing);
        int bottomY = actionButtonsBottomY - scaledComponentHeight * 2 - scaledSpacing;
        ActionButtonsPanel.ActionCallbacks callbacks = new ActionButtonsPanel.ActionCallbacks(this::openImportDialog, () -> {
            if (this.minecraft != null) {
                this.minecraft.options.chatLinksPrompt().set((Object)false);
                Util.getPlatform().openUri("https://mcskins.top/128x128/");
            }
        }, () -> {
            if (this.minecraft != null) {
                this.minecraft.options.chatLinksPrompt().set((Object)false);
                Util.getPlatform().openUri("https://laby.net/skins?order=trending_30d");
            }
        }, () -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)new PlayerCapeMenuScreen(this));
            }
        }, this::onClose);
        this.actionButtonsPanel = new ActionButtonsPanel(fullWidthX, bottomY, fullComponentWidth, actionPanelHeight, callbacks);
        this.actionButtonsPanel.init(this, callbacks);
        int linkButtonY = this.panelY + scaledPadding;
        int linkPanelWidth = (scaledComponentHeight + scaledSpacing) * 4;
        int linkPanelX = this.panelX + this.panelWidth - linkPanelWidth - scaledPadding;
        LinkButtonsPanel linkButtonsPanel = new LinkButtonsPanel(linkPanelX, linkButtonY, linkPanelWidth, scaledComponentHeight);
        linkButtonsPanel.init(this);
        this.restoreSavedState();
    }

    private void restoreSavedState() {
        PlayerWidget widget;
        String capeId;
        ResourceLocation capeLocation;
        AssetMetadata playerOwnSkin;
        ClientConfig config = ClientConfig.getInstance();
        boolean isResizing = this.savedModelType != null;
        AssetMetadata selectedSkin = null;
        if (!config.activeSkinHash.isEmpty() && this.skinListPanel != null) {
            AssetMetadata metadata = LocalAssetManager.getInstance().getMetadata(config.activeSkinHash);
            if (metadata != null) {
                this.skinListPanel.setSelected(metadata, !isResizing);
                selectedSkin = metadata;
            }
        } else if (config.activeSkinHash.isEmpty() && !config.playerOwnSkinHash.isEmpty() && this.skinListPanel != null && (playerOwnSkin = LocalAssetManager.getInstance().getMetadata(config.playerOwnSkinHash)) != null) {
            this.skinListPanel.setSelected(playerOwnSkin, !isResizing);
            selectedSkin = playerOwnSkin;
            QuickSkin.LOGGER.info("Auto-selected player's own skin in menu");
        }
        if (this.playerPreviewPanel != null && selectedSkin != null && isResizing) {
            this.playerPreviewPanel.setCurrentModelType(this.savedModelType);
            this.playerPreviewPanel.updateSkin(selectedSkin, LocalAssetManager.getInstance().getTextureLocation(selectedSkin.hash(), TextureQuality.FULL));
            this.savedModelType = null;
        }
        if (!config.activeCapeHash.isEmpty() && this.playerPreviewPanel != null && (capeLocation = this.getCapeLocationFromId(capeId = config.activeCapeHash)) != null) {
            this.registerCapeAnimationIfNeeded(capeId, capeLocation);
            this.playerPreviewPanel.updateCape(capeLocation, capeId);
        }
        if (this.playerPreviewPanel != null && (widget = this.playerPreviewPanel.getPlayerWidget()) != null) {
            widget.setRotationState(this.savedBodyYaw, this.savedTargetRotation);
        }
    }

    @Nullable
    private ResourceLocation getCapeLocationFromId(String capeId) {
        if (capeId.startsWith("local_cape:")) {
            String hash = capeId.substring("local_cape:".length());
            return LocalAssetManager.getInstance().getTextureLocation(hash, TextureQuality.FULL);
        }
        if (capeId.startsWith("known:")) {
            String id = capeId.substring("known:".length());
            KnownCapes knownCape = KnownCapes.getById(id);
            if (knownCape != null) {
                return knownCape.getTextureLocation();
            }
            QuickSkin.LOGGER.warn("Unknown cape ID: {}", (Object)id);
            return null;
        }
        return null;
    }

    private void registerCapeAnimationIfNeeded(String capeId, ResourceLocation capeLocation) {
        if (capeId.startsWith("local_cape:")) {
            BufferedImage atlasImage;
            String hash = capeId.substring("local_cape:".length());
            String animationId = "cape_" + hash;
            AnimationMetadata metadata = LocalAssetManager.getInstance().getAnimationMetadata(hash);
            if (metadata != null && metadata.frameCount() > 1 && (atlasImage = LocalAssetManager.getInstance().getSourceImage(hash)) != null) {
                QuickSkin.LOGGER.info("Registering animation for cape in skin menu: {}", (Object)animationId);
                AnimatedTextureManager.getInstance().registerAnimation(animationId, capeId, capeLocation, atlasImage, metadata);
            }
        }
    }

    private void calculatePanelDimensions() {
        int minRequiredWidth;
        int desiredWidth = (int)((float)this.width * 0.5f);
        int desiredHeight = (int)((float)this.height * 0.8f);
        this.panelWidth = Mth.clamp((int)desiredWidth, (int)340, (int)Math.min(600, this.width - 80));
        this.panelHeight = Mth.clamp((int)desiredHeight, (int)280, (int)(this.height - 80));
        int minRequiredHeight = this.calculateMinRequiredHeight();
        if (this.panelHeight < minRequiredHeight) {
            this.panelHeight = Math.min(minRequiredHeight, this.height - 40);
        }
        if (this.panelWidth < (minRequiredWidth = this.calculateMinRequiredWidth())) {
            this.panelWidth = Math.min(minRequiredWidth, this.width - 40);
        }
        this.panelX = (this.width - this.panelWidth) / 2;
        this.panelY = (this.height - this.panelHeight) / 2;
    }

    private int calculateMinRequiredHeight() {
        int scaledPadding = 6;
        int scaledComponentHeight = 20;
        int scaledSpacing = 4;
        return scaledPadding * 4 + scaledComponentHeight * 7 + scaledSpacing * 4 + 120;
    }

    private int calculateMinRequiredWidth() {
        int scaledPadding = 6;
        int scaledSpacing = 4;
        return 370 + scaledPadding * 3 + scaledSpacing * 2;
    }

    private void renderBackgroundEffects(GuiGraphics graphics, float partialTick) {
        graphics.fill(0, 0, this.width, this.height, -16777216);
        this.renderStarPattern(graphics, partialTick);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.75f);
        PlatformHelper.blit(graphics, VIGNETTE_LOCATION, 0, 0, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderStarPattern(GuiGraphics graphics, float partialTick) {
        double pixelsPerSecond = 5.0;
        int tileSize = StarPatternCache.getTileSize();
        int tickCount = this.minecraft != null ? this.minecraft.gui.getGuiTicks() : 0;
        double smoothTime = (double)((float)tickCount + partialTick) / 20.0;
        double offsetX = smoothTime * pixelsPerSecond % (double)tileSize;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
        ResourceLocation cacheTexture = StarPatternCache.getTextureLocation();
        int cacheWidth = StarPatternCache.getTextureWidth();
        int cacheHeight = StarPatternCache.getTextureHeight();
        float u0 = (float)offsetX / (float)cacheWidth;
        float v0 = 0.0f;
        float u1 = u0 + (float)this.width / (float)cacheWidth;
        float v1 = (float)this.height / (float)cacheHeight;
        PoseStack pose = graphics.pose();
        pose.pushPose();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)cacheTexture);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(pose.last().pose(), 0.0f, (float)this.height, 0.0f).setUv(u0, v1);
        bufferBuilder.addVertex(pose.last().pose(), (float)this.width, (float)this.height, 0.0f).setUv(u1, v1);
        bufferBuilder.addVertex(pose.last().pose(), (float)this.width, 0.0f, 0.0f).setUv(u1, v0);
        bufferBuilder.addVertex(pose.last().pose(), 0.0f, 0.0f, 0.0f).setUv(u0, v0);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        pose.popPose();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackgroundEffects(graphics, partialTick);
        this.renderPanel(graphics);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, this.panelY + 10, 0xFFFFFF);
        graphics.pose().pushPose();
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.pose().popPose();
        this.renderErrorToasts(graphics);
    }

    private void renderPanel(GuiGraphics graphics) {
        graphics.fill(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, -1342177280);
        graphics.fill(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + 1, 0x60FFFFFF);
        graphics.fill(this.panelX, this.panelY + this.panelHeight - 1, this.panelX + this.panelWidth, this.panelY + this.panelHeight, 0x60FFFFFF);
        graphics.fill(this.panelX, this.panelY + 1, this.panelX + 1, this.panelY + this.panelHeight - 1, 0x60FFFFFF);
        graphics.fill(this.panelX + this.panelWidth - 1, this.panelY + 1, this.panelX + this.panelWidth, this.panelY + this.panelHeight - 1, 0x60FFFFFF);
    }

    public void removed() {
        super.removed();
        if (this.isClosing) {
            this.restoreGuiScaleIfNeeded();
        }
    }

    public void onClose() {
        this.isClosing = true;
        this.restoreGuiScaleIfNeeded();
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }

    private void restoreGuiScaleIfNeeded() {
        if (this.guiScaleForced) {
            this.guiScaleForced = false;
            GuiScaleManager.restoreOriginalGuiScale();
            QuickSkin.LOGGER.info("PlayerSkinMenuScreen - GUI scale restored");
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBlurredBackground(float partialTick) {
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        PlayerWidget widget;
        if (this.playerPreviewPanel != null && (widget = this.playerPreviewPanel.getPlayerWidget()) != null && widget.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((GuiEventListener)widget);
            if (button == 0) {
                this.setDragging(true);
            }
            return true;
        }
        if (PlayerModelRenderer.handleDebugMousePressed((int)mouseX, (int)mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (PlayerModelRenderer.handleDebugMouseDragged((int)mouseX, (int)mouseY, button)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (PlayerModelRenderer.handleDebugMouseReleased((int)mouseX, (int)mouseY, button)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        PlayerWidget widget;
        if (this.playerPreviewPanel != null && (widget = this.playerPreviewPanel.getPlayerWidget()) != null && widget.mouseScrolled(mouseX, mouseY, deltaX, deltaY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public void onFilesDrop(List<Path> files) {
        QuickSkin.LOGGER.info("Files dropped: {}", (Object)files.size());
        List<Path> pngFiles = files.stream().filter(path -> path.toString().toLowerCase().endsWith(".png")).toList();
        if (pngFiles.isEmpty()) {
            QuickSkin.LOGGER.warn("No PNG files in drop");
            return;
        }
        QuickSkin.LOGGER.info("Processing {} PNG files", (Object)pngFiles.size());
        if (this.minecraft != null) {
            this.minecraft.execute(() -> {
                List<AssetMetadata> imported = SkinImporter.importSkins(pngFiles.toArray(new Path[0]));
                if (!imported.isEmpty()) {
                    QuickSkin.LOGGER.info("Successfully imported {} skins", (Object)imported.size());
                    this.refreshSkinList();
                    if (this.skinListPanel != null && !imported.isEmpty()) {
                        AssetMetadata firstImported = imported.get(0);
                        this.skinListPanel.setSelected(firstImported);
                    }
                }
            });
        }
    }

    public void onSkinSelected(SkinEntry entry) {
        if (this.playerPreviewPanel != null && entry != null) {
            AssetMetadata metadata = entry.getMetadata();
            String modelType = LocalAssetManager.getInstance().getSkinModelPreference(metadata.hash());
            QuickSkin.LOGGER.info("onSkinSelected: Loading model preference for skin {}: {}", (Object)metadata.friendlyName(), (Object)modelType);
            this.playerPreviewPanel.setCurrentModelType(modelType);
            this.playerPreviewPanel.updateSkin(metadata, LocalAssetManager.getInstance().getTextureLocation(metadata.hash(), TextureQuality.FULL));
            ClientConfig config = ClientConfig.getInstance();
            boolean isSkinAlreadyActive = metadata.hash().equals(config.activeSkinHash);
            if (!isSkinAlreadyActive) {
                config.activeSkinHash = metadata.hash();
                config.save();
                QuickSkin.LOGGER.info("Set active skin in config: {}", (Object)metadata.friendlyName());
                if (this.minecraft != null && this.minecraft.player != null) {
                    String skinId = "local_skin:" + metadata.hash();
                    String modelForService = modelType;
                    PlayerAppearanceService.getInstance().applySkin(this.minecraft.player.getUUID(), skinId, modelForService);
                    QuickSkin.LOGGER.info("Applied skin to player: {} with model type: {}", (Object)metadata.friendlyName(), (Object)modelForService);
                }
            }
        }
    }

    private void onModelTypeChanged(String newModelType) {
        SkinEntry selectedEntry;
        SkinEntry skinEntry = selectedEntry = this.skinListPanel != null ? this.skinListPanel.getSelected() : null;
        if (selectedEntry != null) {
            AssetMetadata metadata = selectedEntry.getMetadata();
            String skinId = "local_skin:" + metadata.hash();
            QuickSkin.LOGGER.info("Changed model type to: {} for skin: {}", (Object)newModelType, (Object)metadata.friendlyName());
            LocalAssetManager.getInstance().setSkinModelPreference(metadata.hash(), newModelType);
            if (this.minecraft != null && this.minecraft.player != null) {
                PlayerAppearanceService.getInstance().applySkin(this.minecraft.player.getUUID(), skinId, newModelType);
            }
        }
    }

    public Font getFont() {
        return this.font;
    }

    public <T extends GuiEventListener & Renderable> void registerWidget(T widget) {
        this.addRenderableWidget(widget);
    }

    private void openImportDialog() {
        FileDialogHelper.openSkinFileDialog("Select Skin File", this::handleSkinImport);
    }

    private void handleSkinImport(Path filePath) {
        if (filePath == null) {
            return;
        }
        QuickSkin.LOGGER.info("Importing skin: {}", (Object)filePath);
        if (this.minecraft != null) {
            this.minecraft.execute(() -> {
                AssetMetadata metadata = SkinImporter.importSkin(filePath);
                if (metadata != null) {
                    QuickSkin.LOGGER.info("Successfully imported skin: {}", (Object)metadata.friendlyName());
                    this.refreshSkinList();
                    if (this.skinListPanel != null) {
                        this.skinListPanel.setSelected(metadata);
                    }
                } else {
                    QuickSkin.LOGGER.error("Failed to import skin: {}", (Object)filePath);
                    this.showError((Component)Component.literal((String)"Failed to import skin"));
                }
            });
        }
    }

    public void refreshSkinList() {
        if (this.skinListPanel != null) {
            this.skinListPanel.refresh();
        }
    }

    public void showError(Component message) {
        this.errorToasts.add(new ErrorToast(message));
    }

    private void renderErrorToasts(GuiGraphics graphics) {
        this.errorToasts.removeIf(toast -> !toast.render(graphics, this.width));
    }

    public void showDeleteConfirmation(AssetMetadata metadata) {
        if (this.minecraft == null) {
            return;
        }
        String displayName = this.truncateFileName(metadata.friendlyName());
        this.minecraft.setScreen((Screen)new DeletionConfirmScreen(this, (Component)Component.literal((String)"Delete Skin?"), (Component)Component.literal((String)("Are you sure you want to delete \"" + displayName + "\"?")), confirmed -> {
            if (confirmed.booleanValue()) {
                this.deleteSkin(metadata);
            }
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)this);
            }
        }, true));
    }

    public void showRenameDialog(AssetMetadata metadata) {
        if (this.minecraft == null) {
            return;
        }
        this.minecraft.setScreen((Screen)new RenameScreen(this, (Component)Component.literal((String)"Rename Skin File"), (Component)Component.empty(), metadata.friendlyName(), newName -> {
            this.renameSkin(metadata, (String)newName);
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)this);
            }
        }));
    }

    private String truncateFileName(String name) {
        if (name.length() <= 35) {
            return name;
        }
        return name.substring(0, 32) + "...";
    }

    private void deleteSkin(AssetMetadata metadata) {
        ClientConfig config = ClientConfig.getInstance();
        if (config.enablePlayerOwnSkinSystem && metadata.hash().equals(config.playerOwnSkinHash)) {
            QuickSkin.LOGGER.warn("Cannot delete player's own skin: {}", (Object)metadata.friendlyName());
            this.showError((Component)Component.literal((String)"Cannot delete your own skin!"));
            return;
        }
        try {
            AssetMetadata playerOwnSkin;
            Files.deleteIfExists(metadata.path());
            if (this.minecraft != null) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.0f));
            }
            LocalAssetManager.getInstance().discoverLocalAssets();
            this.refreshSkinList();
            if (!config.playerOwnSkinHash.isEmpty() && this.skinListPanel != null && (playerOwnSkin = LocalAssetManager.getInstance().getMetadata(config.playerOwnSkinHash)) != null) {
                this.skinListPanel.setSelected(playerOwnSkin, true);
                QuickSkin.LOGGER.info("Auto-selected player's own skin after deletion");
            }
            QuickSkin.LOGGER.info("Deleted skin: {}", (Object)metadata.friendlyName());
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to delete skin: {}", (Object)metadata.friendlyName(), (Object)e);
            this.showError((Component)Component.literal((String)("Failed to delete skin: " + e.getMessage())));
        }
    }

    private void renameSkin(AssetMetadata metadata, String newName) {
        LocalAssetManager.RenameResult result = LocalAssetManager.getInstance().renameLocalAsset(metadata.hash(), newName);
        switch (result) {
            case SUCCESS: {
                AssetMetadata updatedMetadata;
                QuickSkin.LOGGER.info("Successfully renamed skin to: {}", (Object)newName);
                if (this.minecraft != null) {
                    this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.0f));
                }
                this.refreshSkinList();
                if (this.skinListPanel == null || (updatedMetadata = LocalAssetManager.getInstance().getMetadata(metadata.hash())) == null) break;
                this.skinListPanel.setSelected(updatedMetadata);
                break;
            }
            case NAME_TAKEN: {
                QuickSkin.LOGGER.warn("Rename failed: Name already exists");
                this.showError((Component)Component.literal((String)"Error: A skin file with that name already exists."));
                break;
            }
            case INVALID_NAME: {
                QuickSkin.LOGGER.warn("Rename failed: Invalid name");
                this.showError((Component)Component.literal((String)"Error: The name contains invalid characters or is empty."));
                break;
            }
            case IO_ERROR: {
                QuickSkin.LOGGER.error("Rename failed: IO error");
                this.showError((Component)Component.literal((String)"Error: Could not rename the file. See logs."));
                break;
            }
            case NOT_FOUND: {
                QuickSkin.LOGGER.error("Rename failed: File not found");
                this.showError((Component)Component.literal((String)"Error: Could not find the original file."));
            }
        }
    }

    private void onUsernameFieldChanged(String text) {
        if (this.searchButton != null) {
            this.searchButton.active = !text.trim().isEmpty() && !this.isSearching;
        }
    }

    private void searchMojangSkin() {
        if (this.usernameSearchField == null || this.isSearching) {
            return;
        }
        String username = this.usernameSearchField.getValue().trim();
        if (username.isEmpty()) {
            return;
        }
        this.isSearching = true;
        this.searchButton.active = false;
        this.searchButton.setMessage((Component)Component.literal((String)"Searching..."));
        QuickSkin.LOGGER.info("Searching for Mojang skin: {}", (Object)username);
        ((CompletableFuture)MojangApiService.getInstance().fetchSkinByUsername(username).thenAccept(skinData -> {
            if (this.minecraft != null) {
                this.minecraft.execute(() -> {
                    if (skinData != null) {
                        this.handleMojangSkinFetched((MojangApiService.MojangSkinData)skinData);
                    } else {
                        this.showError((Component)Component.literal((String)("Player not found: " + username)));
                        this.resetSearchButton();
                    }
                });
            }
        })).exceptionally(throwable -> {
            QuickSkin.LOGGER.error("Error fetching Mojang skin", throwable);
            if (this.minecraft != null) {
                this.minecraft.execute(() -> {
                    this.showError((Component)Component.literal((String)("Failed to fetch skin: " + throwable.getMessage())));
                    this.resetSearchButton();
                });
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMojangSkinFetched(MojangApiService.MojangSkinData skinData) {
        try {
            Path skinPath = SkinImporter.saveSkinImage(skinData.image, skinData.username);
            if (skinPath != null) {
                QuickSkin.LOGGER.info("Successfully saved Mojang skin for: {}", (Object)skinData.username);
                LocalAssetManager.getInstance().reload();
                String hash = HashUtil.computeFileHash(skinPath);
                if (hash != null) {
                    AssetMetadata metadata = LocalAssetManager.getInstance().getMetadata(hash);
                    if (metadata != null) {
                        this.refreshSkinList();
                        if (this.skinListPanel != null) {
                            this.skinListPanel.setSelected(metadata);
                        }
                        this.usernameSearchField.setValue("");
                        if (this.minecraft != null) {
                            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.0f));
                        }
                    } else {
                        this.showError((Component)Component.literal((String)"Failed to load skin metadata"));
                    }
                } else {
                    this.showError((Component)Component.literal((String)"Failed to compute file hash"));
                }
            } else {
                this.showError((Component)Component.literal((String)"Failed to save skin image"));
            }
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Error handling Mojang skin", (Throwable)e);
            this.showError((Component)Component.literal((String)("Error: " + e.getMessage())));
        }
        finally {
            this.resetSearchButton();
        }
    }

    private void resetSearchButton() {
        this.isSearching = false;
        if (this.searchButton != null) {
            this.searchButton.setMessage((Component)Component.literal((String)"Search"));
            this.searchButton.active = this.usernameSearchField != null && !this.usernameSearchField.getValue().trim().isEmpty();
        }
    }
}

