/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.screen;

import com.quickskin.mod.client.gui.effect.BlurHandler;
import com.quickskin.mod.client.gui.util.ButtonFactory;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenameScreen
extends Screen {
    private final Screen parent;
    private final Component message;
    private final String initialValue;
    private final Consumer<String> callback;
    private EditBox nameEditBox;
    private Button confirmButton;
    private static final int PANEL_BG = -1342177280;
    private static final int PANEL_OUTLINE = 0x60FFFFFF;
    private static final int TITLE_COLOR = 0xFFFFFF;
    private static final int MESSAGE_COLOR = 0xFFFFFF;
    private final int panelWidth = 340;
    private final int panelHeight = 180;
    private int panelX;
    private int panelY;

    public RenameScreen(Screen parent, Component title, Component message, String initialValue, Consumer<String> callback) {
        super(title);
        this.parent = parent;
        this.message = message;
        this.initialValue = initialValue;
        this.callback = callback;
    }

    protected void init() {
        super.init();
        this.panelX = (this.width - this.panelWidth) / 2;
        this.panelY = (this.height - this.panelHeight) / 2;
        int boxWidth = 260;
        int boxX = this.panelX + (this.panelWidth - boxWidth) / 2;
        int boxY = this.panelY + 75;
        this.nameEditBox = new EditBox(this.font, boxX, boxY, boxWidth, 20, this.title);
        this.nameEditBox.setMaxLength(50);
        this.nameEditBox.setValue(this.initialValue);
        this.nameEditBox.setResponder(this::onNameChanged);
        this.addRenderableWidget((GuiEventListener)this.nameEditBox);
        this.setInitialFocus((GuiEventListener)this.nameEditBox);
        int buttonWidth = 120;
        int buttonHeight = 20;
        int buttonSpacing = 10;
        int buttonY = this.panelY + this.panelHeight - buttonHeight - 20;
        int totalButtonWidth = buttonWidth * 2 + buttonSpacing;
        int buttonStartX = this.panelX + (this.panelWidth - totalButtonWidth) / 2;
        this.addRenderableWidget((GuiEventListener)ButtonFactory.createStyled(buttonStartX, buttonY, buttonWidth, buttonHeight, CommonComponents.GUI_CANCEL, button -> this.onClose()));
        this.confirmButton = (Button)this.addRenderableWidget((GuiEventListener)ButtonFactory.createStyled(buttonStartX + buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, CommonComponents.GUI_DONE, button -> {
            this.callback.accept(this.nameEditBox.getValue());
            this.onClose();
        }));
        this.onNameChanged(this.initialValue);
    }

    private void onNameChanged(String newName) {
        if (this.confirmButton != null) {
            this.confirmButton.active = !newName.trim().isEmpty();
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 257 || keyCode == 335) && this.confirmButton.active) {
            this.confirmButton.onPress();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.parent != null) {
            this.parent.render(graphics, -1, -1, partialTicks);
        }
        graphics.flush();
        BlurHandler.renderBlur();
        graphics.fill(0, 0, this.width, this.height, 0x60000000);
        graphics.fill(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, -1342177280);
        graphics.fill(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + 1, 0x60FFFFFF);
        graphics.fill(this.panelX, this.panelY + this.panelHeight - 1, this.panelX + this.panelWidth, this.panelY + this.panelHeight, 0x60FFFFFF);
        graphics.fill(this.panelX, this.panelY, this.panelX + 1, this.panelY + this.panelHeight, 0x60FFFFFF);
        graphics.fill(this.panelX + this.panelWidth - 1, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, 0x60FFFFFF);
        int titleY = this.panelY + 20;
        graphics.drawCenteredString(this.font, this.title, this.width / 2, titleY, 0xFFFFFF);
        if (!this.message.getString().isEmpty()) {
            int messageY = this.panelY + 45;
            graphics.drawCenteredString(this.font, this.message, this.width / 2, messageY, 0xFFFFFF);
        }
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    public void removed() {
        super.removed();
        BlurHandler.cleanup();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.panelX || mouseX > (double)(this.panelX + this.panelWidth) || mouseY < (double)this.panelY || mouseY > (double)(this.panelY + this.panelHeight)) {
            this.onClose();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }

    public void renderBlurredBackground(float partialTick) {
    }
}

