/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.quickskin.mod.client.gui.effect.BlurHandler;
import com.quickskin.mod.client.gui.screen.PlayerCapeMenuScreen;
import com.quickskin.mod.client.gui.screen.PlayerSkinMenuScreen;
import com.quickskin.mod.client.gui.util.ButtonFactory;
import com.quickskin.mod.client.gui.widget.TabButton;
import com.quickskin.mod.client.input.KeybindRegistry;
import com.quickskin.mod.client.services.PlayerAppearanceService;
import com.quickskin.mod.config.ClientConfig;
import com.quickskin.mod.config.ServerConfig;
import com.quickskin.mod.networking.ClientNetworkHandler;
import com.quickskin.mod.networking.payloads.UpdateServerConfigPayload;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SettingsScreen
extends Screen {
    @Nullable
    private final Screen parent;
    private static final int PANEL_BG = -1342177280;
    private static final int PANEL_OUTLINE = 0x60FFFFFF;
    private static final int TAB_HEIGHT = 30;
    private static final int TAB_WIDTH = 100;
    private static final int TAB_SPACING = 2;
    private int dialogX;
    private int dialogY;
    private int dialogWidth = 480;
    private int dialogHeight = 280;
    private Tab activeTab = Tab.CLIENT;
    private TabButton guiEditTabButton;
    private TabButton clientTabButton;
    private TabButton serverTabButton;
    private TabButton modpackTabButton;
    private final List<AbstractWidget> guiEditSettingWidgets = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> clientSettingWidgets = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> serverSettingWidgets = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> modpackSettingWidgets = new ArrayList<AbstractWidget>();
    private Checkbox showOverlayCheckbox;
    private Checkbox disableSkinTransparencyCheckbox;
    private Checkbox enableStyledButtonsCheckbox;
    private Checkbox enablePlayerPreviewCustomizationCheckbox;
    private Button keybindButton;
    @Nullable
    private KeyMapping selectedKey;
    private Checkbox serverDisableSkinTransparencyCheckbox;
    private EditBox skinChangeCooldownEditBox;
    private Checkbox enablePlayerOwnSkinSystemCheckbox;
    private boolean needsTextureReload = false;

    public SettingsScreen(@Nullable Screen parent) {
        super((Component)Component.literal((String)"QuickSkin Settings"));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        this.guiEditSettingWidgets.clear();
        this.clientSettingWidgets.clear();
        this.serverSettingWidgets.clear();
        this.modpackSettingWidgets.clear();
        this.dialogWidth = Math.min(480, this.width - 40);
        this.dialogHeight = Math.min(280, this.height - 40);
        this.dialogX = (this.width - this.dialogWidth) / 2;
        int tabY = this.dialogY = (this.height - this.dialogHeight) / 2;
        int tabStartX = this.dialogX;
        this.clientTabButton = (TabButton)ButtonFactory.createTab(tabStartX, tabY, 100, 30, (Component)Component.literal((String)Tab.CLIENT.getDisplayName()), this.activeTab == Tab.CLIENT, btn -> this.switchTab(Tab.CLIENT));
        this.addRenderableWidget((GuiEventListener)this.clientTabButton);
        this.guiEditTabButton = (TabButton)ButtonFactory.createTab(tabStartX + 100 + 2, tabY, 100, 30, (Component)Component.literal((String)Tab.GUI_EDIT.getDisplayName()), this.activeTab == Tab.GUI_EDIT, btn -> this.switchTab(Tab.GUI_EDIT));
        this.addRenderableWidget((GuiEventListener)this.guiEditTabButton);
        this.modpackTabButton = (TabButton)ButtonFactory.createTab(tabStartX + 204, tabY, 100, 30, (Component)Component.literal((String)Tab.MODPACK.getDisplayName()), this.activeTab == Tab.MODPACK, btn -> this.switchTab(Tab.MODPACK));
        this.addRenderableWidget((GuiEventListener)this.modpackTabButton);
        this.serverTabButton = (TabButton)ButtonFactory.createTab(tabStartX + 306, tabY, 100, 30, (Component)Component.literal((String)Tab.SERVER.getDisplayName()), this.activeTab == Tab.SERVER, btn -> this.switchTab(Tab.SERVER));
        this.addRenderableWidget((GuiEventListener)this.serverTabButton);
        this.createGuiEditSettings();
        this.createClientSettings();
        this.createServerSettings();
        this.createModpackSettings();
        Button doneButton = ButtonFactory.createPrimary(this.dialogX + this.dialogWidth / 2 - 50, this.dialogY + this.dialogHeight - 30, 100, 20, (Component)Component.literal((String)"Done"), btn -> this.onClose());
        this.addRenderableWidget((GuiEventListener)doneButton);
        this.switchTab(this.activeTab);
    }

    private void createGuiEditSettings() {
        ClientConfig config = ClientConfig.getInstance();
        int checkboxSize = 20;
        int spacing = 30;
        int startY = this.dialogY + 30 + 20;
        int leftColumnX = this.dialogX + 20;
        int currentY = startY;
        this.showOverlayCheckbox = Checkbox.builder((Component)Component.literal((String)"Enable mini player preview ingame"), (Font)this.font).pos(leftColumnX, currentY).selected(config.showSkinPreviewOverlay).build();
        this.guiEditSettingWidgets.add((AbstractWidget)this.showOverlayCheckbox);
        this.enableStyledButtonsCheckbox = Checkbox.builder((Component)Component.literal((String)"Enable Styled Buttons"), (Font)this.font).pos(leftColumnX, currentY += spacing).selected(config.enableStyledButtons).build();
        this.guiEditSettingWidgets.add((AbstractWidget)this.enableStyledButtonsCheckbox);
        this.enablePlayerPreviewCustomizationCheckbox = Checkbox.builder((Component)Component.literal((String)"Enable Preview Customization"), (Font)this.font).pos(leftColumnX, currentY += spacing).selected(config.enablePlayerPreviewCustomization).build();
        this.guiEditSettingWidgets.add((AbstractWidget)this.enablePlayerPreviewCustomizationCheckbox);
    }

    private void createClientSettings() {
        ClientConfig config = ClientConfig.getInstance();
        int checkboxSize = 20;
        int spacing = 30;
        int startY = this.dialogY + 30 + 20;
        int leftColumnX = this.dialogX + 20;
        int rightColumnX = this.dialogX + this.dialogWidth / 2 + 10;
        int currentLeftY = startY;
        int currentRightY = startY;
        int keybindButtonWidth = 75;
        int keybindButtonSpacing = 5;
        this.keybindButton = ButtonFactory.createStyled(leftColumnX, currentLeftY, keybindButtonWidth, 20, KeybindRegistry.OPEN_SKIN_MENU.getTranslatedKeyMessage(), button -> {
            this.selectedKey = KeybindRegistry.OPEN_SKIN_MENU;
        });
        this.clientSettingWidgets.add((AbstractWidget)this.keybindButton);
        this.clientSettingWidgets.add(new AbstractWidget(this, leftColumnX + keybindButtonWidth + keybindButtonSpacing, currentLeftY, 100, 20, (Component)Component.literal((String)"Open Skin Menu")){

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                guiGraphics.drawString(Minecraft.getInstance().font, this.getMessage(), this.getX(), this.getY() + (this.height - 8) / 2, 0xE0E0E0);
            }

            public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
                narrationElementOutput.add(NarratedElementType.TITLE, this.getMessage());
            }

            public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
                return false;
            }
        });
        this.disableSkinTransparencyCheckbox = Checkbox.builder((Component)Component.literal((String)"Disable Skin Transparency"), (Font)this.font).pos(rightColumnX, currentRightY).selected(config.disableSkinTransparency).build();
        this.clientSettingWidgets.add((AbstractWidget)this.disableSkinTransparencyCheckbox);
    }

    private void createServerSettings() {
        ServerConfig config = ServerConfig.getInstance();
        int checkboxSize = 20;
        int spacing = 30;
        int startY = this.dialogY + 30 + 20;
        int leftColumnX = this.dialogX + 20;
        int currentY = startY;
        boolean isAdmin = this.minecraft != null && this.minecraft.player != null && this.minecraft.player.hasPermissions(2);
        ServerConfig serverOverride = ClientConfig.getInstance().getServerOverride();
        boolean currentTransparencySetting = serverOverride != null ? serverOverride.disableSkinTransparency : false;
        this.serverDisableSkinTransparencyCheckbox = Checkbox.builder((Component)Component.literal((String)"Disable Skin Transparency (Server)"), (Font)this.font).pos(leftColumnX, currentY).selected(currentTransparencySetting).build();
        this.serverDisableSkinTransparencyCheckbox.active = isAdmin;
        this.serverSettingWidgets.add((AbstractWidget)this.serverDisableSkinTransparencyCheckbox);
        int editBoxWidth = 60;
        int editBoxSpacing = 5;
        this.skinChangeCooldownEditBox = new EditBox(this.font, leftColumnX, currentY += spacing, editBoxWidth, 20, (Component)Component.literal((String)"Skin Change Cooldown"));
        this.skinChangeCooldownEditBox.setValue(String.valueOf(config.skinChangeCooldownSeconds));
        this.skinChangeCooldownEditBox.setMaxLength(5);
        this.skinChangeCooldownEditBox.setFilter(text -> text.isEmpty() || text.matches("\\d+"));
        this.skinChangeCooldownEditBox.active = isAdmin;
        this.serverSettingWidgets.add((AbstractWidget)this.skinChangeCooldownEditBox);
        this.serverSettingWidgets.add(new AbstractWidget(this, leftColumnX + editBoxWidth + editBoxSpacing, currentY, 200, 20, (Component)Component.literal((String)"Skin Change Cooldown (seconds)")){

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                guiGraphics.drawString(Minecraft.getInstance().font, this.getMessage(), this.getX(), this.getY() + (this.height - 8) / 2, 0xE0E0E0);
            }

            public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
                narrationElementOutput.add(NarratedElementType.TITLE, this.getMessage());
            }

            public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
                return false;
            }
        });
    }

    private void createModpackSettings() {
        ClientConfig config = ClientConfig.getInstance();
        int startY = this.dialogY + 30 + 20;
        int leftColumnX = this.dialogX + 20;
        this.enablePlayerOwnSkinSystemCheckbox = Checkbox.builder((Component)Component.literal((String)"Enable Player's Own Skin System"), (Font)this.font).pos(leftColumnX, startY).selected(config.enablePlayerOwnSkinSystem).tooltip(Tooltip.create((Component)Component.literal((String)"When enabled, automatically downloads your Mojang skin and protects it from being deleted. Disable for modpacks where all players should use provided skins."))).build();
        this.modpackSettingWidgets.add((AbstractWidget)this.enablePlayerOwnSkinSystemCheckbox);
    }

    private void switchTab(Tab tab) {
        this.activeTab = tab;
        for (AbstractWidget widget : this.guiEditSettingWidgets) {
            this.removeWidget((GuiEventListener)widget);
        }
        for (AbstractWidget widget : this.clientSettingWidgets) {
            this.removeWidget((GuiEventListener)widget);
        }
        for (AbstractWidget widget : this.serverSettingWidgets) {
            this.removeWidget((GuiEventListener)widget);
        }
        for (AbstractWidget widget : this.modpackSettingWidgets) {
            this.removeWidget((GuiEventListener)widget);
        }
        List<AbstractWidget> activeWidgets = switch (tab.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.guiEditSettingWidgets;
            case 1 -> this.clientSettingWidgets;
            case 2 -> this.serverSettingWidgets;
            case 3 -> this.modpackSettingWidgets;
        };
        for (AbstractWidget widget : activeWidgets) {
            this.addRenderableWidget((GuiEventListener)widget);
        }
        this.guiEditTabButton.setSelected(tab == Tab.GUI_EDIT);
        this.clientTabButton.setSelected(tab == Tab.CLIENT);
        this.serverTabButton.setSelected(tab == Tab.SERVER);
        this.modpackTabButton.setSelected(tab == Tab.MODPACK);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.parent != null) {
            this.parent.render(graphics, -1, -1, partialTick);
        }
        graphics.flush();
        BlurHandler.renderBlur();
        if (this.selectedKey == KeybindRegistry.OPEN_SKIN_MENU) {
            this.keybindButton.setMessage((Component)Component.literal((String)"> ").append((Component)Component.literal((String)"???").withStyle(ChatFormatting.YELLOW)).append(" <"));
        } else {
            this.keybindButton.setMessage(KeybindRegistry.OPEN_SKIN_MENU.getTranslatedKeyMessage());
        }
        graphics.fill(0, 0, this.width, this.height, 0x60000000);
        int contentPanelY = this.dialogY + 30;
        int contentPanelHeight = this.dialogHeight - 30;
        graphics.fill(this.dialogX, contentPanelY, this.dialogX + this.dialogWidth, contentPanelY + contentPanelHeight, -1342177280);
        this.drawPanelOutline(graphics, this.dialogX, contentPanelY, this.dialogWidth, contentPanelHeight, 0x60FFFFFF);
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.activeTab == Tab.SERVER && this.minecraft != null) {
            boolean isAdmin;
            boolean bl = isAdmin = this.minecraft.player != null && this.minecraft.player.hasPermissions(2);
            if (!isAdmin) {
                int noticeY = this.dialogY + this.dialogHeight - 55;
                String notice = "Only server admins can change these settings";
                int noticeWidth = this.font.width(notice);
                graphics.drawString(this.font, notice, this.dialogX + (this.dialogWidth - noticeWidth) / 2, noticeY, 0xFFCC00, false);
            }
        }
    }

    private void drawPanelOutline(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        graphics.fill(x, y, x + width, y + 1, color);
        graphics.fill(x, y + height - 1, x + width, y + height, color);
        graphics.fill(x, y, x + 1, y + height, color);
        graphics.fill(x + width - 1, y, x + width, y + height, color);
    }

    private Screen recreateScreen(Screen screen) {
        if (screen instanceof PlayerSkinMenuScreen) {
            return new PlayerSkinMenuScreen(null);
        }
        if (screen instanceof PlayerCapeMenuScreen) {
            return new PlayerCapeMenuScreen(null);
        }
        return screen;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.selectedKey != null) {
            this.selectedKey.setKey(InputConstants.Type.MOUSE.getOrCreate(button));
            KeyMapping.resetMapping();
            this.selectedKey = null;
            return true;
        }
        if (mouseX < (double)this.dialogX || mouseX > (double)(this.dialogX + this.dialogWidth) || mouseY < (double)this.dialogY || mouseY > (double)(this.dialogY + this.dialogHeight)) {
            this.onClose();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (mouseX >= (double)this.dialogX && mouseX <= (double)(this.dialogX + this.dialogWidth) && mouseY >= (double)this.dialogY && mouseY <= (double)(this.dialogY + this.dialogHeight)) {
            return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.selectedKey != null) {
            if (keyCode == 256) {
                this.selectedKey.setKey(InputConstants.UNKNOWN);
            } else {
                this.selectedKey.setKey(InputConstants.getKey((int)keyCode, (int)scanCode));
            }
            KeyMapping.resetMapping();
            this.selectedKey = null;
            return true;
        }
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBlurredBackground(float partialTick) {
    }

    public void removed() {
        super.removed();
        BlurHandler.cleanup();
        if (this.needsTextureReload) {
            PlayerAppearanceService.getInstance().reloadSkinsForTransparencyChange();
        }
    }

    public void onClose() {
        if (this.selectedKey != null) {
            KeyMapping.resetMapping();
            this.selectedKey = null;
        }
        ClientNetworkHandler.executePendingTransparencyReload();
        if (this.showOverlayCheckbox != null) {
            ClientConfig config = ClientConfig.getInstance();
            boolean oldTransparencySetting = config.disableSkinTransparency;
            boolean oldStyledButtonsSetting = config.enableStyledButtons;
            config.showSkinPreviewOverlay = this.showOverlayCheckbox.selected();
            config.disableSkinTransparency = this.disableSkinTransparencyCheckbox.selected();
            config.enableStyledButtons = this.enableStyledButtonsCheckbox.selected();
            config.enablePlayerPreviewCustomization = this.enablePlayerPreviewCustomizationCheckbox.selected();
            config.enablePlayerOwnSkinSystem = this.enablePlayerOwnSkinSystemCheckbox.selected();
            if (oldTransparencySetting != config.disableSkinTransparency) {
                this.needsTextureReload = true;
            }
            config.save();
            if (oldStyledButtonsSetting != config.enableStyledButtons && this.parent != null && this.minecraft != null) {
                Screen newParent = this.recreateScreen(this.parent);
                this.minecraft.setScreen(newParent);
                return;
            }
        }
        if (this.serverDisableSkinTransparencyCheckbox != null) {
            boolean isAdmin;
            boolean bl = isAdmin = this.minecraft != null && this.minecraft.player != null && this.minecraft.player.hasPermissions(2);
            if (isAdmin) {
                boolean oldValue;
                boolean newValue = this.serverDisableSkinTransparencyCheckbox.selected();
                ServerConfig serverOverride = ClientConfig.getInstance().getServerOverride();
                boolean bl2 = oldValue = serverOverride != null ? serverOverride.disableSkinTransparency : false;
                if (newValue != oldValue) {
                    UpdateServerConfigPayload payload = new UpdateServerConfigPayload("disableSkinTransparency", newValue);
                    NetworkManager.sendToServer((CustomPacketPayload)payload);
                }
            }
            if (isAdmin && this.skinChangeCooldownEditBox != null && !this.skinChangeCooldownEditBox.getValue().isEmpty()) {
                try {
                    int cooldownSeconds = Integer.parseInt(this.skinChangeCooldownEditBox.getValue());
                    if (cooldownSeconds >= 0 && cooldownSeconds <= 86400) {
                        ServerConfig config = ServerConfig.getInstance();
                        config.skinChangeCooldownSeconds = cooldownSeconds;
                        config.save();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }

    private static enum Tab {
        GUI_EDIT("GUI Edit"),
        CLIENT("Client"),
        SERVER("Server"),
        MODPACK("Modpack");

        private final String displayName;

        private Tab(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

