/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.quickskin.mod.client.gui.widget.DangerButton;
import com.quickskin.mod.client.gui.widget.PrimaryButton;
import com.quickskin.mod.client.gui.widget.RotateButton;
import com.quickskin.mod.client.gui.widget.StyledButton;
import com.quickskin.mod.client.gui.widget.TabButton;
import com.quickskin.mod.config.ClientConfig;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ButtonFactory {
    public static Button createStyled(int x, int y, int width, int height, Component label, Button.OnPress onPress) {
        if (ClientConfig.getInstance().enableStyledButtons) {
            return new StyledButton(x, y, width, height, label, onPress);
        }
        return Button.builder((Component)label, (Button.OnPress)onPress).bounds(x, y, width, height).build();
    }

    public static Button createPrimary(int x, int y, int width, int height, Component label, Button.OnPress onPress) {
        if (ClientConfig.getInstance().enableStyledButtons) {
            return new PrimaryButton(x, y, width, height, label, onPress);
        }
        return Button.builder((Component)label, (Button.OnPress)onPress).bounds(x, y, width, height).build();
    }

    public static Button createDanger(int x, int y, int width, int height, Component label, Button.OnPress onPress) {
        return new DangerButton(x, y, width, height, label, onPress);
    }

    public static Button createRotate(int x, int y, int size, Button.OnPress onPress) {
        if (ClientConfig.getInstance().enableStyledButtons) {
            return new RotateButton(x, y, size, onPress);
        }
        MutableComponent buttonText = Component.literal((String)"\u21ba");
        return new Button(x, y, size, size, (Component)buttonText, onPress, Supplier::get){

            public void renderString(GuiGraphics pGuiGraphics, Font pFont, int pColor) {
                Component message = this.getMessage();
                PoseStack poseStack = pGuiGraphics.pose();
                poseStack.pushPose();
                float scale = 2.8f;
                float textWidth = pFont.width((FormattedText)message);
                poseStack.translate((float)this.getX() + (float)this.getWidth() / 1.8f, (float)this.getY() + (float)this.getHeight() / 4.0f, 0.0f);
                poseStack.scale(scale, scale, 1.0f);
                int n = (int)(-textWidth / 2.0f);
                Objects.requireNonNull(pFont);
                pGuiGraphics.drawString(pFont, message, n, (int)((float)(-9) / 2.0f + 1.0f), pColor);
                poseStack.popPose();
            }
        };
    }

    public static Button createTab(int x, int y, int width, int height, Component label, boolean selected, Button.OnPress onPress) {
        return new TabButton(x, y, width, height, label, selected, onPress);
    }
}

