/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.util;

import com.quickskin.mod.QuickSkin;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;

public class DebugOffsetManager {
    private static final String CONFIG_FILE = "quickskin_debug_offsets.properties";
    private static Path configPath;
    private static final int DEFAULT_TITLE_SCREEN_OFFSET_X = -20;
    private static final int DEFAULT_TITLE_SCREEN_OFFSET_Y = -90;
    private static final int DEFAULT_WORLD_SELECTION_OFFSET_X = 0;
    private static final int DEFAULT_WORLD_SELECTION_OFFSET_Y = -82;
    private static final int DEFAULT_PAUSE_SCREEN_OFFSET_X = -23;
    private static final int DEFAULT_PAUSE_SCREEN_OFFSET_Y = -88;
    private static final int DEFAULT_SKIN_MENU_OFFSET_X = 0;
    private static final int DEFAULT_SKIN_MENU_OFFSET_Y = -18;
    private static int titleScreenOffsetX;
    private static int titleScreenOffsetY;
    private static int worldSelectionOffsetX;
    private static int worldSelectionOffsetY;
    private static int pauseScreenOffsetX;
    private static int pauseScreenOffsetY;
    private static int skinMenuOffsetX;
    private static int skinMenuOffsetY;
    private static boolean debugMode;

    public static void load() {
        if (!Files.exists(configPath, new LinkOption[0])) {
            QuickSkin.LOGGER.info("Debug offset config not found, using defaults");
            return;
        }
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(configPath, new OpenOption[0]);){
            props.load(in);
            titleScreenOffsetX = Integer.parseInt(props.getProperty("titleScreenOffsetX", String.valueOf(-20)));
            titleScreenOffsetY = Integer.parseInt(props.getProperty("titleScreenOffsetY", String.valueOf(-90)));
            worldSelectionOffsetX = Integer.parseInt(props.getProperty("worldSelectionOffsetX", String.valueOf(0)));
            worldSelectionOffsetY = Integer.parseInt(props.getProperty("worldSelectionOffsetY", String.valueOf(-82)));
            pauseScreenOffsetX = Integer.parseInt(props.getProperty("pauseScreenOffsetX", String.valueOf(-23)));
            pauseScreenOffsetY = Integer.parseInt(props.getProperty("pauseScreenOffsetY", String.valueOf(-88)));
            skinMenuOffsetX = Integer.parseInt(props.getProperty("skinMenuOffsetX", String.valueOf(0)));
            skinMenuOffsetY = Integer.parseInt(props.getProperty("skinMenuOffsetY", String.valueOf(-18)));
            debugMode = Boolean.parseBoolean(props.getProperty("debugMode", "false"));
            QuickSkin.LOGGER.info("Loaded debug offsets - Title: ({}, {}), WorldSel: ({}, {}), Pause: ({}, {}), SkinMenu: ({}, {}), Debug: {}", new Object[]{titleScreenOffsetX, titleScreenOffsetY, worldSelectionOffsetX, worldSelectionOffsetY, pauseScreenOffsetX, pauseScreenOffsetY, skinMenuOffsetX, skinMenuOffsetY, debugMode});
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to load debug offsets", (Throwable)e);
        }
    }

    public static void save() {
        Properties props = new Properties();
        props.setProperty("titleScreenOffsetX", String.valueOf(titleScreenOffsetX));
        props.setProperty("titleScreenOffsetY", String.valueOf(titleScreenOffsetY));
        props.setProperty("worldSelectionOffsetX", String.valueOf(worldSelectionOffsetX));
        props.setProperty("worldSelectionOffsetY", String.valueOf(worldSelectionOffsetY));
        props.setProperty("pauseScreenOffsetX", String.valueOf(pauseScreenOffsetX));
        props.setProperty("pauseScreenOffsetY", String.valueOf(pauseScreenOffsetY));
        props.setProperty("skinMenuOffsetX", String.valueOf(skinMenuOffsetX));
        props.setProperty("skinMenuOffsetY", String.valueOf(skinMenuOffsetY));
        props.setProperty("debugMode", String.valueOf(debugMode));
        try (OutputStream out = Files.newOutputStream(configPath, new OpenOption[0]);){
            props.store(out, "QuickSkin Debug Offsets - Hold SHIFT and drag the player model to adjust positioning");
            QuickSkin.LOGGER.info("Saved debug offsets - Title: ({}, {}), WorldSel: ({}, {}), Pause: ({}, {}), SkinMenu: ({}, {}), Debug: {}", new Object[]{titleScreenOffsetX, titleScreenOffsetY, worldSelectionOffsetX, worldSelectionOffsetY, pauseScreenOffsetX, pauseScreenOffsetY, skinMenuOffsetX, skinMenuOffsetY, debugMode});
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to save debug offsets", (Throwable)e);
        }
    }

    public static int getOffsetX(String screenType) {
        return switch (screenType) {
            case "title" -> titleScreenOffsetX;
            case "world_selection" -> worldSelectionOffsetX;
            case "pause" -> pauseScreenOffsetX;
            case "skin_menu" -> skinMenuOffsetX;
            default -> 0;
        };
    }

    public static int getOffsetY(String screenType) {
        return switch (screenType) {
            case "title" -> titleScreenOffsetY;
            case "world_selection" -> worldSelectionOffsetY;
            case "pause" -> pauseScreenOffsetY;
            case "skin_menu" -> skinMenuOffsetY;
            default -> 0;
        };
    }

    public static void setDebugMode(boolean enabled) {
        debugMode = enabled;
        DebugOffsetManager.save();
        QuickSkin.LOGGER.info("Debug mode {}", (Object)(enabled ? "ENABLED - Hold SHIFT and drag player models to reposition" : "DISABLED"));
    }

    static {
        titleScreenOffsetX = -20;
        titleScreenOffsetY = -90;
        worldSelectionOffsetX = 0;
        worldSelectionOffsetY = -82;
        pauseScreenOffsetX = -23;
        pauseScreenOffsetY = -88;
        skinMenuOffsetX = 0;
        skinMenuOffsetY = -18;
        debugMode = false;
        try {
            Path configDir = Path.of("config", new String[0]);
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            configPath = configDir.resolve(CONFIG_FILE);
            DebugOffsetManager.load();
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to initialize DebugOffsetManager", (Throwable)e);
        }
    }
}

