/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.util;

import com.quickskin.mod.QuickSkin;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

@OnlyIn(value=Dist.CLIENT)
public class FileDialogHelper {
    private static final String DIALOG_CANCELLED_MSG = "File dialog cancelled";

    public static void openSkinFileDialog(String title, Consumer<Path> onFileSelected) {
        CompletableFuture.runAsync(() -> {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer filters = stack.mallocPointer(1);
                filters.put(stack.UTF8((CharSequence)"*.png")).flip();
                String file = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)title, (CharSequence)"", (PointerBuffer)filters, (CharSequence)"PNG Images", (boolean)false);
                if (file != null && !file.isEmpty()) {
                    Path filePath = Path.of(file, new String[0]);
                    onFileSelected.accept(filePath);
                } else {
                    QuickSkin.LOGGER.debug(DIALOG_CANCELLED_MSG);
                }
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Error opening file dialog", (Throwable)e);
            }
        });
    }

    public static void openCapeFileDialog(String title, Consumer<Path> onFileSelected) {
        CompletableFuture.runAsync(() -> {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer filters = stack.mallocPointer(2);
                filters.put(stack.UTF8((CharSequence)"*.png"));
                filters.put(stack.UTF8((CharSequence)"*.gif"));
                filters.flip();
                String file = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)title, (CharSequence)"", (PointerBuffer)filters, (CharSequence)"PNG/GIF Images", (boolean)false);
                if (file != null && !file.isEmpty()) {
                    Path filePath = Path.of(file, new String[0]);
                    QuickSkin.LOGGER.info("File selected: {}", (Object)filePath);
                    onFileSelected.accept(filePath);
                } else {
                    QuickSkin.LOGGER.debug(DIALOG_CANCELLED_MSG);
                }
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Error opening file dialog", (Throwable)e);
            }
        });
    }

    public static void openMultipleFileDialog(String title, Consumer<Path[]> onFilesSelected) {
        CompletableFuture.runAsync(() -> {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer filters = stack.mallocPointer(1);
                filters.put(stack.UTF8((CharSequence)"*.png")).flip();
                String files = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)title, (CharSequence)"", (PointerBuffer)filters, (CharSequence)"PNG Images", (boolean)true);
                if (files != null && !files.isEmpty()) {
                    String[] filePaths = files.split("\\|");
                    Path[] paths = new Path[filePaths.length];
                    for (int i = 0; i < filePaths.length; ++i) {
                        paths[i] = Path.of(filePaths[i], new String[0]);
                    }
                    QuickSkin.LOGGER.info("Selected {} files", (Object)paths.length);
                    onFilesSelected.accept(paths);
                } else {
                    QuickSkin.LOGGER.debug(DIALOG_CANCELLED_MSG);
                }
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Error opening file dialog", (Throwable)e);
            }
        });
    }
}

