/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.util;

import com.quickskin.mod.QuickSkin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;

public class GuiScaleManager {
    private static Integer originalGuiScale = null;
    private static boolean scaleChanged = false;

    public static boolean setMenuGuiScale(int targetScale) {
        try {
            int currentScale;
            Minecraft mc = Minecraft.getInstance();
            OptionInstance guiScaleOption = mc.options.guiScale();
            if (originalGuiScale == null) {
                originalGuiScale = (Integer)guiScaleOption.get();
            }
            if ((currentScale = ((Integer)guiScaleOption.get()).intValue()) != targetScale) {
                guiScaleOption.set((Object)targetScale);
                scaleChanged = true;
                mc.resizeDisplay();
                return true;
            }
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to set menu GUI scale", (Throwable)e);
        }
        return false;
    }

    public static void restoreOriginalGuiScale() {
        try {
            if (originalGuiScale == null || !scaleChanged) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            OptionInstance guiScaleOption = mc.options.guiScale();
            int currentScale = (Integer)guiScaleOption.get();
            if (currentScale != originalGuiScale) {
                guiScaleOption.set((Object)originalGuiScale);
                mc.resizeDisplay();
            }
            originalGuiScale = null;
            scaleChanged = false;
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to restore original GUI scale", (Throwable)e);
        }
    }

    public static int getOptimalMenuScale() {
        return 2;
    }
}

