/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.util;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.common.data.AssetMetadata;
import com.quickskin.mod.common.util.HDTextureProcessor;
import com.quickskin.mod.common.util.HashUtil;
import com.quickskin.mod.config.ClientConfig;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinImporter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AssetMetadata importSkin(Path sourcePath) {
        if (sourcePath == null || !Files.exists(sourcePath, new LinkOption[0])) {
            QuickSkin.LOGGER.error("Source file does not exist: {}", (Object)sourcePath);
            return null;
        }
        String fileName = sourcePath.getFileName().toString();
        if (!fileName.toLowerCase().endsWith(".png")) {
            QuickSkin.LOGGER.error("File is not a PNG: {}", (Object)fileName);
            return null;
        }
        try (InputStream inputStream = Files.newInputStream(sourcePath, new OpenOption[0]);){
            boolean allowTransparency = !ClientConfig.getInstance().shouldDisableSkinTransparency();
            byte[] processedImageBytes = HDTextureProcessor.processHDSkin(inputStream, allowTransparency);
            if (processedImageBytes == null) {
                QuickSkin.LOGGER.error("Failed to process skin file: {}", (Object)fileName);
                AssetMetadata assetMetadata = null;
                return assetMetadata;
            }
            QuickSkin.LOGGER.info("Importing skin: {}", (Object)fileName);
            LocalAssetManager assetManager = LocalAssetManager.getInstance();
            Path targetPath = assetManager.getSkinsDirectory().resolve(fileName);
            int counter = 1;
            String nameWithoutExt = fileName.substring(0, fileName.lastIndexOf(46));
            while (Files.exists(targetPath, new LinkOption[0])) {
                targetPath = assetManager.getSkinsDirectory().resolve(nameWithoutExt + "_" + counter + ".png");
                ++counter;
            }
            Files.write(targetPath, processedImageBytes, new OpenOption[0]);
            QuickSkin.LOGGER.info("Saved processed skin to: {}", (Object)targetPath);
            assetManager.reload();
            String hash = HashUtil.computeFileHash(targetPath);
            if (hash == null) return null;
            AssetMetadata assetMetadata = assetManager.getMetadata(hash);
            return assetMetadata;
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to process skin file", (Throwable)e);
        }
        return null;
    }

    public static List<AssetMetadata> importSkins(Path[] sourcePaths) {
        ArrayList<AssetMetadata> imported = new ArrayList<AssetMetadata>();
        for (Path path : sourcePaths) {
            AssetMetadata metadata = SkinImporter.importSkin(path);
            if (metadata == null) continue;
            imported.add(metadata);
        }
        return imported;
    }

    private static boolean isValidSkinDimension(int width, int height) {
        int scale;
        if (width == 64 && height == 32) {
            return true;
        }
        if (width >= 64 && width <= 2048 && height >= 32 && height <= 1024 && width % 64 == 0 && ((scale = width / 64) & scale - 1) == 0) {
            return height == width || height == width / 2;
        }
        return false;
    }

    public static Path saveSkinImage(BufferedImage image, String username) {
        if (image == null || username == null) {
            QuickSkin.LOGGER.error("Invalid parameters for saveSkinImage");
            return null;
        }
        try {
            boolean disableTransparency;
            int width = image.getWidth();
            int height = image.getHeight();
            if (!SkinImporter.isValidSkinDimension(width, height)) {
                QuickSkin.LOGGER.error("Invalid skin dimensions {}x{} for {}", new Object[]{width, height, username});
                return null;
            }
            if (height == width / 2) {
                QuickSkin.LOGGER.info("Converting legacy 64x32 skin to modern format for: {}", (Object)username);
                image = HDTextureProcessor.convertLegacyToModern(image);
            }
            if (disableTransparency = ClientConfig.getInstance().shouldDisableSkinTransparency()) {
                image = HDTextureProcessor.removeTransparency(image);
            }
            String fileName = username + ".png";
            LocalAssetManager assetManager = LocalAssetManager.getInstance();
            Path targetPath = assetManager.getSkinsDirectory().resolve(fileName);
            int counter = 1;
            while (Files.exists(targetPath, new LinkOption[0])) {
                targetPath = assetManager.getSkinsDirectory().resolve(username + "_" + counter + ".png");
                ++counter;
            }
            ImageIO.write((RenderedImage)image, "PNG", targetPath.toFile());
            QuickSkin.LOGGER.info("Saved skin image to: {}", (Object)targetPath);
            return targetPath;
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to save skin image for: {}", (Object)username, (Object)e);
            return null;
        }
    }
}

