/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.widget;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ErrorToast {
    private final Minecraft mc = Minecraft.getInstance();
    private final Component message;
    private final long creationTime;
    private static final long DISPLAY_DURATION = 3000L;
    private static final int TOAST_WIDTH = 300;
    private static final int TOAST_HEIGHT = 40;
    private static final int TOAST_PADDING = 10;

    public ErrorToast(Component message) {
        this.message = message;
        this.creationTime = System.currentTimeMillis();
    }

    public boolean render(GuiGraphics guiGraphics, int screenWidth) {
        long elapsed = System.currentTimeMillis() - this.creationTime;
        if (elapsed > 3000L) {
            return false;
        }
        float alpha = 1.0f;
        if (elapsed < 300L) {
            alpha = (float)elapsed / 300.0f;
        } else if (elapsed > 2500L) {
            alpha = (float)(3000L - elapsed) / 500.0f;
        }
        alpha = Math.max(0.0f, Math.min(1.0f, alpha));
        int x = (screenWidth - 300) / 2;
        int y = 20;
        int bgColor = (int)(alpha * 255.0f) << 24 | 0xCC0000;
        guiGraphics.fill(x, y, x + 300, y + 40, bgColor);
        int borderColor = (int)(alpha * 255.0f) << 24 | 0xFF0000;
        guiGraphics.fill(x, y, x + 300, y + 1, borderColor);
        guiGraphics.fill(x, y + 40 - 1, x + 300, y + 40, borderColor);
        guiGraphics.fill(x, y, x + 1, y + 40, borderColor);
        guiGraphics.fill(x + 300 - 1, y, x + 300, y + 40, borderColor);
        int textColor = (int)(alpha * 255.0f) << 24 | 0xFFFFFF;
        int messageX = x + 10;
        Objects.requireNonNull(this.mc.font);
        int messageY = y + 20 - 9 / 2;
        Object text = this.message.getString();
        int maxTextWidth = 280;
        if (this.mc.font.width((String)text) > maxTextWidth) {
            text = this.mc.font.plainSubstrByWidth((String)text, maxTextWidth - this.mc.font.width("...")) + "...";
        }
        guiGraphics.drawString(this.mc.font, (String)text, messageX, messageY, textColor, false);
        return true;
    }
}

