/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.platform.PlatformHelper;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class LinkButton
extends Button {
    private final ResourceLocation texture;
    private final int textureWidth;
    private final int textureHeight;

    public LinkButton(int x, int y, int width, int height, ResourceLocation texture, String url, Component tooltip) {
        super(x, y, width, height, (Component)Component.empty(), button -> {
            if (url != null) {
                LinkButton.openLink(url);
            }
        }, DEFAULT_NARRATION);
        this.texture = texture;
        this.textureWidth = 256;
        this.textureHeight = 256;
        this.setTooltip(Tooltip.create((Component)tooltip));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        int padding = 2;
        PlatformHelper.blit(graphics, this.texture, this.getX() + padding, this.getY() + padding, this.width - padding * 2, this.height - padding * 2, 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.textureWidth, this.textureHeight);
    }

    private static void openLink(String url) {
        Util.getPlatform().openUri(url);
        QuickSkin.LOGGER.info("Opening link: {}", (Object)url);
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }
}

