/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RotateButton
extends Button {
    public RotateButton(int x, int y, int size, Button.OnPress onPress) {
        super(x, y, size, size, (Component)Component.literal((String)"\u21ba"), onPress, DEFAULT_NARRATION);
    }

    public void renderString(GuiGraphics pGuiGraphics, Font pFont, int pColor) {
        Component message = this.getMessage();
        PoseStack poseStack = pGuiGraphics.pose();
        poseStack.pushPose();
        float scale = 2.8f;
        float textWidth = pFont.width((FormattedText)message);
        poseStack.translate((float)this.getX() + (float)this.getWidth() / 1.8f, (float)this.getY() + (float)this.getHeight() / 4.0f, 0.0f);
        poseStack.scale(scale, scale, 1.0f);
        int n = (int)(-textWidth / 2.0f);
        Objects.requireNonNull(pFont);
        pGuiGraphics.drawString(pFont, message, n, (int)((float)(-9) / 2.0f + 1.0f), pColor);
        poseStack.popPose();
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }
}

