/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.widget;

import com.quickskin.mod.client.gui.screen.PlayerSkinMenuScreen;
import com.quickskin.mod.client.gui.widget.SkinEntry;
import com.quickskin.mod.common.data.AssetMetadata;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinListWidget
extends ContainerObjectSelectionList<SkinEntry> {
    private final PlayerSkinMenuScreen parentScreen;
    private final Minecraft mc;
    private int xPosition;
    private final int itemHeight;

    public SkinListWidget(PlayerSkinMenuScreen parentScreen, Minecraft mc, int width, int height, int y, int x, int entryHeight) {
        super(mc, width, height, y, entryHeight);
        this.parentScreen = parentScreen;
        this.mc = mc;
        this.xPosition = x;
        this.itemHeight = entryHeight;
        this.setX(x);
    }

    public void addSkinEntry(AssetMetadata metadata) {
        this.addEntry((AbstractSelectionList.Entry)new SkinEntry(this, metadata));
    }

    public void clearSkinEntries() {
        this.clearEntries();
    }

    public void makeVisible(SkinEntry entry) {
        this.ensureVisible((AbstractSelectionList.Entry)entry);
    }

    public void onSkinSelected(SkinEntry entry) {
        this.parentScreen.onSkinSelected(entry);
    }

    public int getRowWidth() {
        return this.width - 8;
    }

    protected int getScrollbarPosition() {
        return this.getRight() - 6;
    }

    public int getX() {
        return this.xPosition;
    }

    public int getRowLeft() {
        return this.xPosition + 4;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        if (this.getItemCount() <= 2) {
            int rowTop = this.getItemCount() > 0 ? this.getRowTop(this.getItemCount()) : this.getY();
            int areaTop = Math.max(rowTop, this.getY());
            int areaBottom = this.getBottom();
            if (areaBottom - areaTop > 60) {
                int areaLeft = this.getRowLeft();
                int areaWidth = this.getRowWidth();
                int centerX = areaLeft + areaWidth / 2;
                int centerY = areaTop + (areaBottom - areaTop) / 2;
                int zoneWidth = Math.min(areaWidth - 40, 300);
                int zoneHeight = Math.min(areaBottom - areaTop - 40, 140);
                int zoneX = centerX - zoneWidth / 2;
                int zoneY = centerY - zoneHeight / 2;
                boolean isHovering = mouseX >= zoneX && mouseX <= zoneX + zoneWidth && mouseY >= zoneY && mouseY <= zoneY + zoneHeight;
                int bgColor = isHovering ? 0x1AFFFFFF : 0xFFFFFFF;
                graphics.fill(zoneX, zoneY, zoneX + zoneWidth, zoneY + zoneHeight, bgColor);
                this.drawDashedBorder(graphics, zoneX, zoneY, zoneWidth, zoneHeight, isHovering);
                MutableComponent mainMessage = Component.literal((String)"Drop skin files here");
                MutableComponent subMessage = Component.literal((String)"or click 'Import Skin'");
                int mainColor = isHovering ? 0xFFFFFF : 0xE0E0E0;
                int subColor = isHovering ? 0xB0B0B0 : 0x909090;
                Font font = this.mc.font;
                Objects.requireNonNull(this.mc.font);
                graphics.drawCenteredString(font, (Component)mainMessage, centerX, centerY - 9 - 2, mainColor);
                graphics.drawCenteredString(this.mc.font, (Component)subMessage, centerX, centerY + 2, subColor);
            }
        }
    }

    private void drawDashedBorder(GuiGraphics graphics, int x, int y, int width, int height, boolean highlight) {
        int segmentLength;
        int i;
        int color = highlight ? -1 : -2130706433;
        int dashLength = 8;
        int gapLength = 4;
        int totalLength = dashLength + gapLength;
        for (i = 0; i < width; i += totalLength) {
            segmentLength = Math.min(dashLength, width - i);
            graphics.fill(x + i, y, x + i + segmentLength, y + 1, color);
        }
        for (i = 0; i < width; i += totalLength) {
            segmentLength = Math.min(dashLength, width - i);
            graphics.fill(x + i, y + height - 1, x + i + segmentLength, y + height, color);
        }
        for (i = 0; i < height; i += totalLength) {
            segmentLength = Math.min(dashLength, height - i);
            graphics.fill(x, y + i, x + 1, y + i + segmentLength, color);
        }
        for (i = 0; i < height; i += totalLength) {
            segmentLength = Math.min(dashLength, height - i);
            graphics.fill(x + width - 1, y + i, x + width, y + i + segmentLength, color);
        }
    }

    public void requestDeletion(SkinEntry entry) {
        this.parentScreen.showDeleteConfirmation(entry.getMetadata());
    }

    public void requestRename(SkinEntry entry) {
        this.parentScreen.showRenameDialog(entry.getMetadata());
    }
}

