/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.gui.widget;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StyledButton
extends Button {
    private static final int NORMAL_BG = -1342177280;
    private static final int HOVER_BG = -1071636448;
    private static final int OUTLINE = -2130706433;
    private static final int TEXT_COLOR = 0xFFFFFF;

    public StyledButton(int x, int y, int width, int height, Component label, Button.OnPress onPress) {
        super(x, y, width, height, label, onPress, DEFAULT_NARRATION);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int bgColor;
        int n = bgColor = this.isHovered() && this.active ? -1071636448 : -1342177280;
        if (!this.active) {
            bgColor = Integer.MIN_VALUE;
        }
        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, bgColor);
        int outlineColor = this.active ? -2130706433 : 0x40FFFFFF;
        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + 1, outlineColor);
        graphics.fill(this.getX(), this.getY() + this.height - 1, this.getX() + this.width, this.getY() + this.height, outlineColor);
        graphics.fill(this.getX(), this.getY(), this.getX() + 1, this.getY() + this.height, outlineColor);
        graphics.fill(this.getX() + this.width - 1, this.getY(), this.getX() + this.width, this.getY() + this.height, outlineColor);
        int textColor = this.active ? 0xFFFFFF : 0x666666;
        graphics.drawCenteredString(Minecraft.getInstance().font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, textColor);
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }
}

