/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.rendering;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.rendering.PreviewPlayerData;
import com.quickskin.mod.client.rendering.SkinLayers3DIntegration;
import com.quickskin.mod.client.services.AnimatedTextureManager;
import com.quickskin.mod.platform.PlatformHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class PlayerModelRenderer {
    private static PlayerModel<?> classicModel;
    private static PlayerModel<?> slimModel;
    private static Player cachedPlayer;
    private static float prevHeadRotZ;
    private static float prevRightArmRotX;
    private static float prevRightArmRotZ;
    private static float prevLeftArmRotX;
    private static float prevLeftArmRotZ;
    private static float prevRightLegRotX;
    private static float prevLeftLegRotX;
    private static float prevBodyRotX;
    public static double debugOffsetX;
    public static double debugOffsetY;
    public static boolean debugPositioningMode;
    private static boolean isDraggingModel;
    private static int dragStartX;
    private static int dragStartY;
    private static double dragStartOffsetX;
    private static double dragStartOffsetY;
    private static long lastAnimationUpdate;
    private static final long ANIMATION_UPDATE_INTERVAL_MS = 33L;

    private static void ensureModelsLoaded() {
        if (classicModel == null) {
            QuickSkin.LOGGER.info("[PlayerModelRenderer] Initializing player models...");
            Minecraft mc = Minecraft.getInstance();
            ModelPart classicRoot = mc.getEntityModels().bakeLayer(ModelLayers.PLAYER);
            classicModel = new PlayerModel(classicRoot, false);
            ModelPart slimRoot = mc.getEntityModels().bakeLayer(ModelLayers.PLAYER_SLIM);
            slimModel = new PlayerModel(slimRoot, true);
            QuickSkin.LOGGER.info("[PlayerModelRenderer] Models initialized successfully");
        }
    }

    public static void renderPlayerModel(GuiGraphics graphics, int x, int y, float scale, float yRotation, PreviewPlayerData playerData, int mouseX, int mouseY, boolean followMouse) {
        Player playerToRender;
        if (playerData.getSkinLocation() == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            cachedPlayer = mc.player;
        }
        if ((playerToRender = cachedPlayer) == null) {
            PlayerModelRenderer.renderPlayerModelManual(graphics, x, y, scale, yRotation, playerData, mouseX, mouseY, followMouse);
            return;
        }
        float originalYRot = playerToRender.getYRot();
        float originalXRot = playerToRender.getXRot();
        float originalYHeadRot = playerToRender.yHeadRot;
        float originalYBodyRot = playerToRender.yBodyRot;
        float targetRotation = 180.0f + yRotation;
        playerToRender.setYRot(targetRotation);
        playerToRender.setXRot(0.0f);
        playerToRender.yHeadRot = targetRotation + playerData.getHeadYaw();
        playerToRender.yBodyRot = targetRotation;
        if (mc.level == null) {
            playerToRender.tickCount = mc.gui.getGuiTicks();
        }
        Quaternionf quaternionXZ = new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)Math.PI);
        Quaternionf quaternionY = new Quaternionf();
        try {
            if ("sit".equalsIgnoreCase(playerData.getCurrentAnimation()) && mc.level == null) {
                PoseStack poseStack = graphics.pose();
                MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
                poseStack.pushPose();
                poseStack.translate((double)x, (double)y, 50.0);
                float scaleCasted = (int)scale;
                Matrix4f scaleMatrix = new Matrix4f().scaling(scaleCasted, scaleCasted, -scaleCasted);
                poseStack.mulPose(scaleMatrix);
                poseStack.mulPose(quaternionXZ);
                poseStack.mulPose(Axis.YP.rotationDegrees(-targetRotation));
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                poseStack.translate(0.0f, -1.501f, 0.0f);
                PlayerModelRenderer.renderGrassBlock(poseStack, bufferSource);
                bufferSource.endBatch();
                poseStack.popPose();
            }
            InventoryScreen.renderEntityInInventory((GuiGraphics)graphics, (float)x, (float)y, (float)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)quaternionXZ, (Quaternionf)quaternionY, (LivingEntity)playerToRender);
        }
        catch (Exception e) {
            PlayerModelRenderer.renderPlayerModelManual(graphics, x, y, scale, yRotation, playerData, mouseX, mouseY, followMouse);
        }
        playerToRender.setYRot(originalYRot);
        playerToRender.setXRot(originalXRot);
        playerToRender.yHeadRot = originalYHeadRot;
        playerToRender.yBodyRot = originalYBodyRot;
    }

    private static void renderPlayerModelManual(GuiGraphics graphics, int x, int y, float scale, float yRotation, PreviewPlayerData playerData, int mouseX, int mouseY, boolean followMouse) {
        PlayerModelRenderer.ensureModelsLoaded();
        PlayerModel<?> model = playerData.getModelType().equalsIgnoreCase("slim") ? slimModel : classicModel;
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)x, (double)y, 50.0);
        float scaleCasted = (int)scale;
        Matrix4f scaleMatrix = new Matrix4f().scaling(scaleCasted, scaleCasted, -scaleCasted);
        poseStack.mulPose(scaleMatrix);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        poseStack.mulPose(quaternionf);
        poseStack.mulPose(Axis.YP.rotationDegrees(-yRotation));
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(0.0f, -1.501f, 0.0f);
        Lighting.setupForEntityInInventory();
        Minecraft mc = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        if ("sit".equalsIgnoreCase(playerData.getCurrentAnimation()) && mc.level == null) {
            PlayerModelRenderer.renderGrassBlock(poseStack, bufferSource);
        }
        PlayerModelRenderer.setupModelPoseWithAnimation(model, playerData, mouseX, mouseY, followMouse, x, y, mc);
        RenderType renderType = RenderType.entityTranslucent((ResourceLocation)playerData.getSkinLocation());
        VertexConsumer vertexConsumer = bufferSource.getBuffer(renderType);
        boolean isSlimModel = playerData.getModelType().equalsIgnoreCase("slim");
        model.renderToBuffer(poseStack, vertexConsumer, 0xF000F0, OverlayTexture.NO_OVERLAY, -1);
        SkinLayers3DIntegration.render3DLayers(poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, model, playerData.getSkinLocation(), isSlimModel);
        if (playerData.getCapeLocation() != null) {
            ResourceLocation currentFrame;
            ResourceLocation capeAtlasLocation = playerData.getCapeLocation();
            String capeId = playerData.getCapeId();
            ResourceLocation finalCapeTexture = capeAtlasLocation;
            String animationId = null;
            if (capeId != null) {
                if (capeId.startsWith("local_cape:")) {
                    animationId = "cape_" + capeId.substring("local_cape:".length());
                } else if (capeId.startsWith("known:")) {
                    animationId = "cape_known_" + capeId.substring("known:".length());
                }
            }
            if (animationId != null && (currentFrame = AnimatedTextureManager.getInstance().getCurrentFrameTexture(animationId)) != null) {
                finalCapeTexture = currentFrame;
            }
            RenderType capeRenderType = RenderType.entityTranslucent((ResourceLocation)finalCapeTexture);
            VertexConsumer capeVertexConsumer = bufferSource.getBuffer(capeRenderType);
            poseStack.pushPose();
            model.body.translateAndRotate(poseStack);
            poseStack.translate(0.0, 0.0, 0.125);
            poseStack.mulPose(Axis.XP.rotationDegrees(6.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            PlatformHelper.renderCloak(model, poseStack, capeVertexConsumer, 0xF000F0, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
        bufferSource.endBatch();
        poseStack.popPose();
        Lighting.setupFor3DItems();
    }

    @Deprecated
    public static void renderPlayerModel(PoseStack poseStack, MultiBufferSource buffer, int x, int y, float scale, float yRotation, PreviewPlayerData playerData, int mouseX, int mouseY, boolean followMouse) {
        Minecraft mc = Minecraft.getInstance();
        GuiGraphics graphics = new GuiGraphics(mc, buffer instanceof MultiBufferSource.BufferSource ? (MultiBufferSource.BufferSource)buffer : mc.renderBuffers().bufferSource());
        PlayerModelRenderer.renderPlayerModel(graphics, x, y, scale, yRotation, playerData, mouseX, mouseY, followMouse);
    }

    private static float smoothLerp(float current, float target, float factor) {
        return current + (target - current) * factor;
    }

    private static void renderCapeLayer(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, ResourceLocation capeTexture, PlayerModel<?> model) {
        poseStack.pushPose();
        model.body.translateAndRotate(poseStack);
        poseStack.translate(0.0, 0.0, 0.125);
        float capeWidth = 0.625f;
        float capeHeight = 1.0f;
        float xOffset = -capeWidth / 2.0f;
        RenderType capeRenderType = RenderType.entitySolid((ResourceLocation)capeTexture);
        VertexConsumer capeConsumer = bufferSource.getBuffer(capeRenderType);
        PoseStack.Pose pose = poseStack.last();
        Matrix4f matrix = pose.pose();
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 0.15625f;
        float v1 = 0.5f;
        capeConsumer.addVertex(matrix, xOffset, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(u0, v0).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
        capeConsumer.addVertex(matrix, xOffset, capeHeight, 0.0f).setColor(255, 255, 255, 255).setUv(u0, v1).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
        capeConsumer.addVertex(matrix, xOffset + capeWidth, capeHeight, 0.0f).setColor(255, 255, 255, 255).setUv(u1, v1).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
        capeConsumer.addVertex(matrix, xOffset + capeWidth, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(u1, v0).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
        poseStack.popPose();
    }

    private static void renderCapeManualOLD(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, ResourceLocation capeLocation, float yRotation) {
        poseStack.pushPose();
        RenderType debugRenderType = RenderType.gui();
        VertexConsumer debugConsumer = bufferSource.getBuffer(debugRenderType);
        PoseStack.Pose debugPose = poseStack.last();
        Matrix4f debugMatrix = debugPose.pose();
        poseStack.translate(0.0, 0.0, -0.125);
        float capeWidth = 0.625f;
        float capeHeight = 1.0f;
        float xOffset = -capeWidth / 2.0f;
        float capeSwing = (float)Math.sin((double)System.currentTimeMillis() / 1000.0) * 0.1f;
        poseStack.mulPose(Axis.XP.rotationDegrees(capeSwing * 10.0f));
        RenderType renderType = RenderType.entityTranslucentCull((ResourceLocation)capeLocation);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(renderType);
        PoseStack.Pose pose = poseStack.last();
        Matrix4f positionMatrix = pose.pose();
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 0.15625f;
        float v1 = 0.5f;
        vertexConsumer.addVertex(positionMatrix, xOffset, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(u0, v0).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(positionMatrix, xOffset, capeHeight, 0.0f).setColor(255, 255, 255, 255).setUv(u0, v1).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(positionMatrix, xOffset + capeWidth, capeHeight, 0.0f).setColor(255, 255, 255, 255).setUv(u1, v1).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(positionMatrix, xOffset + capeWidth, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(u1, v0).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
        poseStack.popPose();
    }

    private static void setupModelPoseWithAnimation(PlayerModel<?> model, PreviewPlayerData playerData, int mouseX, int mouseY, boolean followMouse, int modelCenterX, int modelCenterY, Minecraft mc) {
        long now;
        boolean shouldUpdate;
        String animation = playerData.getCurrentAnimation();
        if (animation == null || animation.isEmpty()) {
            animation = "idle";
        }
        boolean bl = shouldUpdate = (now = System.currentTimeMillis()) - lastAnimationUpdate >= 33L;
        if (!shouldUpdate) {
            model.hat.copyFrom(model.head);
            model.leftSleeve.copyFrom(model.leftArm);
            model.rightSleeve.copyFrom(model.rightArm);
            model.leftPants.copyFrom(model.leftLeg);
            model.rightPants.copyFrom(model.rightLeg);
            model.jacket.copyFrom(model.body);
            return;
        }
        lastAnimationUpdate = now;
        int tickCount = mc != null ? mc.gui.getGuiTicks() : 0;
        float elapsedTime = (float)tickCount / 20.0f;
        float t = elapsedTime * 0.8f;
        float lerpFactor = 0.15f;
        switch (animation.toLowerCase()) {
            case "walk": {
                PlayerModelRenderer.setupWalkingPose(model, t, lerpFactor);
                break;
            }
            case "sit": {
                PlayerModelRenderer.setupSittingPose(model, t, lerpFactor);
                break;
            }
            default: {
                PlayerModelRenderer.setupIdlePose(model, t, lerpFactor);
            }
        }
        model.hat.copyFrom(model.head);
        model.leftSleeve.copyFrom(model.leftArm);
        model.rightSleeve.copyFrom(model.rightArm);
        model.leftPants.copyFrom(model.leftLeg);
        model.rightPants.copyFrom(model.rightLeg);
        model.jacket.copyFrom(model.body);
    }

    private static void setupIdlePose(PlayerModel<?> model, float t, float lerpFactor) {
        PlatformHelper.setYoung(model, false);
        PlatformHelper.setCrouching(model, false);
        PlatformHelper.setRiding(model, false);
        PlatformHelper.setAttackTime(model, 0.0f);
        float targetHeadRotZ = (float)Math.sin((double)t * 1.2) * 0.04f;
        prevHeadRotZ = PlayerModelRenderer.smoothLerp(prevHeadRotZ, targetHeadRotZ, lerpFactor);
        model.head.xRot = 0.0f;
        model.head.yRot = 0.0f;
        model.head.zRot = prevHeadRotZ;
        float targetBodyBounce = (float)Math.abs(Math.sin((double)t * 0.8)) * 0.12f;
        prevBodyRotX = PlayerModelRenderer.smoothLerp(prevBodyRotX, targetBodyBounce * 0.2f, lerpFactor);
        model.body.xRot = -prevBodyRotX;
        model.body.yRot = 0.0f;
        model.body.zRot = 0.0f;
        float targetRightArmRotX = (float)Math.sin((double)t * 0.8) * 0.12f;
        float targetRightArmRotZ = (float)Math.sin(t) * 0.04f;
        prevRightArmRotX = PlayerModelRenderer.smoothLerp(prevRightArmRotX, targetRightArmRotX, lerpFactor);
        prevRightArmRotZ = PlayerModelRenderer.smoothLerp(prevRightArmRotZ, targetRightArmRotZ, lerpFactor);
        model.rightArm.xRot = prevRightArmRotX;
        model.rightArm.yRot = 0.0f;
        model.rightArm.zRot = prevRightArmRotZ;
        float targetLeftArmRotX = (float)Math.sin((double)t * 0.8 + Math.PI) * 0.12f;
        float targetLeftArmRotZ = (float)Math.sin((double)t + Math.PI) * -0.04f;
        prevLeftArmRotX = PlayerModelRenderer.smoothLerp(prevLeftArmRotX, targetLeftArmRotX, lerpFactor);
        prevLeftArmRotZ = PlayerModelRenderer.smoothLerp(prevLeftArmRotZ, targetLeftArmRotZ, lerpFactor);
        model.leftArm.xRot = prevLeftArmRotX;
        model.leftArm.yRot = 0.0f;
        model.leftArm.zRot = prevLeftArmRotZ;
        float targetRightLegRotX = (float)Math.sin((double)t * 0.5) * 0.05f;
        model.rightLeg.xRot = prevRightLegRotX = PlayerModelRenderer.smoothLerp(prevRightLegRotX, targetRightLegRotX, lerpFactor);
        model.rightLeg.yRot = 0.0f;
        model.rightLeg.zRot = 0.0f;
        float targetLeftLegRotX = (float)Math.sin((double)t * 0.5 + Math.PI) * 0.05f;
        model.leftLeg.xRot = prevLeftLegRotX = PlayerModelRenderer.smoothLerp(prevLeftLegRotX, targetLeftLegRotX, lerpFactor);
        model.leftLeg.yRot = 0.0f;
        model.leftLeg.zRot = 0.0f;
    }

    private static void setupWalkingPose(PlayerModel<?> model, float t, float lerpFactor) {
        PlatformHelper.setYoung(model, false);
        PlatformHelper.setCrouching(model, false);
        PlatformHelper.setRiding(model, false);
        PlatformHelper.setAttackTime(model, 0.0f);
        float limbSwing = (float)Math.sin((double)t * 8.0) * 0.6f;
        float headBobY = (float)Math.abs(Math.sin((double)t * 8.0)) * 0.05f;
        float headTiltZ = (float)Math.sin((double)t * 8.0) * 0.03f;
        model.head.xRot = -headBobY;
        model.head.yRot = 0.0f;
        model.head.zRot = headTiltZ;
        float bodySway = (float)Math.sin((double)t * 8.0) * 0.04f;
        float bodyBob = (float)Math.abs(Math.sin((double)t * 8.0)) * 0.02f;
        model.body.xRot = 0.05f + bodyBob;
        model.body.yRot = bodySway;
        model.body.zRot = bodySway * 0.5f;
        float armSwingOut = (float)Math.abs(Math.sin((double)t * 8.0)) * 0.05f;
        model.rightArm.xRot = -limbSwing;
        model.rightArm.yRot = 0.0f;
        model.rightArm.zRot = armSwingOut;
        model.leftArm.xRot = limbSwing;
        model.leftArm.yRot = 0.0f;
        model.leftArm.zRot = -armSwingOut;
        model.rightLeg.xRot = limbSwing;
        model.rightLeg.yRot = 0.0f;
        model.rightLeg.zRot = 0.0f;
        model.leftLeg.xRot = -limbSwing;
        model.leftLeg.yRot = 0.0f;
        model.leftLeg.zRot = 0.0f;
    }

    private static void setupSittingPose(PlayerModel<?> model, float t, float lerpFactor) {
        float breathe;
        PlatformHelper.setYoung(model, false);
        PlatformHelper.setCrouching(model, false);
        PlatformHelper.setRiding(model, true);
        PlatformHelper.setAttackTime(model, 0.0f);
        float headBob = (float)Math.sin((double)t * 0.6) * 0.02f;
        float headTilt = (float)Math.sin((double)t * 0.4) * 0.03f;
        model.head.xRot = headBob;
        model.head.yRot = 0.0f;
        model.head.zRot = headTilt;
        model.body.xRot = breathe = (float)Math.sin((double)t * 0.5) * 0.01f;
        model.body.yRot = 0.0f;
        model.body.zRot = 0.0f;
        float armSway = (float)Math.sin((double)t * 0.7) * 0.02f;
        model.rightArm.xRot = -0.62f + armSway;
        model.rightArm.yRot = 0.0f;
        model.rightArm.zRot = 0.0f;
        model.leftArm.xRot = -0.62f - armSway;
        model.leftArm.yRot = 0.0f;
        model.leftArm.zRot = 0.0f;
        float legFidget = (float)Math.sin((double)t * 0.3) * 0.01f;
        model.rightLeg.xRot = -1.4f + legFidget;
        model.rightLeg.yRot = 0.31f;
        model.rightLeg.zRot = 0.05f;
        model.leftLeg.xRot = -1.4f - legFidget;
        model.leftLeg.yRot = -0.31f;
        model.leftLeg.zRot = -0.05f;
    }

    private static void renderGrassBlock(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource) {
        poseStack.pushPose();
        double offsetX = -0.333;
        double offsetY = 1.4;
        double offsetZ = 0.222;
        double scale = 0.575;
        poseStack.translate(offsetX, offsetY, offsetZ);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.scale((float)scale, (float)scale, (float)scale);
        Minecraft mc = Minecraft.getInstance();
        BlockRenderDispatcher blockRenderer = mc.getBlockRenderer();
        blockRenderer.renderSingleBlock(Blocks.GRASS_BLOCK.defaultBlockState(), poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    private static void renderCubeFace(Matrix4f matrix, PoseStack.Pose pose, MultiBufferSource.BufferSource bufferSource, ResourceLocation texture, float x1, float y1, float z1, float x2, float y2, float z2, float nx, float ny, float nz) {
        RenderType renderType = RenderType.entityCutout((ResourceLocation)texture);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(renderType);
        float minX = Math.min(x1, x2);
        float maxX = Math.max(x1, x2);
        float minY = Math.min(y1, y2);
        float maxY = Math.max(y1, y2);
        float minZ = Math.min(z1, z2);
        float maxZ = Math.max(z1, z2);
        if (ny != 0.0f) {
            float y = y1;
            vertexConsumer.addVertex(matrix, minX, y, minZ).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(nx, ny, nz);
            vertexConsumer.addVertex(matrix, minX, y, maxZ).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(nx, ny, nz);
            vertexConsumer.addVertex(matrix, maxX, y, maxZ).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(nx, ny, nz);
            vertexConsumer.addVertex(matrix, maxX, y, minZ).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(nx, ny, nz);
        } else if (nx != 0.0f) {
            float x = x1;
            vertexConsumer.addVertex(matrix, x, minY, minZ).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(nx, ny, nz);
            vertexConsumer.addVertex(matrix, x, maxY, minZ).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(nx, ny, nz);
            vertexConsumer.addVertex(matrix, x, maxY, maxZ).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(nx, ny, nz);
            vertexConsumer.addVertex(matrix, x, minY, maxZ).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(nx, ny, nz);
        } else {
            float z = z1;
            vertexConsumer.addVertex(matrix, minX, minY, z).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(nx, ny, nz);
            vertexConsumer.addVertex(matrix, minX, maxY, z).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(nx, ny, nz);
            vertexConsumer.addVertex(matrix, maxX, maxY, z).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(nx, ny, nz);
            vertexConsumer.addVertex(matrix, maxX, minY, z).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(nx, ny, nz);
        }
    }

    private static void renderDebugCube(PoseStack poseStack, MultiBufferSource buffer, PlayerModel<?> model) {
        poseStack.pushPose();
        ModelPart body = model.body;
        poseStack.translate(0.0, -0.7, 0.0);
        poseStack.scale(0.2f, 0.2f, 0.2f);
        RenderType renderType = RenderType.lines();
        VertexConsumer vertexConsumer = buffer.getBuffer(renderType);
        float size = 1.0f;
        Matrix4f matrix = poseStack.last().pose();
        PlayerModelRenderer.addLine(vertexConsumer, matrix, -size, -size, -size, size, -size, -size, 0, 255, 255);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, size, -size, -size, size, -size, size, 0, 255, 255);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, size, -size, size, -size, -size, size, 0, 255, 255);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, -size, -size, size, -size, -size, -size, 0, 255, 255);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, -size, size, -size, size, size, -size, 255, 0, 255);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, size, size, -size, size, size, size, 255, 0, 255);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, size, size, size, -size, size, size, 255, 0, 255);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, -size, size, size, -size, size, -size, 255, 0, 255);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, -size, -size, -size, -size, size, -size, 255, 255, 0);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, size, -size, -size, size, size, -size, 255, 255, 0);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, size, -size, size, size, size, size, 255, 255, 0);
        PlayerModelRenderer.addLine(vertexConsumer, matrix, -size, -size, size, -size, size, size, 255, 255, 0);
        poseStack.popPose();
    }

    private static void addLine(VertexConsumer consumer, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, int r, int g, int b) {
    }

    private static void setupLighting(float yRotation) {
        float normalizedRotation = yRotation % 360.0f;
        if (normalizedRotation < 0.0f) {
            normalizedRotation += 360.0f;
        }
        float brightness = normalizedRotation < 90.0f ? 1.425f - normalizedRotation / 90.0f * 0.225f : (normalizedRotation < 180.0f ? 1.2f + (normalizedRotation - 90.0f) / 90.0f * 0.1f : (normalizedRotation < 270.0f ? 1.3f - (normalizedRotation - 180.0f) / 90.0f * 0.1f : 1.2f + (normalizedRotation - 270.0f) / 90.0f * 0.225f));
        Vector3f lightDirection = new Vector3f(0.2f, 1.0f, -0.7f).normalize();
        RenderSystem.setShaderLights((Vector3f)new Vector3f((Vector3fc)lightDirection).mul(brightness), (Vector3f)new Vector3f((Vector3fc)lightDirection).mul(brightness * 0.5f));
    }

    public static void renderDefaultPlayer(PoseStack poseStack, MultiBufferSource buffer, int x, int y, float scale, float yRotation) {
        PreviewPlayerData defaultData = new PreviewPlayerData();
        defaultData.setSkinLocation(ResourceLocation.withDefaultNamespace((String)"textures/entity/steve.png"));
        defaultData.setModelType("classic");
        PlayerModelRenderer.renderPlayerModel(poseStack, buffer, x, y, scale, yRotation, defaultData, 0, 0, false);
    }

    public static void clearCachedPlayer() {
        cachedPlayer = null;
        QuickSkin.LOGGER.info("[PlayerModelRenderer] Cached player cleared");
    }

    public static boolean handleDebugMousePressed(int mouseX, int mouseY, int button) {
        if (!debugPositioningMode || button != 0) {
            return false;
        }
        isDraggingModel = true;
        dragStartX = mouseX;
        dragStartY = mouseY;
        dragStartOffsetX = debugOffsetX;
        dragStartOffsetY = debugOffsetY;
        return true;
    }

    public static boolean handleDebugMouseDragged(int mouseX, int mouseY, int button) {
        if (!debugPositioningMode || !isDraggingModel || button != 0) {
            return false;
        }
        int deltaX = mouseX - dragStartX;
        int deltaY = mouseY - dragStartY;
        debugOffsetX = dragStartOffsetX + (double)deltaX;
        debugOffsetY = dragStartOffsetY + (double)deltaY;
        return true;
    }

    public static boolean handleDebugMouseReleased(int mouseX, int mouseY, int button) {
        if (!debugPositioningMode || !isDraggingModel || button != 0) {
            return false;
        }
        isDraggingModel = false;
        QuickSkin.LOGGER.info("========================================");
        QuickSkin.LOGGER.info("[Debug Positioning] Model positioned!");
        QuickSkin.LOGGER.info("[Debug Positioning] Set these values in PlayerModelRenderer:");
        QuickSkin.LOGGER.info("[Debug Positioning]   debugOffsetX = {};", (Object)debugOffsetX);
        QuickSkin.LOGGER.info("[Debug Positioning]   debugOffsetY = {};", (Object)debugOffsetY);
        QuickSkin.LOGGER.info("========================================");
        return true;
    }

    static {
        prevHeadRotZ = 0.0f;
        prevRightArmRotX = 0.0f;
        prevRightArmRotZ = 0.0f;
        prevLeftArmRotX = 0.0f;
        prevLeftArmRotZ = 0.0f;
        prevRightLegRotX = 0.0f;
        prevLeftLegRotX = 0.0f;
        prevBodyRotX = 0.0f;
        debugOffsetX = 2.0;
        debugOffsetY = -129.0;
        debugPositioningMode = false;
        isDraggingModel = false;
        dragStartX = 0;
        dragStartY = 0;
        dragStartOffsetX = 0.0;
        dragStartOffsetY = 0.0;
        lastAnimationUpdate = 0L;
    }
}

