/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.rendering;

import com.quickskin.mod.client.rendering.SkinLayers3DIntegration;
import com.quickskin.mod.common.data.SkinResolution;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PreviewPlayerData {
    private ResourceLocation skinLocation;
    private ResourceLocation capeLocation;
    private String modelType = "classic";
    private String capeId;
    private SkinResolution resolution = SkinResolution.STANDARD;
    private float yRotation = 0.0f;
    private float headYaw = 0.0f;
    private float headPitch = 0.0f;
    private String currentAnimation = "idle";
    private final float animationProgress;

    public PreviewPlayerData() {
        this.animationProgress = 0.0f;
    }

    public boolean isSlim() {
        return "slim".equals(this.modelType);
    }

    public boolean isHD() {
        return this.resolution != null && this.resolution.isHD();
    }

    public int getScaleFactor() {
        return this.resolution != null ? this.resolution.getScale() : 1;
    }

    public ResourceLocation getSkinLocation() {
        return this.skinLocation;
    }

    public void setSkinLocation(ResourceLocation skinLocation) {
        if (this.skinLocation != null && !this.skinLocation.equals((Object)skinLocation)) {
            SkinLayers3DIntegration.clearCache();
        }
        this.skinLocation = skinLocation;
    }

    public ResourceLocation getCapeLocation() {
        return this.capeLocation;
    }

    public void setCapeLocation(ResourceLocation capeLocation) {
        this.capeLocation = capeLocation;
    }

    public String getCapeId() {
        return this.capeId;
    }

    public void setCapeId(String capeId) {
        this.capeId = capeId;
    }

    public String getModelType() {
        return this.modelType;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public SkinResolution getResolution() {
        return this.resolution;
    }

    public void setResolution(SkinResolution resolution) {
        this.resolution = resolution;
    }

    public float getYRotation() {
        return this.yRotation;
    }

    public void setYRotation(float yRotation) {
        this.yRotation = yRotation;
    }

    public float getHeadYaw() {
        return this.headYaw;
    }

    public void setHeadYaw(float headYaw) {
        this.headYaw = headYaw;
    }

    public float getHeadPitch() {
        return this.headPitch;
    }

    public void setHeadPitch(float headPitch) {
        this.headPitch = headPitch;
    }

    public String getCurrentAnimation() {
        return this.currentAnimation;
    }

    public void setCurrentAnimation(String currentAnimation) {
        this.currentAnimation = currentAnimation;
    }

    public float getAnimationProgress() {
        return this.animationProgress;
    }
}

