/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.services;

import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CooldownService {
    private static CooldownService instance;
    private long skinChangeCooldownEnd = 0L;

    private CooldownService() {
    }

    public static CooldownService getInstance() {
        if (instance == null) {
            instance = new CooldownService();
        }
        return instance;
    }

    public void setCooldownEndTime(long time) {
        this.skinChangeCooldownEnd = time;
    }

    public long getRemainingCooldownSeconds() {
        if (this.skinChangeCooldownEnd == 0L) {
            return 0L;
        }
        long remainingMillis = this.skinChangeCooldownEnd - System.currentTimeMillis();
        return remainingMillis > 0L ? remainingMillis / 1000L + 1L : 0L;
    }

    public boolean isCooldownActive() {
        return this.getRemainingCooldownSeconds() > 0L;
    }

    public void clearCooldown() {
        this.skinChangeCooldownEnd = 0L;
    }
}

