/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.services;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.services.IModelService;
import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.common.data.AssetMetadata;
import com.quickskin.mod.common.util.SkinModelDetector;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ModelService
implements IModelService {
    private static ModelService instance;
    private final Map<UUID, String> modelOverrides = new ConcurrentHashMap<UUID, String>();

    private ModelService() {
    }

    public static ModelService getInstance() {
        if (instance == null) {
            instance = new ModelService();
        }
        return instance;
    }

    public static void init() {
        ModelService.getInstance();
        QuickSkin.LOGGER.info("ModelService initialized");
    }

    @Override
    public String getModelType(UUID playerId, String skinId, String requestedModel) {
        String override;
        if (requestedModel != null && !"auto".equalsIgnoreCase(requestedModel)) {
            return requestedModel;
        }
        if ("auto".equalsIgnoreCase(requestedModel)) {
            if (skinId != null && skinId.startsWith("local_skin:")) {
                String hash = skinId.substring("local_skin:".length());
                AssetMetadata metadata = LocalAssetManager.getInstance().getMetadata(hash);
                if (metadata != null && metadata.skinModel() != null) {
                    return metadata.skinModel();
                }
            }
            return "classic";
        }
        if (this.modelOverrides.containsKey(playerId) && !"auto".equalsIgnoreCase(override = this.modelOverrides.get(playerId))) {
            return override;
        }
        return "classic";
    }

    @Override
    public String detectModelType(byte[] skinData) {
        if (skinData == null) {
            return "classic";
        }
        try {
            return SkinModelDetector.detectSkinModel(skinData);
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to detect model type from skin data", (Throwable)e);
            return "classic";
        }
    }

    @Override
    public void setModelOverride(UUID playerId, String model) {
        if (playerId == null || model == null) {
            return;
        }
        this.modelOverrides.put(playerId, model);
        QuickSkin.LOGGER.debug("Model override set for player {}: {}", (Object)playerId, (Object)model);
    }

    @Override
    @Nullable
    public String getModelOverride(UUID playerId) {
        return this.modelOverrides.get(playerId);
    }

    @Override
    public boolean hasModelOverride(UUID playerId) {
        return this.modelOverrides.containsKey(playerId);
    }

    public void clearAll() {
        this.modelOverrides.clear();
    }
}

