/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.storage;

import com.mojang.blaze3d.platform.NativeImage;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.common.util.HDTextureProcessor;
import com.quickskin.mod.config.ClientConfig;
import com.quickskin.mod.platform.PlatformHelper;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class NetworkTextureCache {
    private static NetworkTextureCache instance;
    private final Map<String, byte[]> originalTextureData = new ConcurrentHashMap<String, byte[]>();
    private final Map<String, byte[]> textureDataCache = new ConcurrentHashMap<String, byte[]>();
    private final Map<String, ResourceLocation> textureRegistry = new ConcurrentHashMap<String, ResourceLocation>();
    private final Map<String, String> textureTypeMap = new ConcurrentHashMap<String, String>();

    private NetworkTextureCache() {
    }

    public static NetworkTextureCache getInstance() {
        if (instance == null) {
            instance = new NetworkTextureCache();
        }
        return instance;
    }

    public void storeTexture(String hash, byte[] textureData) {
        this.storeTexture(hash, null, textureData);
    }

    public void storeTexture(String hash, @Nullable String textureType, byte[] textureData) {
        boolean isSkin;
        if (hash == null || textureData == null) {
            QuickSkin.LOGGER.warn("Cannot store null texture data");
            return;
        }
        this.originalTextureData.putIfAbsent(hash, textureData);
        if (textureType != null) {
            this.textureTypeMap.put(hash, textureType);
        }
        boolean shouldRemoveTransparency = (isSkin = "skin".equals(textureType)) && ClientConfig.getInstance().shouldDisableSkinTransparency();
        byte[] processedData = textureData;
        if (shouldRemoveTransparency) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(textureData);
                BufferedImage image = ImageIO.read(bais);
                if (image != null) {
                    image = HDTextureProcessor.removeTransparency(image);
                    processedData = HDTextureProcessor.imageToPng(image);
                    QuickSkin.LOGGER.debug("Removed transparency from network skin texture: {}", (Object)hash);
                }
            }
            catch (IOException e) {
                QuickSkin.LOGGER.error("Failed to process transparency for network texture: {}", (Object)hash, (Object)e);
            }
        }
        this.textureDataCache.put(hash, processedData);
        QuickSkin.LOGGER.debug("Cached network texture: {} ({} bytes, type: {})", new Object[]{hash, processedData.length, textureType});
    }

    public byte @Nullable [] getTextureData(String hash) {
        return this.textureDataCache.get(hash);
    }

    @Nullable
    public ResourceLocation getTextureLocation(String hash) {
        if (this.textureRegistry.containsKey(hash)) {
            return this.textureRegistry.get(hash);
        }
        byte[] textureData = this.textureDataCache.get(hash);
        if (textureData == null) {
            QuickSkin.LOGGER.warn("Network texture not found in cache: {}", (Object)hash);
            return null;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(textureData));
            if (bufferedImage == null) {
                QuickSkin.LOGGER.error("Failed to decode network texture: {}", (Object)hash);
                return null;
            }
            NativeImage nativeImage = this.convertToNativeImage(bufferedImage);
            DynamicTexture dynamicTexture = new DynamicTexture(nativeImage);
            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)("network/" + hash));
            Minecraft.getInstance().getTextureManager().register(location, (AbstractTexture)dynamicTexture);
            this.textureRegistry.put(hash, location);
            QuickSkin.LOGGER.info("Registered network texture: {}", (Object)hash);
            return location;
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to register network texture: {}", (Object)hash, (Object)e);
            return null;
        }
    }

    public boolean hasTexture(String hash) {
        return this.textureDataCache.containsKey(hash);
    }

    public void clear() {
        for (ResourceLocation location : this.textureRegistry.values()) {
            try {
                Minecraft.getInstance().getTextureManager().release(location);
            }
            catch (Exception e) {
                QuickSkin.LOGGER.debug("Failed to release texture {}: {}", (Object)location, (Object)e.getMessage());
            }
        }
        this.originalTextureData.clear();
        this.textureDataCache.clear();
        this.textureRegistry.clear();
        this.textureTypeMap.clear();
        QuickSkin.LOGGER.info("Cleared network texture cache");
    }

    public void clearSkins() {
        ArrayList<String> hashesToClear = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.textureTypeMap.entrySet()) {
            if (!"skin".equals(entry.getValue())) continue;
            hashesToClear.add(entry.getKey());
        }
        for (String hash : hashesToClear) {
            ResourceLocation location = this.textureRegistry.remove(hash);
            if (location == null) continue;
            try {
                Minecraft.getInstance().getTextureManager().release(location);
            }
            catch (Exception e) {
                QuickSkin.LOGGER.debug("Failed to release texture {}: {}", (Object)location, (Object)e.getMessage());
            }
        }
        QuickSkin.LOGGER.info("Cleared {} network skin texture registrations (keeping raw data). Capes remain cached.", (Object)hashesToClear.size());
    }

    public void reprocessSkins() {
        ArrayList<String> skinHashes = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.textureTypeMap.entrySet()) {
            if (!"skin".equals(entry.getValue())) continue;
            skinHashes.add(entry.getKey());
        }
        QuickSkin.LOGGER.info("Reprocessing {} network skins with current transparency settings", (Object)skinHashes.size());
        for (String hash : skinHashes) {
            byte[] originalData = this.originalTextureData.get(hash);
            if (originalData == null) continue;
            this.textureDataCache.remove(hash);
            ResourceLocation oldLocation = this.textureRegistry.remove(hash);
            if (oldLocation != null) {
                try {
                    Minecraft.getInstance().getTextureManager().release(oldLocation);
                }
                catch (Exception e) {
                    QuickSkin.LOGGER.debug("Failed to release texture {}: {}", (Object)oldLocation, (Object)e.getMessage());
                }
            }
            this.storeTexture(hash, "skin", originalData);
        }
        QuickSkin.LOGGER.info("Finished reprocessing network skins");
    }

    public int size() {
        return this.textureDataCache.size();
    }

    private NativeImage convertToNativeImage(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        NativeImage nativeImage = new NativeImage(width, height, true);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = bufferedImage.getRGB(x, y);
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb & 0xFF;
                int abgr = a << 24 | b << 16 | g << 8 | r;
                PlatformHelper.setPixel(nativeImage, x, y, abgr);
            }
        }
        return nativeImage;
    }
}

