/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;

public record AnimationMetadata(List<FrameData> frames, int frameCount) {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public int getTotalDuration() {
        if (this.frames == null || this.frames.isEmpty()) {
            return 0;
        }
        return this.frames.stream().mapToInt(FrameData::delay).sum();
    }

    public int getFrameAtTime(long timeMs) {
        if (this.frames.isEmpty()) {
            return 0;
        }
        long totalDuration = this.getTotalDuration();
        if (totalDuration == 0L) {
            return 0;
        }
        long loopTime = timeMs % totalDuration;
        int accumulatedTime = 0;
        for (FrameData frame : this.frames) {
            if (loopTime >= (long)(accumulatedTime += frame.delay)) continue;
            return frame.index;
        }
        return this.frames.get(this.frames.size() - 1).index();
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    public static AnimationMetadata fromJson(String json) {
        return (AnimationMetadata)GSON.fromJson(json, AnimationMetadata.class);
    }

    public record FrameData(int delay, int index) {
    }
}

