/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.common.data;

import com.quickskin.mod.common.data.PlayerAppearance;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PlayerAppearanceRepository {
    private static final PlayerAppearanceRepository INSTANCE = new PlayerAppearanceRepository();
    private final Map<UUID, PlayerAppearance> appearances = new ConcurrentHashMap<UUID, PlayerAppearance>();

    private PlayerAppearanceRepository() {
    }

    public static PlayerAppearanceRepository getInstance() {
        return INSTANCE;
    }

    @Nullable
    public PlayerAppearance getAppearance(UUID playerId) {
        return this.appearances.get(playerId);
    }

    public void setAppearance(PlayerAppearance appearance) {
        if (appearance == null || appearance.getPlayerId() == null) {
            return;
        }
        this.appearances.put(appearance.getPlayerId(), appearance);
    }

    public void clear() {
        this.appearances.clear();
    }
}

