/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.common.util;

import com.quickskin.mod.QuickSkin;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;

public class HashUtil {
    private static final int BUFFER_SIZE = 8192;

    public static String computeFileHash(Path path) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = is.read(buffer)) != -1) {
                    digest.update(buffer, 0, bytesRead);
                }
            }
            return HashUtil.bytesToHex(digest.digest());
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to compute hash for file: {}", (Object)path, (Object)e);
            return null;
        }
    }

    public static String computeHash(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(data);
            return HashUtil.bytesToHex(digest.digest());
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to compute hash for byte array", (Throwable)e);
            return null;
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

