/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.event;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.gui.overlay.SkinPreviewOverlay;
import com.quickskin.mod.client.gui.screen.PlayerSkinMenuScreen;
import com.quickskin.mod.client.gui.util.DebugOffsetManager;
import com.quickskin.mod.client.gui.widget.PlayerWidget;
import com.quickskin.mod.client.gui.widget.RotateButton;
import com.quickskin.mod.client.rendering.PlayerModelRenderer;
import com.quickskin.mod.client.services.AnimatedTextureManager;
import com.quickskin.mod.client.services.CapeService;
import com.quickskin.mod.client.services.CooldownService;
import com.quickskin.mod.client.services.LocalAssetManager;
import com.quickskin.mod.client.services.ModelService;
import com.quickskin.mod.client.services.MojangApiService;
import com.quickskin.mod.client.services.PlayerAppearanceService;
import com.quickskin.mod.client.storage.LocalAppearanceStorage;
import com.quickskin.mod.client.storage.TextureChunkReceiver;
import com.quickskin.mod.common.data.AssetMetadata;
import com.quickskin.mod.common.data.PlayerAppearanceRepository;
import com.quickskin.mod.common.data.TextureQuality;
import com.quickskin.mod.common.util.HDTextureProcessor;
import com.quickskin.mod.common.util.HashUtil;
import com.quickskin.mod.common.util.TextureAlphaDetector;
import com.quickskin.mod.config.ClientConfig;
import com.quickskin.mod.event.CapeTransparencyEvents;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import java.awt.image.BufferedImage;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    private static int tickCounter = 0;
    private static PlayerWidget playerWidget;
    private static float titleScreenBodyYaw;
    private static float titleScreenTargetRotation;
    private static String sharedAnimation;
    private static Button animationToggleButton;
    private static final List<Button> animationButtons;
    private static boolean isAnimationDropdownOpen;
    private static boolean isLeftDraggingOverlay;
    private static boolean isRightDraggingOverlay;

    public static String getSharedAnimation() {
        return sharedAnimation;
    }

    public static void setSharedAnimation(String animation) {
        if (animation != null && !animation.isEmpty()) {
            sharedAnimation = animation;
        }
    }

    public static void init() {
        QuickSkin.LOGGER.info("Registering client events...");
        CapeTransparencyEvents.register();
        ClientTickEvent.CLIENT_POST.register(client -> {
            AnimatedTextureManager.getInstance().tick();
            if (!client.mouseHandler.isMouseGrabbed()) {
                boolean leftMouseDown = GLFW.glfwGetMouseButton((long)client.getWindow().getWindow(), (int)0) == 1;
                boolean rightMouseDown = GLFW.glfwGetMouseButton((long)client.getWindow().getWindow(), (int)1) == 1;
                double mouseX = client.mouseHandler.xpos() * (double)client.getWindow().getGuiScaledWidth() / (double)client.getWindow().getScreenWidth();
                double mouseY = client.mouseHandler.ypos() * (double)client.getWindow().getGuiScaledHeight() / (double)client.getWindow().getScreenHeight();
                if (leftMouseDown) {
                    if (!isLeftDraggingOverlay) {
                        if (SkinPreviewOverlay.onMouseClicked(mouseX, mouseY, 0).interruptsFurtherEvaluation()) {
                            isLeftDraggingOverlay = true;
                        }
                    } else {
                        SkinPreviewOverlay.onMouseDragged(mouseX, mouseY, 0, 0.0, 0.0);
                    }
                } else if (isLeftDraggingOverlay) {
                    SkinPreviewOverlay.onMouseReleased(mouseX, mouseY, 0);
                    isLeftDraggingOverlay = false;
                }
                if (rightMouseDown) {
                    if (!isRightDraggingOverlay) {
                        if (SkinPreviewOverlay.onRightMouseClicked(mouseX, mouseY, 1).interruptsFurtherEvaluation()) {
                            isRightDraggingOverlay = true;
                        }
                    } else {
                        SkinPreviewOverlay.onMouseDragged(mouseX, mouseY, 1, 0.0, 0.0);
                    }
                } else if (isRightDraggingOverlay) {
                    SkinPreviewOverlay.onMouseReleased(mouseX, mouseY, 1);
                    isRightDraggingOverlay = false;
                }
            } else {
                if (isLeftDraggingOverlay) {
                    isLeftDraggingOverlay = false;
                }
                if (isRightDraggingOverlay) {
                    isRightDraggingOverlay = false;
                }
            }
        });
        ClientEvents.ensurePlayerOwnSkinExists();
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> {
            QuickSkin.LOGGER.info("Local player joined world: {}", (Object)player.getName().getString());
            ClientEvents.setSharedAnimation("idle");
            PlayerAppearanceRepository.getInstance().clear();
            CooldownService.getInstance().clearCooldown();
            ClientEvents.restoreSavedAppearance(player);
        });
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(player -> {
            if (player != null) {
                QuickSkin.LOGGER.info("Local player quit world: {}", (Object)player.getName().getString());
            } else {
                QuickSkin.LOGGER.info("Local player quit world (player was null)");
            }
            AnimatedTextureManager.getInstance().clearAnimations();
            PlayerAppearanceRepository.getInstance().clear();
            ModelService.getInstance().clearAll();
            CooldownService.getInstance().clearCooldown();
            TextureAlphaDetector.clearCache();
            TextureChunkReceiver.getInstance().clear();
            PlayerModelRenderer.clearCachedPlayer();
            if (player != null) {
                LocalAppearanceStorage.getInstance().savePlayerPreferences(player.getUUID());
            }
        });
        ClientPlayerEvent.CLIENT_PLAYER_RESPAWN.register((oldPlayer, newPlayer) -> {
            QuickSkin.LOGGER.debug("Player respawned");
            ClientEvents.restoreSavedAppearance(newPlayer);
        });
        ClientGuiEvent.INIT_POST.register((client, screenAccess) -> {
            LocalAssetManager assetManager;
            AssetMetadata metadata;
            Screen screen = screenAccess.getScreen();
            String screenType = ClientEvents.determineScreenType(screen);
            if (screenType == null) {
                return;
            }
            QuickSkin.LOGGER.debug("Screen initialized: {} (type: {})", (Object)screen.getClass().getSimpleName(), (Object)screenType);
            int buttonX = 0;
            int buttonY = 0;
            int buttonWidth = 98;
            int buttonHeight = 20;
            int spacing = 4;
            if (screen instanceof TitleScreen) {
                TitleScreen titleScreen = (TitleScreen)screen;
                int vanillaButtonsY = titleScreen.height / 4 + 48 + 72;
                ImageButton accessibilityButton = null;
                for (Object listener : screen.children()) {
                    ImageButton imgButton;
                    if (!(listener instanceof ImageButton) || (imgButton = (ImageButton)listener).getY() != vanillaButtonsY || imgButton.getX() <= titleScreen.width / 2 || imgButton.getWidth() != 20 || imgButton.getHeight() != 20 || accessibilityButton != null && imgButton.getX() <= accessibilityButton.getX()) continue;
                    accessibilityButton = imgButton;
                }
                if (accessibilityButton != null) {
                    buttonX = accessibilityButton.getX() + accessibilityButton.getWidth() + spacing;
                    buttonY = accessibilityButton.getY();
                } else {
                    buttonX = titleScreen.width / 2 + 128;
                    buttonY = titleScreen.height / 4 + 48 + 84;
                }
            } else if (screen instanceof PauseScreen) {
                PauseScreen pauseScreen = (PauseScreen)screen;
                Button saveAndQuitButton = null;
                int maxWidth = 0;
                for (Object listener : screen.children()) {
                    Button button2;
                    if (!(listener instanceof Button) || (button2 = (Button)listener).getWidth() <= maxWidth) continue;
                    maxWidth = button2.getWidth();
                }
                if (maxWidth > 0) {
                    int maxY = -1;
                    for (GuiEventListener listener : screen.children()) {
                        Button button3;
                        if (!(listener instanceof Button) || (button3 = (Button)listener).getWidth() != maxWidth || button3.getY() <= maxY) continue;
                        maxY = button3.getY();
                        saveAndQuitButton = button3;
                    }
                }
                if (saveAndQuitButton != null) {
                    buttonX = saveAndQuitButton.getX() + saveAndQuitButton.getWidth() + spacing;
                    buttonY = saveAndQuitButton.getY();
                } else {
                    buttonX = pauseScreen.width - buttonWidth - spacing;
                    buttonY = spacing;
                }
            } else {
                Button referenceButton = ClientEvents.findLargestButton(screen);
                if (referenceButton != null) {
                    int targetY = referenceButton.getY();
                    int rightmostX = referenceButton.getX() + referenceButton.getWidth();
                    for (GuiEventListener listener : screen.children()) {
                        AbstractWidget widget;
                        if (!(listener instanceof AbstractWidget) || (widget = (AbstractWidget)listener).getY() != targetY) continue;
                        rightmostX = Math.max(rightmostX, widget.getX() + widget.getWidth());
                    }
                    buttonX = rightmostX + spacing;
                    buttonY = targetY;
                } else {
                    buttonX = screen.width - buttonWidth - spacing;
                    buttonY = screen.height - buttonHeight - spacing;
                }
            }
            Button changeSkinButton = Button.builder((Component)Component.literal((String)"Change Skin"), button -> Minecraft.getInstance().setScreen((Screen)new PlayerSkinMenuScreen(screen))).bounds(buttonX, buttonY, buttonWidth, buttonHeight).build();
            screenAccess.addRenderableWidget((AbstractWidget)changeSkinButton);
            int widgetSize = 144;
            int offsetX = DebugOffsetManager.getOffsetX(screenType);
            int offsetY = DebugOffsetManager.getOffsetY(screenType);
            int widgetX = buttonX + offsetX;
            int widgetY = buttonY + offsetY;
            ResourceLocation skinLocation = null;
            String modelType = "classic";
            LocalPlayer player = Minecraft.getInstance().player;
            ClientConfig config = ClientConfig.getInstance();
            if (!config.activeSkinHash.isEmpty() && (metadata = (assetManager = LocalAssetManager.getInstance()).getMetadata(config.activeSkinHash)) != null) {
                skinLocation = assetManager.getTextureLocation(config.activeSkinHash, TextureQuality.FULL);
                modelType = assetManager.getSkinModelPreference(config.activeSkinHash);
                if ("auto".equals(modelType)) {
                    modelType = metadata.skinModel();
                }
                QuickSkin.LOGGER.debug("Using saved skin for title screen widget: {} with model type: {}", (Object)metadata.friendlyName(), (Object)modelType);
            }
            if (skinLocation == null && player != null) {
                skinLocation = player.getSkin().texture();
                if (!config.activeSkinHash.isEmpty()) {
                    assetManager = LocalAssetManager.getInstance();
                    modelType = assetManager.getSkinModelPreference(config.activeSkinHash);
                    metadata = assetManager.getMetadata(config.activeSkinHash);
                    if ("auto".equals(modelType) && metadata != null) {
                        modelType = metadata.skinModel();
                    } else {
                        modelType = player.getSkin().model().id();
                        if ("default".equals(modelType)) {
                            modelType = "classic";
                        }
                    }
                } else if ("auto".equals(modelType) && "default".equals(modelType = player.getSkin().model().id())) {
                    modelType = "classic";
                }
            }
            if (skinLocation == null) {
                skinLocation = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/player/wide/steve.png");
                modelType = "classic";
            }
            String capeId = config.activeCapeHash;
            ResourceLocation capeLocation = null;
            if (capeId != null && !capeId.isEmpty()) {
                capeLocation = CapeService.getInstance().getCapeLocation(null, capeId);
            }
            if (playerWidget != null) {
                titleScreenBodyYaw = playerWidget.getBodyYaw();
                titleScreenTargetRotation = playerWidget.getTargetYRotation();
                String currentAnimation = playerWidget.getAnimation();
                if (currentAnimation != null && !currentAnimation.isEmpty()) {
                    ClientEvents.setSharedAnimation(currentAnimation);
                }
            }
            playerWidget = new PlayerWidget(widgetX, widgetY, widgetSize, widgetSize, skinLocation, capeLocation, capeId, modelType);
            if ("title".equals(screenType)) {
                playerWidget.setContext(PlayerWidget.WidgetContext.TITLE_SCREEN);
            } else if ("pause".equals(screenType)) {
                playerWidget.setContext(PlayerWidget.WidgetContext.PAUSE_MENU);
            }
            screenAccess.addRenderableWidget((AbstractWidget)playerWidget);
            playerWidget.setRotationState(titleScreenBodyYaw, titleScreenTargetRotation);
            String savedAnimation = ClientEvents.getSharedAnimation();
            if (savedAnimation != null && !savedAnimation.isEmpty()) {
                playerWidget.setAnimation(savedAnimation);
            }
            int rotateButtonSize = 20;
            int rotateButtonX = buttonX;
            int rotateButtonY = buttonY - rotateButtonSize - spacing;
            RotateButton rotateButton = new RotateButton(rotateButtonX, rotateButtonY, rotateButtonSize, button -> playerWidget.toggleRotation());
            screenAccess.addRenderableWidget((AbstractWidget)rotateButton);
            animationButtons.clear();
            isAnimationDropdownOpen = false;
            if ("title".equals(screenType)) {
                int animToggleWidth = 20;
                int animToggleX = buttonX + buttonWidth - animToggleWidth;
                int animToggleY = rotateButtonY;
                animationToggleButton = Button.builder((Component)Component.literal((String)">"), button -> ClientEvents.toggleAnimationDropdown()).bounds(animToggleX, animToggleY, animToggleWidth, rotateButtonSize).build();
                screenAccess.addRenderableWidget((AbstractWidget)animationToggleButton);
                List<String> availableAnimations = ClientEvents.getAvailableAnimations();
                for (int i = 0; i < availableAnimations.size(); ++i) {
                    String animName = availableAnimations.get(i);
                    int index = i;
                    Button animButton = Button.builder((Component)Component.literal((String)String.valueOf(index + 1)), button -> {
                        if (playerWidget != null) {
                            playerWidget.setAnimation(animName);
                            ClientEvents.setSharedAnimation(animName);
                            QuickSkin.LOGGER.info("Animation {} activated: {}", (Object)(index + 1), (Object)animName);
                        }
                        ClientEvents.toggleAnimationDropdown();
                    }).bounds(animToggleX, animToggleY - (i + 1) * 22, animToggleWidth, rotateButtonSize).build();
                    animButton.visible = false;
                    animButton.active = false;
                    animationButtons.add(animButton);
                    screenAccess.addRenderableWidget((AbstractWidget)animButton);
                }
            }
            QuickSkin.LOGGER.debug("Added 'Change Skin' button at ({}, {}) and PlayerWidget at ({}, {}) for screen type '{}'", new Object[]{buttonX, buttonY, widgetX, widgetY, screenType});
        });
        ClientScreenInputEvent.MOUSE_SCROLLED_PRE.register((client, screen, mouseX, mouseY, amountX, amountY) -> {
            if (!client.mouseHandler.isMouseGrabbed()) {
                return SkinPreviewOverlay.onMouseScrolled(mouseX, mouseY, amountY);
            }
            return EventResult.pass();
        });
        ClientScreenInputEvent.KEY_PRESSED_PRE.register((client, screen, keyCode, scanCode, modifiers) -> EventResult.pass());
        ClientRawInputEvent.KEY_PRESSED.register((client, keyCode, scanCode, action, modifiers) -> EventResult.pass());
        ClientGuiEvent.RENDER_HUD.register((guiGraphics, tickDelta) -> {
            boolean showOverlay = ClientConfig.getInstance().showSkinPreviewOverlay;
            if (showOverlay) {
                SkinPreviewOverlay.render(guiGraphics, tickDelta.getGameTimeDeltaPartialTick(false));
            }
        });
        QuickSkin.LOGGER.info("Client events registered");
    }

    private static String determineScreenType(Screen screen) {
        if (screen instanceof TitleScreen) {
            return "title";
        }
        if (screen instanceof PauseScreen) {
            return "pause";
        }
        return null;
    }

    private static Button findLargestButton(Screen screen) {
        Button button;
        Button largest = null;
        int maxWidth = 0;
        int maxY = -1;
        for (GuiEventListener listener : screen.children()) {
            if (!(listener instanceof Button) || (button = (Button)listener).getWidth() <= maxWidth) continue;
            maxWidth = button.getWidth();
        }
        if (maxWidth > 0) {
            for (GuiEventListener listener : screen.children()) {
                if (!(listener instanceof Button) || (button = (Button)listener).getWidth() != maxWidth || button.getY() <= maxY) continue;
                maxY = button.getY();
                largest = button;
            }
        }
        return largest;
    }

    private static void ensurePlayerOwnSkinExists() {
        AssetMetadata existingMetadata;
        ClientConfig config = ClientConfig.getInstance();
        if (!config.enablePlayerOwnSkinSystem) {
            QuickSkin.LOGGER.info("Player's own skin system is disabled by config. Skipping download.");
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft == null || minecraft.getUser() == null) {
            QuickSkin.LOGGER.warn("Cannot download player skin: Minecraft user not available");
            return;
        }
        String playerName = minecraft.getUser().getName();
        if (!config.playerOwnSkinHash.isEmpty() && (existingMetadata = LocalAssetManager.getInstance().getMetadata(config.playerOwnSkinHash)) != null) {
            QuickSkin.LOGGER.info("Player's own skin already exists: {}", (Object)existingMetadata.friendlyName());
            return;
        }
        QuickSkin.LOGGER.info("Downloading player's own skin: {}", (Object)playerName);
        ((CompletableFuture)MojangApiService.getInstance().fetchSkinByUsername(playerName).thenAccept(skinData -> {
            if (minecraft != null) {
                minecraft.execute(() -> {
                    if (skinData != null) {
                        ClientEvents.handlePlayerOwnSkinFetched(skinData);
                    } else {
                        QuickSkin.LOGGER.warn("Failed to fetch player's own skin");
                    }
                });
            }
        })).exceptionally(throwable -> {
            QuickSkin.LOGGER.error("Error fetching player's own skin", throwable);
            return null;
        });
    }

    private static void handlePlayerOwnSkinFetched(MojangApiService.MojangSkinData skinData) {
        try {
            byte[] processedImageBytes;
            BufferedImage image = skinData.image;
            if (image.getHeight() == image.getWidth() / 2) {
                QuickSkin.LOGGER.info("Converting legacy 64x32 skin to modern format for: {}", (Object)skinData.username);
                image = HDTextureProcessor.convertLegacyToModern(image);
            }
            if (ClientConfig.getInstance().shouldDisableSkinTransparency()) {
                image = HDTextureProcessor.removeTransparency(image);
            }
            if ((processedImageBytes = HDTextureProcessor.imageToPng(image)) == null) {
                QuickSkin.LOGGER.error("Failed to convert processed player skin to byte array.");
                return;
            }
            String finalHash = HashUtil.computeHash(processedImageBytes);
            if (finalHash == null) {
                QuickSkin.LOGGER.error("Failed to compute hash for processed player skin.");
                return;
            }
            LocalAssetManager assetManager = LocalAssetManager.getInstance();
            AssetMetadata existingMetadata = assetManager.getMetadata(finalHash);
            if (existingMetadata == null) {
                String fileName = skinData.username + ".png";
                Path targetPath = assetManager.getSkinsDirectory().resolve(fileName);
                int counter = 1;
                while (Files.exists(targetPath, new LinkOption[0])) {
                    targetPath = assetManager.getSkinsDirectory().resolve(skinData.username + "_" + counter + ".png");
                    ++counter;
                }
                Files.write(targetPath, processedImageBytes, new OpenOption[0]);
                QuickSkin.LOGGER.info("Successfully saved player's own skin to: {}", (Object)targetPath);
                assetManager.reload();
            } else {
                QuickSkin.LOGGER.info("Player's skin already exists in list as '{}' - skipping save.", (Object)existingMetadata.friendlyName());
            }
            ClientConfig config = ClientConfig.getInstance();
            config.playerOwnSkinHash = finalHash;
            if (config.activeSkinHash.isEmpty()) {
                config.activeSkinHash = finalHash;
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null) {
                    AssetMetadata metadata = assetManager.getMetadata(finalHash);
                    if (metadata != null) {
                        String skinId = "local_skin:" + finalHash;
                        String modelType = assetManager.getSkinModelPreference(finalHash);
                        PlayerAppearanceService.getInstance().applySkin(player.getUUID(), skinId, modelType);
                        QuickSkin.LOGGER.info("Auto-selected and applied player's own skin: {}", (Object)skinData.username);
                    }
                } else {
                    QuickSkin.LOGGER.info("Auto-selected player's own skin (will apply on world join): {}", (Object)skinData.username);
                }
            } else {
                QuickSkin.LOGGER.info("Active skin already set, not auto-selecting player's own skin");
            }
            config.save();
            QuickSkin.LOGGER.info("Player's own skin set: hash {}", (Object)finalHash);
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Error handling player's own skin", (Throwable)e);
        }
    }

    private static void restoreSavedAppearance(LocalPlayer player) {
        AssetMetadata metadata;
        ClientConfig config = ClientConfig.getInstance();
        LocalAssetManager assetManager = LocalAssetManager.getInstance();
        String skinId = null;
        String modelType = null;
        String capeId = null;
        if (!config.activeSkinHash.isEmpty()) {
            AssetMetadata metadata2 = assetManager.getMetadata(config.activeSkinHash);
            if (metadata2 != null) {
                skinId = "local_skin:" + metadata2.hash();
                modelType = assetManager.getSkinModelPreference(config.activeSkinHash);
                QuickSkin.LOGGER.info("Restored saved skin: {} with model type: {}", (Object)metadata2.friendlyName(), (Object)modelType);
            } else {
                QuickSkin.LOGGER.warn("Saved skin hash not found in assets: {}", (Object)config.activeSkinHash);
            }
        } else if (!config.playerOwnSkinHash.isEmpty() && (metadata = assetManager.getMetadata(config.playerOwnSkinHash)) != null) {
            config.activeSkinHash = config.playerOwnSkinHash;
            config.save();
            skinId = "local_skin:" + metadata.hash();
            modelType = assetManager.getSkinModelPreference(config.playerOwnSkinHash);
            if ("auto".equals(modelType)) {
                modelType = metadata.skinModel();
            }
            QuickSkin.LOGGER.info("Auto-selected and applied player's own skin: {} with model type: {}", (Object)metadata.friendlyName(), (Object)modelType);
        }
        if (!config.activeCapeHash.isEmpty()) {
            capeId = config.activeCapeHash;
            QuickSkin.LOGGER.info("Restored saved cape: {}", (Object)capeId);
        }
        if (skinId != null || capeId != null) {
            PlayerAppearanceService.getInstance().applyLook(player.getUUID(), skinId, capeId, modelType);
        }
    }

    public static void autoSelectPlayerOwnSkin() {
        ClientConfig config = ClientConfig.getInstance();
        if (config.activeSkinHash.isEmpty() && !config.playerOwnSkinHash.isEmpty()) {
            LocalAssetManager assetManager = LocalAssetManager.getInstance();
            AssetMetadata metadata = assetManager.getMetadata(config.playerOwnSkinHash);
            if (metadata != null) {
                config.activeSkinHash = config.playerOwnSkinHash;
                config.save();
                QuickSkin.LOGGER.info("Auto-selected player's own skin on startup: {}", (Object)metadata.friendlyName());
            } else {
                QuickSkin.LOGGER.debug("Player's own skin hash exists in config but not in assets (will be downloaded)");
            }
        } else if (!config.activeSkinHash.isEmpty()) {
            QuickSkin.LOGGER.debug("Active skin already set: {}", (Object)config.activeSkinHash);
        }
    }

    private static void toggleAnimationDropdown() {
        isAnimationDropdownOpen = !isAnimationDropdownOpen;
        ClientEvents.updateAnimationDropdownState();
    }

    private static void updateAnimationDropdownState() {
        if (animationToggleButton != null) {
            animationToggleButton.setMessage((Component)Component.literal((String)(isAnimationDropdownOpen ? "\u00d7" : ">")));
        }
        for (Button button : animationButtons) {
            button.visible = isAnimationDropdownOpen;
            button.active = isAnimationDropdownOpen;
        }
    }

    private static List<String> getAvailableAnimations() {
        ArrayList<String> animations = new ArrayList<String>();
        animations.add("idle");
        animations.add("walk");
        animations.add("sit");
        return animations;
    }

    static {
        titleScreenBodyYaw = 20.0f;
        titleScreenTargetRotation = 20.0f;
        sharedAnimation = "idle";
        animationButtons = new ArrayList<Button>();
        isAnimationDropdownOpen = false;
        isLeftDraggingOverlay = false;
        isRightDraggingOverlay = false;
    }
}

