/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.event;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.common.data.PlayerAppearance;
import com.quickskin.mod.config.ServerConfig;
import com.quickskin.mod.networking.ServerNetworkHandler;
import com.quickskin.mod.networking.payloads.CooldownUpdatePayload;
import com.quickskin.mod.server.data.ServerCooldownManager;
import com.quickskin.mod.server.data.ServerPlayerAppearanceRepository;
import com.quickskin.mod.server.storage.ServerAnimationCache;
import com.quickskin.mod.server.storage.ServerAppearanceStorage;
import com.quickskin.mod.server.storage.ServerTextureCache;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class CommonEvents {
    public static void init() {
        QuickSkin.LOGGER.info("Registering common events...");
        PlayerEvent.PLAYER_JOIN.register(player -> {
            QuickSkin.LOGGER.info("Player joined: {}", (Object)player.getName().getString());
            PlayerAppearance savedAppearance = ServerAppearanceStorage.getInstance().loadPlayerAppearance(player.getUUID());
            if (savedAppearance == null) {
                QuickSkin.LOGGER.debug("No saved appearance for {}, creating default entry", (Object)player.getName().getString());
                ServerPlayerAppearanceRepository.getInstance().updateAppearance(player.getUUID(), "", "", "classic");
            }
            ServerNetworkHandler.sendAllAppearancesToPlayer(player);
            ServerNetworkHandler.sendAppearanceToAllPlayers(player);
            ServerNetworkHandler.sendServerConfigToPlayer(player);
            int cooldownSeconds = ServerConfig.getInstance().skinChangeCooldownSeconds;
            if (cooldownSeconds > 0 && ServerCooldownManager.getInstance().isPlayerOnCooldown(player.getUUID())) {
                long cooldownEndTime = ServerCooldownManager.getInstance().getCooldownEndTime(player.getUUID());
                CooldownUpdatePayload payload = new CooldownUpdatePayload(cooldownEndTime);
                NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload);
                QuickSkin.LOGGER.debug("Sent initial cooldown status to joining player {}", (Object)player.getName().getString());
            }
        });
        PlayerEvent.PLAYER_QUIT.register(player -> {
            QuickSkin.LOGGER.info("Player quit: {}", (Object)player.getName().getString());
            ServerAppearanceStorage.getInstance().savePlayerAppearance(player.getUUID());
            int cooldownSeconds = ServerConfig.getInstance().skinChangeCooldownSeconds;
            if (cooldownSeconds > 0) {
                ServerCooldownManager.getInstance().removePlayer(player.getUUID());
            }
        });
        PlayerEvent.CHANGE_DIMENSION.register((player, oldLevel, newLevel) -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = player;
                ServerNetworkHandler.sendAllAppearancesToPlayer(serverPlayer);
            }
        });
        LifecycleEvent.SERVER_STARTING.register(server -> {
            QuickSkin.LOGGER.info("Server starting, initializing QuickSkin server components...");
            ServerTextureCache.getInstance().init((MinecraftServer)server);
            ServerAnimationCache.getInstance().init((MinecraftServer)server);
            ServerAppearanceStorage.getInstance().init((MinecraftServer)server);
            ServerConfig.reload();
        });
        LifecycleEvent.SERVER_STARTED.register(server -> QuickSkin.LOGGER.info("Server started, QuickSkin ready"));
        LifecycleEvent.SERVER_STOPPING.register(server -> {
            QuickSkin.LOGGER.info("Server stopping, saving QuickSkin data...");
            ServerTextureCache.getInstance().saveAll();
            ServerConfig.getInstance().save();
        });
        LifecycleEvent.SERVER_STOPPED.register(server -> {
            QuickSkin.LOGGER.info("Server stopped, QuickSkin cleanup complete");
            ServerTextureCache.getInstance().clear();
            ServerAnimationCache.getInstance().clear();
        });
        QuickSkin.LOGGER.info("Common events registered");
    }
}

