/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.quickskin.mod.client.services.AnimatedTextureManager;
import com.quickskin.mod.client.services.PlayerAppearanceService;
import com.quickskin.mod.common.util.TextureAlphaDetector;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CapeLayer.class})
public class CapeLayerMixin {
    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;FFFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void quickskin$renderCustomCape(PoseStack poseStack, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        boolean hasTransparency;
        PlayerAppearanceService service = PlayerAppearanceService.getInstance();
        if (!service.hasActiveCape(player.getUUID())) {
            return;
        }
        ResourceLocation capeTexture = player.getSkin().capeTexture();
        if (capeTexture == null) {
            ci.cancel();
            return;
        }
        if (player.getItemBySlot(EquipmentSlot.CHEST).is(Items.ELYTRA)) {
            ci.cancel();
            return;
        }
        ResourceLocation finalTexture = AnimatedTextureManager.getInstance().getAnimationFrame(capeTexture).orElse(capeTexture);
        RenderType renderType = finalTexture.getNamespace().equals("quickskin") ? RenderType.entityTranslucentCull((ResourceLocation)finalTexture) : ((hasTransparency = TextureAlphaDetector.hasTransparency(finalTexture)) ? RenderType.entityTranslucentCull((ResourceLocation)finalTexture) : RenderType.entitySolid((ResourceLocation)finalTexture));
        VertexConsumer vertexconsumer = buffer.getBuffer(renderType);
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, 0.125);
        double d0 = Mth.lerp((double)partialTicks, (double)player.xCloakO, (double)player.xCloak) - Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX());
        double d1 = Mth.lerp((double)partialTicks, (double)player.yCloakO, (double)player.yCloak) - Mth.lerp((double)partialTicks, (double)player.yo, (double)player.getY());
        double d2 = Mth.lerp((double)partialTicks, (double)player.zCloakO, (double)player.zCloak) - Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ());
        float f = player.yBodyRotO + (player.yBodyRot - player.yBodyRotO);
        double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
        double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
        float f1 = (float)d1 * 10.0f;
        f1 = Mth.clamp((float)f1, (float)-6.0f, (float)32.0f);
        float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
        f2 = Mth.clamp((float)f2, (float)0.0f, (float)150.0f);
        float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
        f3 = Mth.clamp((float)f3, (float)-20.0f, (float)20.0f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        float f4 = Mth.lerp((float)partialTicks, (float)player.oBob, (float)player.bob);
        f1 += Mth.sin((float)(Mth.lerp((float)partialTicks, (float)player.walkDistO, (float)player.walkDist) * 6.0f)) * 32.0f * f4;
        if (player.isCrouching()) {
            f1 += 25.0f;
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(6.0f + f2 / 2.0f + f1));
        poseStack.mulPose(Axis.ZP.rotationDegrees(f3 / 2.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - f3 / 2.0f));
        ((PlayerModel)((CapeLayer)this).getParentModel()).renderCloak(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        ci.cancel();
    }
}

