/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.authlib.GameProfile;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.services.PlayerAppearanceService;
import com.quickskin.mod.common.data.PlayerAppearance;
import java.util.Objects;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={PlayerInfo.class}, priority=900)
public abstract class PlayerInfoMixin {
    @Shadow
    @Final
    private GameProfile profile;
    private PlayerSkin quickskin$cachedSkin = null;
    private PlayerSkin quickskin$cachedOriginalSkin = null;
    private ResourceLocation quickskin$cachedSkinLocation = null;
    private ResourceLocation quickskin$cachedCapeLocation = null;
    private String quickskin$cachedModelName = null;

    @ModifyReturnValue(method={"getSkin()Lnet/minecraft/client/resources/PlayerSkin;"}, at={@At(value="RETURN")})
    private PlayerSkin quickskin$onGetSkin(PlayerSkin originalSkin) {
        PlayerSkin customSkin;
        String currentModelName;
        PlayerAppearanceService service = PlayerAppearanceService.getInstance();
        boolean hasCustomSkin = service.hasActiveSkin(this.profile.getId());
        boolean hasCustomCape = service.hasActiveCape(this.profile.getId());
        boolean hasModelOverride = service.hasModelOverride(this.profile.getId());
        if (!(hasCustomSkin || hasCustomCape || hasModelOverride)) {
            this.quickskin$cachedSkin = null;
            this.quickskin$cachedOriginalSkin = null;
            return originalSkin;
        }
        ResourceLocation currentSkinLocation = hasCustomSkin ? service.getSkinLocation(this.profile.getId()) : null;
        ResourceLocation currentCapeLocation = hasCustomCape ? service.getCapeLocation(this.profile.getId()) : null;
        String string = currentModelName = hasCustomSkin || hasModelOverride ? service.getModelName(this.profile.getId()) : null;
        if (this.quickskin$cachedSkin != null && this.quickskin$cachedOriginalSkin == originalSkin && Objects.equals(this.quickskin$cachedSkinLocation, currentSkinLocation) && Objects.equals(this.quickskin$cachedCapeLocation, currentCapeLocation) && Objects.equals(this.quickskin$cachedModelName, currentModelName)) {
            return this.quickskin$cachedSkin;
        }
        QuickSkin.LOGGER.debug("PlayerInfoMixin: Rebuilding skin for player {} (hasCustomSkin={}, hasCustomCape={}, hasModelOverride={})", new Object[]{this.profile.getName(), hasCustomSkin, hasCustomCape, hasModelOverride});
        ResourceLocation skinTexture = originalSkin.texture();
        PlayerSkin.Model skinModel = originalSkin.model();
        ResourceLocation capeTexture = originalSkin.capeTexture();
        if (hasCustomSkin && currentSkinLocation != null) {
            skinTexture = currentSkinLocation;
            QuickSkin.LOGGER.debug("PlayerInfoMixin: Set custom skin texture to {}", (Object)currentSkinLocation);
        }
        if ((hasCustomSkin || hasModelOverride) && currentModelName != null) {
            skinModel = "slim".equals(currentModelName) ? PlayerSkin.Model.SLIM : PlayerSkin.Model.WIDE;
            QuickSkin.LOGGER.debug("PlayerInfoMixin: Set custom model to {} ({})", (Object)currentModelName, (Object)skinModel);
        }
        if (hasCustomCape) {
            if (currentCapeLocation != null) {
                capeTexture = currentCapeLocation;
                QuickSkin.LOGGER.debug("PlayerInfoMixin: Set custom cape texture to {}", (Object)currentCapeLocation);
            } else {
                PlayerAppearance appearance = service.getAppearance(this.profile.getId());
                if (appearance != null && ("__NONE__".equals(appearance.getCapeId()) || appearance.getCapeId().isEmpty())) {
                    capeTexture = null;
                    QuickSkin.LOGGER.debug("PlayerInfoMixin: Hiding cape");
                }
            }
        }
        this.quickskin$cachedSkin = customSkin = new PlayerSkin(skinTexture, originalSkin.textureUrl(), capeTexture, originalSkin.elytraTexture(), skinModel, originalSkin.secure());
        this.quickskin$cachedOriginalSkin = originalSkin;
        this.quickskin$cachedSkinLocation = currentSkinLocation;
        this.quickskin$cachedCapeLocation = currentCapeLocation;
        this.quickskin$cachedModelName = currentModelName;
        return customSkin;
    }
}

