/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.networking;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.networking.ClientNetworkHandler;
import com.quickskin.mod.networking.payloads.CooldownUpdatePayload;
import com.quickskin.mod.networking.payloads.SendAnimationMetadataPayload;
import com.quickskin.mod.networking.payloads.SendTextureChunkPayload;
import com.quickskin.mod.networking.payloads.SendTexturePayload;
import com.quickskin.mod.networking.payloads.SyncAppearancePayload;
import com.quickskin.mod.networking.payloads.SyncServerConfigPayload;
import dev.architectury.networking.NetworkManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientNetworking {
    public static void init() {
        QuickSkin.LOGGER.info("Initializing client networking...");
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), SyncAppearancePayload.TYPE, SyncAppearancePayload.CODEC, ClientNetworkHandler::handleSyncAppearance);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), SendTexturePayload.TYPE, SendTexturePayload.CODEC, ClientNetworkHandler::handleSendTexture);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), SendTextureChunkPayload.TYPE, SendTextureChunkPayload.CODEC, ClientNetworkHandler::handleSendTextureChunk);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), SendAnimationMetadataPayload.TYPE, SendAnimationMetadataPayload.CODEC, ClientNetworkHandler::handleSendAnimationMetadata);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), SyncServerConfigPayload.TYPE, SyncServerConfigPayload.CODEC, ClientNetworkHandler::handleSyncServerConfig);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), CooldownUpdatePayload.TYPE, CooldownUpdatePayload.CODEC, ClientNetworkHandler::handleCooldownUpdate);
        QuickSkin.LOGGER.info("Client networking initialized (client-side receivers ready)");
    }
}

