/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.networking;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.networking.ServerNetworkHandler;
import com.quickskin.mod.networking.payloads.CooldownUpdatePayload;
import com.quickskin.mod.networking.payloads.RequestTexturePayload;
import com.quickskin.mod.networking.payloads.SendAnimationMetadataPayload;
import com.quickskin.mod.networking.payloads.SendTextureChunkPayload;
import com.quickskin.mod.networking.payloads.SendTexturePayload;
import com.quickskin.mod.networking.payloads.SyncAppearancePayload;
import com.quickskin.mod.networking.payloads.SyncServerConfigPayload;
import com.quickskin.mod.networking.payloads.TextureChunkPayload;
import com.quickskin.mod.networking.payloads.UpdateAppearancePayload;
import com.quickskin.mod.networking.payloads.UpdateServerConfigPayload;
import com.quickskin.mod.networking.payloads.UploadAnimationMetadataPayload;
import com.quickskin.mod.networking.payloads.UploadTexturePayload;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import net.neoforged.api.distmarker.Dist;

public class ModNetworking {
    public static void init() {
        QuickSkin.LOGGER.info("Initializing networking...");
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), UploadTexturePayload.TYPE, UploadTexturePayload.CODEC, ServerNetworkHandler::handleUploadTexture);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), UpdateAppearancePayload.TYPE, UpdateAppearancePayload.CODEC, ServerNetworkHandler::handleUpdateAppearance);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), RequestTexturePayload.TYPE, RequestTexturePayload.CODEC, ServerNetworkHandler::handleRequestTexture);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), TextureChunkPayload.TYPE, TextureChunkPayload.CODEC, ServerNetworkHandler::handleTextureChunk);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), UploadAnimationMetadataPayload.TYPE, UploadAnimationMetadataPayload.CODEC, ServerNetworkHandler::handleUploadAnimationMetadata);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), UpdateServerConfigPayload.TYPE, UpdateServerConfigPayload.CODEC, ServerNetworkHandler::handleUpdateServerConfig);
        if (Platform.getEnv() == Dist.DEDICATED_SERVER) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), SyncAppearancePayload.TYPE, SyncAppearancePayload.CODEC, (payload, context) -> {});
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), SendTexturePayload.TYPE, SendTexturePayload.CODEC, (payload, context) -> {});
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), SendTextureChunkPayload.TYPE, SendTextureChunkPayload.CODEC, (payload, context) -> {});
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), SendAnimationMetadataPayload.TYPE, SendAnimationMetadataPayload.CODEC, (payload, context) -> {});
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), SyncServerConfigPayload.TYPE, SyncServerConfigPayload.CODEC, (payload, context) -> {});
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), CooldownUpdatePayload.TYPE, CooldownUpdatePayload.CODEC, (payload, context) -> {});
            QuickSkin.LOGGER.info("Registered S2C payloads for dedicated server");
        }
        QuickSkin.LOGGER.info("Networking initialized (server-side receivers ready)");
    }
}

