/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.networking;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.common.data.PlayerAppearance;
import com.quickskin.mod.config.ServerConfig;
import com.quickskin.mod.networking.payloads.CooldownUpdatePayload;
import com.quickskin.mod.networking.payloads.RequestTexturePayload;
import com.quickskin.mod.networking.payloads.SendAnimationMetadataPayload;
import com.quickskin.mod.networking.payloads.SendTexturePayload;
import com.quickskin.mod.networking.payloads.SyncAppearancePayload;
import com.quickskin.mod.networking.payloads.SyncServerConfigPayload;
import com.quickskin.mod.networking.payloads.TextureChunkPayload;
import com.quickskin.mod.networking.payloads.UpdateAppearancePayload;
import com.quickskin.mod.networking.payloads.UpdateServerConfigPayload;
import com.quickskin.mod.networking.payloads.UploadAnimationMetadataPayload;
import com.quickskin.mod.networking.payloads.UploadTexturePayload;
import com.quickskin.mod.server.data.ServerCooldownManager;
import com.quickskin.mod.server.data.ServerPlayerAppearanceRepository;
import com.quickskin.mod.server.storage.ServerAnimationCache;
import com.quickskin.mod.server.storage.ServerTextureCache;
import com.quickskin.mod.server.storage.TextureChunkAssembler;
import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class ServerNetworkHandler {
    public static void handleUploadTexture(UploadTexturePayload payload, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null || !player.getUUID().equals(payload.playerId())) {
                QuickSkin.LOGGER.warn("Player UUID mismatch in upload texture packet");
                return;
            }
            QuickSkin.LOGGER.info("Received {} upload from player: {} (size: {} bytes)", new Object[]{payload.textureType(), player.getName().getString(), payload.imageData().length});
            String hash = payload.playerId().toString() + "_" + payload.textureType();
            ServerTextureCache.getInstance().storeTexture(hash, payload.imageData());
            ServerNetworkHandler.broadcastTextureToOtherPlayers(player, payload.textureType(), hash, payload.imageData());
        });
    }

    public static void handleUpdateAppearance(UpdateAppearancePayload payload, NetworkManager.PacketContext context) {
        context.queue(() -> {
            boolean isSkinChanging;
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null || !player.getUUID().equals(payload.playerId())) {
                QuickSkin.LOGGER.warn("Player UUID mismatch in update appearance packet");
                return;
            }
            int cooldownSeconds = ServerConfig.getInstance().skinChangeCooldownSeconds;
            PlayerAppearance currentAppearance = ServerPlayerAppearanceRepository.getInstance().getAppearance(payload.playerId());
            boolean bl = isSkinChanging = payload.skinId() != null && !payload.skinId().isEmpty() && (currentAppearance == null || !payload.skinId().equals(currentAppearance.getSkinId()));
            if (isSkinChanging && cooldownSeconds > 0 && ServerCooldownManager.getInstance().isPlayerOnCooldown(payload.playerId())) {
                QuickSkin.LOGGER.warn("Player {} tried to change skin during cooldown. Change rejected.", (Object)player.getName().getString());
                return;
            }
            QuickSkin.LOGGER.info("Player {} updated appearance: skin={}, cape={}, model={}", new Object[]{player.getName().getString(), payload.skinId(), payload.capeId(), payload.model()});
            ServerPlayerAppearanceRepository.getInstance().updateAppearance(payload.playerId(), payload.skinId(), payload.capeId(), payload.model());
            if (isSkinChanging && cooldownSeconds > 0) {
                ServerCooldownManager.getInstance().recordSkinChange(payload.playerId());
                long cooldownEndTime = ServerCooldownManager.getInstance().getCooldownEndTime(payload.playerId());
                CooldownUpdatePayload cooldownPayload = new CooldownUpdatePayload(cooldownEndTime);
                NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)cooldownPayload);
                QuickSkin.LOGGER.debug("Sent cooldown update to player {}", (Object)player.getName().getString());
            }
            ServerNetworkHandler.broadcastAppearanceToOtherPlayers(player, payload.skinId(), payload.capeId(), payload.model());
        });
    }

    public static void handleRequestTexture(RequestTexturePayload payload, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null) {
                return;
            }
            QuickSkin.LOGGER.info("Player {} requested {} texture: {}", new Object[]{player.getName().getString(), payload.textureType(), payload.hash()});
            byte[] textureData = ServerTextureCache.getInstance().getTexture(payload.hash());
            if (textureData != null) {
                ServerNetworkHandler.sendTextureToClient(player, payload.textureType(), payload.hash(), textureData);
            } else {
                QuickSkin.LOGGER.warn("Requested texture not found: {}", (Object)payload.hash());
            }
        });
    }

    public static void handleTextureChunk(TextureChunkPayload payload, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null) {
                return;
            }
            if (payload.chunkData().length > 32768) {
                QuickSkin.LOGGER.warn("Rejecting oversized chunk from {}: {} bytes (max: 32KB)", (Object)player.getName().getString(), (Object)payload.chunkData().length);
                return;
            }
            if (payload.chunkIndex() < 0 || payload.chunkIndex() >= payload.totalChunks()) {
                QuickSkin.LOGGER.warn("Invalid chunk index from {}: {}/{}", new Object[]{player.getName().getString(), payload.chunkIndex(), payload.totalChunks()});
                return;
            }
            if (payload.totalChunks() < 1 || payload.totalChunks() > 1000) {
                QuickSkin.LOGGER.warn("Invalid total chunks from {}: {}", (Object)player.getName().getString(), (Object)payload.totalChunks());
                return;
            }
            QuickSkin.LOGGER.debug("Received texture chunk {}/{} from {} (type: {}, hash: {})", new Object[]{payload.chunkIndex() + 1, payload.totalChunks(), player.getName().getString(), payload.textureType(), payload.hash()});
            byte[] completeTexture = TextureChunkAssembler.getInstance().addChunk(payload.hash(), payload.chunkIndex(), payload.totalChunks(), payload.chunkData());
            if (completeTexture != null) {
                QuickSkin.LOGGER.info("Received complete {} texture from player: {} (size: {} bytes)", new Object[]{payload.textureType(), player.getName().getString(), completeTexture.length});
                ServerTextureCache.getInstance().storeTexture(payload.hash(), completeTexture);
                ServerNetworkHandler.broadcastTextureToOtherPlayers(player, payload.textureType(), payload.hash(), completeTexture);
            }
        });
    }

    public static void handleUploadAnimationMetadata(UploadAnimationMetadataPayload payload, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null) {
                return;
            }
            QuickSkin.LOGGER.info("Player {} uploaded animation metadata for: {}", (Object)player.getName().getString(), (Object)payload.hash());
            ServerAnimationCache.getInstance().storeMetadata(payload.hash(), payload.metadataJson());
            ServerNetworkHandler.broadcastAnimationMetadataToOtherPlayers(player, payload.hash(), payload.metadataJson());
        });
    }

    public static void handleUpdateServerConfig(UpdateServerConfigPayload payload, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null) {
                return;
            }
            if (!player.hasPermissions(2)) {
                QuickSkin.LOGGER.warn("Player {} tried to change server config without permission", (Object)player.getName().getString());
                return;
            }
            QuickSkin.LOGGER.info("Admin {} updated server config: {} = {}", new Object[]{player.getName().getString(), payload.key(), payload.value()});
            ServerConfig serverConfig = ServerConfig.getInstance();
            switch (payload.key()) {
                case "disableSkinTransparency": {
                    serverConfig.disableSkinTransparency = payload.value();
                    break;
                }
                default: {
                    QuickSkin.LOGGER.warn("Unknown server config key: {}", (Object)payload.key());
                    return;
                }
            }
            serverConfig.save();
            ServerNetworkHandler.broadcastServerConfigToAllPlayers(player.server);
        });
    }

    private static void broadcastTextureToOtherPlayers(ServerPlayer player, String textureType, String hash, byte[] imageData) {
        SendTexturePayload payload = new SendTexturePayload(textureType, hash, imageData);
        for (ServerPlayer otherPlayer : player.server.getPlayerList().getPlayers()) {
            if (otherPlayer.getUUID().equals(player.getUUID())) continue;
            NetworkManager.sendToPlayer((ServerPlayer)otherPlayer, (CustomPacketPayload)payload);
        }
        QuickSkin.LOGGER.debug("Broadcasted {} texture from {} to {} players", new Object[]{textureType, player.getName().getString(), player.server.getPlayerList().getPlayerCount() - 1});
    }

    private static void broadcastAppearanceToOtherPlayers(ServerPlayer player, String skinId, String capeId, String model) {
        SyncAppearancePayload payload = new SyncAppearancePayload(player.getUUID(), skinId, capeId, model);
        for (ServerPlayer otherPlayer : player.server.getPlayerList().getPlayers()) {
            if (otherPlayer.getUUID().equals(player.getUUID())) continue;
            NetworkManager.sendToPlayer((ServerPlayer)otherPlayer, (CustomPacketPayload)payload);
        }
        QuickSkin.LOGGER.debug("Broadcasted appearance from {} to {} players", (Object)player.getName().getString(), (Object)(player.server.getPlayerList().getPlayerCount() - 1));
    }

    public static void sendAppearanceToPlayer(ServerPlayer recipient, UUID targetPlayerId) {
        PlayerAppearance appearance = ServerPlayerAppearanceRepository.getInstance().getAppearance(targetPlayerId);
        if (appearance != null) {
            String hash;
            SyncAppearancePayload payload = new SyncAppearancePayload(targetPlayerId, appearance.getSkinId(), appearance.getCapeId(), appearance.getModel());
            NetworkManager.sendToPlayer((ServerPlayer)recipient, (CustomPacketPayload)payload);
            String skinId = appearance.getSkinId();
            String capeId = appearance.getCapeId();
            if (skinId != null && skinId.startsWith("local_skin:")) {
                hash = skinId.substring("local_skin:".length());
                byte[] skinData = ServerTextureCache.getInstance().getTexture(hash);
                if (skinData != null) {
                    SendTexturePayload skinPayload = new SendTexturePayload("skin", hash, skinData);
                    NetworkManager.sendToPlayer((ServerPlayer)recipient, (CustomPacketPayload)skinPayload);
                    QuickSkin.LOGGER.debug("Sent skin texture {} to {}", (Object)hash, (Object)recipient.getName().getString());
                }
            }
            if (capeId != null && capeId.startsWith("local_cape:")) {
                hash = capeId.substring("local_cape:".length());
                byte[] capeData = ServerTextureCache.getInstance().getTexture(hash);
                if (capeData != null) {
                    SendTexturePayload capePayload = new SendTexturePayload("cape", hash, capeData);
                    NetworkManager.sendToPlayer((ServerPlayer)recipient, (CustomPacketPayload)capePayload);
                    QuickSkin.LOGGER.debug("Sent cape texture {} to {}", (Object)hash, (Object)recipient.getName().getString());
                    String metadata = ServerAnimationCache.getInstance().getMetadata(hash);
                    if (metadata != null) {
                        SendAnimationMetadataPayload animPayload = new SendAnimationMetadataPayload(hash, metadata);
                        NetworkManager.sendToPlayer((ServerPlayer)recipient, (CustomPacketPayload)animPayload);
                        QuickSkin.LOGGER.debug("Sent animation metadata for {} to {}", (Object)hash, (Object)recipient.getName().getString());
                    }
                }
            }
            QuickSkin.LOGGER.debug("Sent appearance of {} to {}", (Object)targetPlayerId, (Object)recipient.getName().getString());
        }
    }

    public static void sendAllAppearancesToPlayer(ServerPlayer player) {
        for (ServerPlayer otherPlayer : player.server.getPlayerList().getPlayers()) {
            if (otherPlayer.getUUID().equals(player.getUUID())) continue;
            ServerNetworkHandler.sendAppearanceToPlayer(player, otherPlayer.getUUID());
        }
        QuickSkin.LOGGER.debug("Sent all player appearances to {}", (Object)player.getName().getString());
    }

    public static void sendAppearanceToAllPlayers(ServerPlayer player) {
        PlayerAppearance appearance = ServerPlayerAppearanceRepository.getInstance().getAppearance(player.getUUID());
        if (appearance != null) {
            for (ServerPlayer otherPlayer : player.server.getPlayerList().getPlayers()) {
                if (otherPlayer.getUUID().equals(player.getUUID())) continue;
                ServerNetworkHandler.sendAppearanceToPlayer(otherPlayer, player.getUUID());
            }
            QuickSkin.LOGGER.debug("Sent appearance of {} to all other players", (Object)player.getName().getString());
        } else {
            QuickSkin.LOGGER.debug("No appearance found for {}, skipping broadcast to other players", (Object)player.getName().getString());
        }
    }

    private static void sendTextureToClient(ServerPlayer player, String textureType, String hash, byte[] textureData) {
        SendTexturePayload payload = new SendTexturePayload(textureType, hash, textureData);
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload);
        QuickSkin.LOGGER.debug("Sent {} texture {} to {}", new Object[]{textureType, hash, player.getName().getString()});
    }

    private static void broadcastAnimationMetadataToOtherPlayers(ServerPlayer player, String hash, String metadataJson) {
        SendAnimationMetadataPayload payload = new SendAnimationMetadataPayload(hash, metadataJson);
        for (ServerPlayer otherPlayer : player.server.getPlayerList().getPlayers()) {
            if (otherPlayer.getUUID().equals(player.getUUID())) continue;
            NetworkManager.sendToPlayer((ServerPlayer)otherPlayer, (CustomPacketPayload)payload);
        }
        QuickSkin.LOGGER.debug("Broadcasted animation metadata for {} to {} players", (Object)hash, (Object)(player.server.getPlayerList().getPlayerCount() - 1));
    }

    public static void sendServerConfigToPlayer(ServerPlayer player) {
        ServerConfig serverConfig = ServerConfig.getInstance();
        String configJson = serverConfig.toJson();
        SyncServerConfigPayload payload = new SyncServerConfigPayload(configJson);
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload);
        QuickSkin.LOGGER.debug("Sent server config to {}", (Object)player.getName().getString());
    }

    private static void broadcastServerConfigToAllPlayers(MinecraftServer server) {
        ServerConfig serverConfig = ServerConfig.getInstance();
        String configJson = serverConfig.toJson();
        SyncServerConfigPayload payload = new SyncServerConfigPayload(configJson);
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload);
        }
        QuickSkin.LOGGER.info("Broadcasted server config to all {} players", (Object)server.getPlayerList().getPlayerCount());
    }
}

