/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.networking.packets;

import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class PacketHelper {
    public static RegistryFriendlyByteBuf createUploadTexturePacket(UUID playerId, String textureType, byte[] imageData) {
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), (RegistryAccess)RegistryAccess.EMPTY);
        buf.writeUUID(playerId);
        buf.writeUtf(textureType);
        buf.writeByteArray(imageData);
        return buf;
    }

    public static RegistryFriendlyByteBuf createUpdateAppearancePacket(UUID playerId, String skinId, String capeId, String model) {
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), (RegistryAccess)RegistryAccess.EMPTY);
        buf.writeUUID(playerId);
        buf.writeUtf(skinId != null ? skinId : "");
        buf.writeUtf(capeId != null ? capeId : "");
        buf.writeUtf(model != null ? model : "classic");
        return buf;
    }

    public static RegistryFriendlyByteBuf createSyncAppearancePacket(UUID playerId, String skinId, String capeId, String model) {
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), (RegistryAccess)RegistryAccess.EMPTY);
        buf.writeUUID(playerId);
        buf.writeUtf(skinId != null ? skinId : "");
        buf.writeUtf(capeId != null ? capeId : "");
        buf.writeUtf(model != null ? model : "classic");
        return buf;
    }

    public static RegistryFriendlyByteBuf createRequestTexturePacket(UUID playerId, String textureType, String hash) {
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), (RegistryAccess)RegistryAccess.EMPTY);
        buf.writeUUID(playerId);
        buf.writeUtf(textureType);
        buf.writeUtf(hash);
        return buf;
    }

    public static RegistryFriendlyByteBuf createSendTexturePacket(String textureType, String hash, byte[] imageData) {
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), (RegistryAccess)RegistryAccess.EMPTY);
        buf.writeUtf(textureType);
        buf.writeUtf(hash);
        buf.writeByteArray(imageData);
        return buf;
    }

    public static RegistryFriendlyByteBuf createSyncServerConfigPacket(String configJson) {
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), (RegistryAccess)RegistryAccess.EMPTY);
        buf.writeUtf(configJson);
        return buf;
    }

    public static RegistryFriendlyByteBuf createSendAnimationMetadataPacket(String hash, String metadataJson) {
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), (RegistryAccess)RegistryAccess.EMPTY);
        buf.writeUtf(hash);
        buf.writeUtf(metadataJson);
        return buf;
    }

    public static UUID readPlayerId(FriendlyByteBuf buf) {
        return buf.readUUID();
    }

    public static String readString(FriendlyByteBuf buf) {
        return buf.readUtf();
    }

    public static byte[] readByteArray(FriendlyByteBuf buf) {
        return buf.readByteArray();
    }

    public static boolean readBoolean(FriendlyByteBuf buf) {
        return buf.readBoolean();
    }
}

