/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.networking.payloads;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public class PayloadCodecs {
    private static final int MAX_STRING_LENGTH = Short.MAX_VALUE;

    public static void writeString(ByteBuf buf, String string) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > Short.MAX_VALUE) {
            throw new EncoderException("String too big (was " + bytes.length + " bytes encoded, max 32767)");
        }
        PayloadCodecs.writeVarInt(buf, bytes.length);
        buf.writeBytes(bytes);
    }

    public static String readString(ByteBuf buf) {
        int length = PayloadCodecs.readVarInt(buf);
        if (length > 131068) {
            throw new DecoderException("The received encoded string buffer length is longer than maximum allowed (" + length + " > 131068)");
        }
        if (length < 0) {
            throw new DecoderException("The received encoded string buffer length is less than zero! Weird string!");
        }
        byte[] bytes = new byte[length];
        buf.readBytes(bytes);
        String string = new String(bytes, StandardCharsets.UTF_8);
        if (string.length() > Short.MAX_VALUE) {
            throw new DecoderException("The received string length is longer than maximum allowed (" + length + " > 32767)");
        }
        return string;
    }

    public static void writeUUID(ByteBuf buf, UUID uuid) {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }

    public static UUID readUUID(ByteBuf buf) {
        return new UUID(buf.readLong(), buf.readLong());
    }

    private static void writeVarInt(ByteBuf buf, int value) {
        while ((value & 0xFFFFFF80) != 0) {
            buf.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        buf.writeByte(value);
    }

    private static int readVarInt(ByteBuf buf) {
        byte b;
        int i = 0;
        int j = 0;
        do {
            b = buf.readByte();
            i |= (b & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b & 0x80) == 128);
        return i;
    }
}

