/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.networking.payloads;

import com.quickskin.mod.networking.payloads.PayloadCodecs;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record TextureChunkPayload(String hash, String textureType, int chunkIndex, int totalChunks, byte[] chunkData) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TextureChunkPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"texture_chunk"));
    public static final StreamCodec<ByteBuf, TextureChunkPayload> CODEC = StreamCodec.of((buf, payload) -> {
        PayloadCodecs.writeString(buf, payload.hash);
        PayloadCodecs.writeString(buf, payload.textureType);
        buf.writeInt(payload.chunkIndex);
        buf.writeInt(payload.totalChunks);
        buf.writeInt(payload.chunkData.length);
        buf.writeBytes(payload.chunkData);
    }, buf -> {
        String hash = PayloadCodecs.readString(buf);
        String textureType = PayloadCodecs.readString(buf);
        int chunkIndex = buf.readInt();
        int totalChunks = buf.readInt();
        int length = buf.readInt();
        byte[] chunkData = new byte[length];
        buf.readBytes(chunkData);
        return new TextureChunkPayload(hash, textureType, chunkIndex, totalChunks, chunkData);
    });

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

