/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.networking.payloads;

import com.quickskin.mod.networking.payloads.PayloadCodecs;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record UploadTexturePayload(UUID playerId, String textureType, byte[] imageData) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UploadTexturePayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"upload_texture"));
    public static final StreamCodec<ByteBuf, UploadTexturePayload> CODEC = StreamCodec.of((buf, payload) -> {
        PayloadCodecs.writeUUID(buf, payload.playerId);
        PayloadCodecs.writeString(buf, payload.textureType);
        buf.writeInt(payload.imageData.length);
        buf.writeBytes(payload.imageData);
    }, buf -> {
        UUID playerId = PayloadCodecs.readUUID(buf);
        String textureType = PayloadCodecs.readString(buf);
        int length = buf.readInt();
        byte[] imageData = new byte[length];
        buf.readBytes(imageData);
        return new UploadTexturePayload(playerId, textureType, imageData);
    });

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

