/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.platform.neoforge;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;

public class PlatformHelperImpl {
    private static Method setPixelMethod;
    private static Method getPixelMethod;
    private static Field youngField;
    private static Field crouchingField;
    private static Field ridingField;
    private static Field attackTimeField;
    private static Method blitMethod;
    private static Method blitMethod2;
    private static Method renderCloakMethod;
    private static boolean methodsInitialized;
    private static boolean modelFieldsChecked;
    private static boolean blitMethodChecked;
    private static boolean blitMethod2Checked;
    private static boolean renderCloakMethodChecked;
    private static boolean usesNewPixelFormat;
    private static Object renderTypeGuiTextured;
    private static boolean renderTypeChecked;
    private static Field cloakField;
    private static boolean cloakFieldChecked;

    public static String getPlatformName() {
        return "NeoForge";
    }

    public static Path getGameDirectory() {
        return FMLPaths.GAMEDIR.get();
    }

    public static Path getSkinsDirectory() {
        return FMLPaths.GAMEDIR.get().resolve("quickskin").resolve("uploads").resolve("skins");
    }

    public static Path getCapesDirectory() {
        return FMLPaths.GAMEDIR.get().resolve("quickskin").resolve("uploads").resolve("capes");
    }

    public static Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static Path getCacheDirectory() {
        return FMLPaths.GAMEDIR.get().resolve("quickskin_cache");
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static String getModVersion() {
        return ModList.get().getModContainerById("quickskin").map(container -> container.getModInfo().getVersion().toString()).orElse("UNKNOWN");
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    private static void initializeMethods() {
        if (methodsInitialized) {
            return;
        }
        methodsInitialized = true;
        try {
            try {
                setPixelMethod = NativeImage.class.getMethod("setPixel", Integer.TYPE, Integer.TYPE, Integer.TYPE);
                getPixelMethod = NativeImage.class.getMethod("getPixel", Integer.TYPE, Integer.TYPE);
                usesNewPixelFormat = true;
            }
            catch (NoSuchMethodException e) {
                setPixelMethod = NativeImage.class.getMethod("setPixelRGBA", Integer.TYPE, Integer.TYPE, Integer.TYPE);
                getPixelMethod = NativeImage.class.getMethod("getPixelRGBA", Integer.TYPE, Integer.TYPE);
                usesNewPixelFormat = false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize NativeImage methods", e);
        }
    }

    private static int abgrToArgb(int abgr) {
        int a = abgr >> 24 & 0xFF;
        int b = abgr >> 16 & 0xFF;
        int g = abgr >> 8 & 0xFF;
        int r = abgr & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int argbToAbgr(int argb) {
        return PlatformHelperImpl.abgrToArgb(argb);
    }

    private static void initializeModelFields() {
        if (modelFieldsChecked) {
            return;
        }
        modelFieldsChecked = true;
        try {
            youngField = PlayerModel.class.getField("young");
        }
        catch (NoSuchFieldException e) {
            youngField = null;
        }
        try {
            crouchingField = PlayerModel.class.getField("crouching");
        }
        catch (NoSuchFieldException e) {
            crouchingField = null;
        }
        try {
            ridingField = PlayerModel.class.getField("riding");
        }
        catch (NoSuchFieldException e) {
            ridingField = null;
        }
        try {
            attackTimeField = PlayerModel.class.getField("attackTime");
        }
        catch (NoSuchFieldException e) {
            attackTimeField = null;
        }
    }

    public static void setPixel(NativeImage image, int x, int y, int color) {
        PlatformHelperImpl.initializeMethods();
        try {
            int colorToSet = color;
            if (usesNewPixelFormat) {
                colorToSet = PlatformHelperImpl.abgrToArgb(color);
            }
            setPixelMethod.invoke((Object)image, x, y, colorToSet);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set pixel", e);
        }
    }

    public static int getPixel(NativeImage image, int x, int y) {
        PlatformHelperImpl.initializeMethods();
        try {
            int color = (Integer)getPixelMethod.invoke((Object)image, x, y);
            if (usesNewPixelFormat) {
                color = PlatformHelperImpl.argbToAbgr(color);
            }
            return color;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get pixel", e);
        }
    }

    public static void setYoung(PlayerModel<?> model, boolean young) {
        PlatformHelperImpl.initializeModelFields();
        if (youngField != null) {
            try {
                youngField.setBoolean(model, young);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set young field", e);
            }
        }
    }

    public static void setCrouching(PlayerModel<?> model, boolean crouching) {
        PlatformHelperImpl.initializeModelFields();
        if (crouchingField != null) {
            try {
                crouchingField.setBoolean(model, crouching);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set crouching field", e);
            }
        }
    }

    public static void setRiding(PlayerModel<?> model, boolean riding) {
        PlatformHelperImpl.initializeModelFields();
        if (ridingField != null) {
            try {
                ridingField.setBoolean(model, riding);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set riding field", e);
            }
        }
    }

    public static void setAttackTime(PlayerModel<?> model, float attackTime) {
        PlatformHelperImpl.initializeModelFields();
        if (attackTimeField != null) {
            try {
                attackTimeField.setFloat(model, attackTime);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set attackTime field", e);
            }
        }
    }

    private static void initializeBlitMethod() {
        if (blitMethodChecked) {
            return;
        }
        blitMethodChecked = true;
        try {
            blitMethod = GuiGraphics.class.getMethod("blit", ResourceLocation.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                blitMethod = GuiGraphics.class.getMethod("blit", ResourceLocation.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                try {
                    blitMethod = GuiGraphics.class.getMethod("blit", Function.class, ResourceLocation.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    return;
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    try {
                        blitMethod = GuiGraphics.class.getMethod("blit", Function.class, ResourceLocation.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                        return;
                    }
                    catch (NoSuchMethodException noSuchMethodException4) {
                        StringBuilder availableMethods = new StringBuilder("Available blit methods in GuiGraphics:\n");
                        for (Method method : GuiGraphics.class.getMethods()) {
                            if (!method.getName().equals("blit")) continue;
                            availableMethods.append("  - blit(");
                            Class<?>[] params = method.getParameterTypes();
                            for (int i = 0; i < params.length; ++i) {
                                if (i > 0) {
                                    availableMethods.append(", ");
                                }
                                availableMethods.append(params[i].getSimpleName());
                            }
                            availableMethods.append(")\n");
                        }
                        throw new RuntimeException("Could not find any compatible blit method. " + availableMethods.toString());
                    }
                }
            }
        }
    }

    public static void blit(GuiGraphics graphics, ResourceLocation texture, int x, int y, int blitOffset, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        block7: {
            PlatformHelperImpl.initializeBlitMethod();
            try {
                Class<?>[] paramTypes = blitMethod.getParameterTypes();
                if (paramTypes.length > 0 && paramTypes[0].getName().equals("java.util.function.Function")) {
                    Object renderTypeFunction = PlatformHelperImpl.getRenderTypeGuiTextured();
                    if (paramTypes.length == 11) {
                        blitMethod.invoke((Object)graphics, renderTypeFunction, texture, x, y, blitOffset, Float.valueOf(u), Float.valueOf(v), width, height, textureWidth, textureHeight);
                        break block7;
                    }
                    if (paramTypes.length == 10) {
                        blitMethod.invoke((Object)graphics, renderTypeFunction, texture, x, y, Float.valueOf(u), Float.valueOf(v), width, height, textureWidth, textureHeight);
                        break block7;
                    }
                    throw new RuntimeException("Unexpected 1.21.2 blit method parameter count: " + paramTypes.length);
                }
                if (paramTypes.length == 10) {
                    blitMethod.invoke((Object)graphics, texture, x, y, blitOffset, Float.valueOf(u), Float.valueOf(v), width, height, textureWidth, textureHeight);
                    break block7;
                }
                if (paramTypes.length == 9) {
                    blitMethod.invoke((Object)graphics, texture, x, y, Float.valueOf(u), Float.valueOf(v), width, height, textureWidth, textureHeight);
                    break block7;
                }
                throw new RuntimeException("Unexpected blit method parameter count: " + paramTypes.length);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to call blit method", e);
            }
        }
    }

    private static Object getRenderTypeGuiTextured() {
        if (renderTypeChecked) {
            return renderTypeGuiTextured;
        }
        renderTypeChecked = true;
        try {
            String[] preferredNames;
            Class<?> renderTypeClass = Class.forName("net.minecraft.client.renderer.RenderType");
            Method guiMethod = null;
            for (String methodName : preferredNames = new String[]{"gui", "guiTextured", "guiTexture", "guiOverlay"}) {
                try {
                    guiMethod = renderTypeClass.getMethod(methodName, new Class[0]);
                    if (Modifier.isStatic(guiMethod.getModifiers()) && guiMethod.getParameterCount() == 0 && guiMethod.getReturnType().getName().equals(renderTypeClass.getName())) break;
                    guiMethod = null;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (guiMethod == null) {
                StringBuilder debug = new StringBuilder("Could not find suitable RenderType method. Available methods:\n");
                for (Method m : renderTypeClass.getMethods()) {
                    if (!Modifier.isStatic(m.getModifiers()) || m.getParameterCount() != 0) continue;
                    debug.append("  - ").append(m.getName()).append("() -> ").append(m.getReturnType().getName()).append("\n");
                }
                throw new RuntimeException(debug.toString());
            }
            final Method finalGuiMethod = guiMethod;
            renderTypeGuiTextured = new Function<ResourceLocation, Object>(){

                @Override
                public Object apply(ResourceLocation resourceLocation) {
                    try {
                        return finalGuiMethod.invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to invoke RenderType.gui()", e);
                    }
                }
            };
            return renderTypeGuiTextured;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to find RenderType class", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create RenderType function wrapper", e);
        }
    }

    private static void initializeBlitMethod2() {
        if (blitMethod2Checked) {
            return;
        }
        blitMethod2Checked = true;
        try {
            blitMethod2 = GuiGraphics.class.getMethod("blit", ResourceLocation.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                blitMethod2 = GuiGraphics.class.getMethod("blit", Function.class, ResourceLocation.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                StringBuilder availableMethods = new StringBuilder("Available blit methods in GuiGraphics for overload 2:\\n");
                for (Method method : GuiGraphics.class.getMethods()) {
                    if (!method.getName().equals("blit")) continue;
                    availableMethods.append("  - blit(");
                    Class<?>[] params = method.getParameterTypes();
                    for (int i = 0; i < params.length; ++i) {
                        if (i > 0) {
                            availableMethods.append(", ");
                        }
                        availableMethods.append(params[i].getSimpleName());
                    }
                    availableMethods.append(")\\n");
                }
                throw new RuntimeException("Could not find any compatible blit method (overload 2). " + availableMethods.toString());
            }
        }
    }

    public static void blit(GuiGraphics graphics, ResourceLocation texture, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        PlatformHelperImpl.initializeBlitMethod2();
        try {
            Class<?>[] paramTypes = blitMethod2.getParameterTypes();
            if (paramTypes.length > 0 && paramTypes[0].getName().equals("java.util.function.Function")) {
                Object renderTypeFunction = PlatformHelperImpl.getRenderTypeGuiTextured();
                blitMethod2.invoke((Object)graphics, renderTypeFunction, texture, x, y, Float.valueOf(u), Float.valueOf(v), width, height, textureWidth, textureHeight);
            } else {
                blitMethod2.invoke((Object)graphics, texture, x, y, width, height, Float.valueOf(u), Float.valueOf(v), regionWidth, regionHeight, textureWidth, textureHeight);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to call blit method (overload 2)", e);
        }
    }

    private static void initializeRenderCloakMethod() {
        if (renderCloakMethodChecked) {
            return;
        }
        renderCloakMethodChecked = true;
        try {
            renderCloakMethod = PlayerModel.class.getMethod("renderCloak", PoseStack.class, VertexConsumer.class, Integer.TYPE, Integer.TYPE);
            return;
        }
        catch (NoSuchMethodException e) {
            renderCloakMethod = null;
            return;
        }
    }

    private static void initializeCloakField() {
        if (cloakFieldChecked) {
            return;
        }
        cloakFieldChecked = true;
        try {
            cloakField = PlayerModel.class.getField("cloak");
        }
        catch (NoSuchFieldException e) {
            cloakField = null;
        }
    }

    public static void renderCloak(PlayerModel<?> model, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay) {
        PlatformHelperImpl.initializeRenderCloakMethod();
        if (renderCloakMethod != null) {
            try {
                renderCloakMethod.invoke(model, poseStack, vertexConsumer, packedLight, packedOverlay);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to call renderCloak method", e);
            }
        }
        PlatformHelperImpl.initializeCloakField();
        if (cloakField != null) {
            try {
                Object cloakPart = cloakField.get(model);
                if (cloakPart != null) {
                    Method renderMethod = cloakPart.getClass().getMethod("render", PoseStack.class, VertexConsumer.class, Integer.TYPE, Integer.TYPE);
                    renderMethod.invoke(cloakPart, poseStack, vertexConsumer, packedLight, packedOverlay);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to render cloak ModelPart directly", e);
            }
        }
    }

    static {
        methodsInitialized = false;
        modelFieldsChecked = false;
        blitMethodChecked = false;
        blitMethod2Checked = false;
        renderCloakMethodChecked = false;
        usesNewPixelFormat = false;
        renderTypeGuiTextured = null;
        renderTypeChecked = false;
        cloakFieldChecked = false;
    }
}

