/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.server.storage;

import com.quickskin.mod.QuickSkin;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.Nullable;

public class ServerAnimationCache {
    private static ServerAnimationCache instance;
    private final Map<String, String> metadataCache = new ConcurrentHashMap<String, String>();
    private Path storageDirectory;

    private ServerAnimationCache() {
    }

    public static ServerAnimationCache getInstance() {
        if (instance == null) {
            instance = new ServerAnimationCache();
        }
        return instance;
    }

    public void init(MinecraftServer server) {
        Path worldPath = server.getWorldPath(LevelResource.ROOT);
        this.storageDirectory = worldPath.resolve("quickskin").resolve("animations");
        try {
            Files.createDirectories(this.storageDirectory, new FileAttribute[0]);
            QuickSkin.LOGGER.info("ServerAnimationCache initialized at: {}", (Object)this.storageDirectory);
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to create animation storage directory", (Throwable)e);
        }
        this.loadCachedMetadata();
    }

    public void storeMetadata(String hash, String metadataJson) {
        this.metadataCache.put(hash, metadataJson);
        this.saveMetadataToDisk(hash, metadataJson);
        QuickSkin.LOGGER.debug("Stored animation metadata for: {}", (Object)hash);
    }

    @Nullable
    public String getMetadata(String hash) {
        return this.metadataCache.get(hash);
    }

    public void clear() {
        this.metadataCache.clear();
        QuickSkin.LOGGER.info("Cleared animation cache");
    }

    private void saveMetadataToDisk(String hash, String metadataJson) {
        if (this.storageDirectory == null) {
            return;
        }
        try {
            Path file = this.storageDirectory.resolve(hash + ".json");
            Files.writeString(file, (CharSequence)metadataJson, new OpenOption[0]);
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to save animation metadata: {}", (Object)hash, (Object)e);
        }
    }

    private void loadCachedMetadata() {
        if (this.storageDirectory == null || !Files.exists(this.storageDirectory, new LinkOption[0])) {
            return;
        }
        try {
            Files.list(this.storageDirectory).filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                try {
                    String hash = path.getFileName().toString().replace(".json", "");
                    String metadata = Files.readString(path);
                    this.metadataCache.put(hash, metadata);
                }
                catch (IOException e) {
                    QuickSkin.LOGGER.warn("Failed to load animation metadata: {}", path, (Object)e);
                }
            });
            QuickSkin.LOGGER.info("Loaded {} animation metadata entries from disk", (Object)this.metadataCache.size());
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to load cached animation metadata", (Throwable)e);
        }
    }
}

