/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.server.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.common.data.PlayerAppearance;
import com.quickskin.mod.server.data.ServerPlayerAppearanceRepository;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.Nullable;

public class ServerAppearanceStorage {
    private static ServerAppearanceStorage instance;
    private static final Gson GSON;
    private Path storageDirectory;

    private ServerAppearanceStorage() {
    }

    public static ServerAppearanceStorage getInstance() {
        if (instance == null) {
            instance = new ServerAppearanceStorage();
        }
        return instance;
    }

    public void init(MinecraftServer server) {
        Path worldPath = server.getWorldPath(LevelResource.ROOT);
        this.storageDirectory = worldPath.resolve("quickskin").resolve("appearances");
        try {
            Files.createDirectories(this.storageDirectory, new FileAttribute[0]);
            QuickSkin.LOGGER.info("ServerAppearanceStorage initialized at: {}", (Object)this.storageDirectory);
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to create appearance storage directory", (Throwable)e);
        }
    }

    @Nullable
    public PlayerAppearance loadPlayerAppearance(UUID playerId) {
        if (this.storageDirectory == null) {
            return null;
        }
        Path file = this.storageDirectory.resolve(playerId.toString() + ".json");
        if (!Files.exists(file, new LinkOption[0])) {
            QuickSkin.LOGGER.debug("No saved appearance for player: {}", (Object)playerId);
            return null;
        }
        try {
            String json = Files.readString(file);
            PlayerAppearance appearance = (PlayerAppearance)GSON.fromJson(json, PlayerAppearance.class);
            ServerPlayerAppearanceRepository.getInstance().setAppearance(appearance);
            QuickSkin.LOGGER.info("Loaded appearance for player: {} (skin={}, cape={}, model={})", new Object[]{playerId, appearance.getSkinId(), appearance.getCapeId(), appearance.getModel()});
            return appearance;
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to load appearance for player: {}", (Object)playerId, (Object)e);
            return null;
        }
    }

    public void savePlayerAppearance(UUID playerId) {
        if (this.storageDirectory == null) {
            return;
        }
        PlayerAppearance appearance = ServerPlayerAppearanceRepository.getInstance().getAppearance(playerId);
        if (appearance == null) {
            QuickSkin.LOGGER.debug("No appearance to save for player: {}", (Object)playerId);
            return;
        }
        Path file = this.storageDirectory.resolve(playerId.toString() + ".json");
        try {
            String json = GSON.toJson((Object)appearance);
            Files.writeString(file, (CharSequence)json, new OpenOption[0]);
            QuickSkin.LOGGER.debug("Saved appearance for player: {}", (Object)playerId);
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to save appearance for player: {}", (Object)playerId, (Object)e);
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

